/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.tmcc;

import jmri.implementation.AbstractTurnout;
import jmri.jmrix.tmcc.SerialMessage;
import jmri.jmrix.tmcc.SerialTrafficController;
import jmri.jmrix.tmcc.TmccSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialTurnout
extends AbstractTurnout {
    int _number;
    private SerialTrafficController tc = null;
    protected String _prefix = "T";
    private static final Logger log = LoggerFactory.getLogger(SerialTurnout.class);

    public SerialTurnout(String prefix, int number, TmccSystemConnectionMemo memo) {
        super(String.valueOf(prefix) + "T" + number);
        this.tc = memo.getTrafficController();
        this._number = number;
        this._prefix = prefix;
    }

    @Override
    protected void forwardCommandChangeToLayout(int newState) {
        if ((newState & 2) != 0) {
            if ((newState & 4) != 0) {
                log.error("Cannot command both CLOSED and THROWN {}", (Object)newState);
                return;
            }
            this.sendMessage(true ^ this.getInverted());
        } else {
            this.sendMessage(this.getInverted());
        }
    }

    @Override
    protected void turnoutPushbuttonLockout(boolean _pushButtonLockout) {
        if (log.isDebugEnabled()) {
            log.debug("Send command to {} Pushbutton {}T{}", new Object[]{_pushButtonLockout ? "Lock" : "Unlock", this._prefix, this._number});
        }
    }

    protected void sendMessage(boolean closed) {
        SerialMessage m = new SerialMessage();
        m.setOpCode(254);
        if (closed) {
            m.putAsWord(16384 + this._number * 128);
        } else {
            m.putAsWord(16415 + this._number * 128);
        }
        this.tc.sendSerialMessage(m, null);
        this.tc.sendSerialMessage(m, null);
        this.tc.sendSerialMessage(m, null);
        this.tc.sendSerialMessage(m, null);
    }
}

