/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.tmcc;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jmri.DccLocoAddress;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.jmrix.AbstractThrottle;
import jmri.jmrix.tmcc.SerialMessage;
import jmri.jmrix.tmcc.SerialTrafficController;
import jmri.jmrix.tmcc.TmccSystemConnectionMemo;

public class SerialThrottle
extends AbstractThrottle {
    private final DccLocoAddress address;
    private final SerialTrafficController tc;
    private static final int[] SERIAL_FUNCTION_CODES;

    static {
        int[] nArray = new int[28];
        nArray[0] = 13;
        nArray[1] = 29;
        nArray[2] = 28;
        nArray[3] = 5;
        nArray[4] = 6;
        nArray[5] = 16;
        nArray[6] = 17;
        nArray[7] = 18;
        nArray[8] = 19;
        nArray[9] = 20;
        nArray[10] = 21;
        nArray[11] = 22;
        nArray[12] = 23;
        nArray[13] = 24;
        nArray[14] = 25;
        nArray[15] = 9;
        nArray[16] = 30;
        nArray[18] = 3;
        nArray[19] = 1;
        nArray[20] = 4;
        nArray[21] = 7;
        nArray[22] = 71;
        nArray[23] = 67;
        nArray[24] = 40;
        nArray[25] = 41;
        nArray[26] = 42;
        nArray[27] = 43;
        SERIAL_FUNCTION_CODES = nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SerialThrottle(TmccSystemConnectionMemo memo, DccLocoAddress address) {
        super(memo);
        this.tc = memo.getTrafficController();
        SerialThrottle serialThrottle = this;
        synchronized (serialThrottle) {
            this.speedSetting = 0.0f;
        }
        this.address = address;
        this.isForward = true;
        this.speedStepMode = SpeedStepMode.TMCC_32;
    }

    @Override
    public LocoAddress getLocoAddress() {
        return this.address;
    }

    @Override
    public void setFunction(int func, boolean value) {
        this.updateFunction(func, value);
        if (func >= 0 && func < 22) {
            this.sendToLayout(SERIAL_FUNCTION_CODES[func] + this.address.getNumber() * 128);
        } else {
            super.setFunction(func, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"})
    public void setSpeedSetting(float speed) {
        float oldSpeed;
        SerialThrottle serialThrottle = this;
        synchronized (serialThrottle) {
            oldSpeed = this.speedSetting;
            this.speedSetting = speed;
        }
        int value = (int)(32.0f * speed);
        if (value > 31) {
            value = 31;
        }
        SerialMessage m = new SerialMessage();
        if (value < 0) {
            m.putAsWord(96 + this.address.getNumber() * 128 + 0);
        } else {
            m.putAsWord(96 + this.address.getNumber() * 128 + value);
        }
        this.tc.sendSerialMessage(m, null);
        this.tc.sendSerialMessage(m, null);
        this.tc.sendSerialMessage(m, null);
        this.tc.sendSerialMessage(m, null);
        SerialThrottle serialThrottle2 = this;
        synchronized (serialThrottle2) {
            this.firePropertyChange("SpeedSetting", Float.valueOf(oldSpeed), Float.valueOf(this.speedSetting));
        }
        this.record(speed);
    }

    @Override
    public void setIsForward(boolean forward) {
        boolean old = this.isForward;
        this.isForward = forward;
        SerialMessage m = new SerialMessage();
        if (forward) {
            m.putAsWord(0 + this.address.getNumber() * 128);
        } else {
            m.putAsWord(3 + this.address.getNumber() * 128);
        }
        this.tc.sendSerialMessage(m, null);
        this.tc.sendSerialMessage(m, null);
        this.tc.sendSerialMessage(m, null);
        this.tc.sendSerialMessage(m, null);
        this.firePropertyChange("IsForward", old, this.isForward);
    }

    protected void sendToLayout(int value) {
        this.tc.sendSerialMessage(new SerialMessage(value), null);
        this.tc.sendSerialMessage(new SerialMessage(value), null);
        this.tc.sendSerialMessage(new SerialMessage(value), null);
        this.tc.sendSerialMessage(new SerialMessage(value), null);
    }

    @Override
    public void setSpeedStepMode(SpeedStepMode Mode) {
    }

    @Override
    public void throttleDispose() {
        this.finishRecord();
    }
}

