/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.tams.swing.locodatabase;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableRowSorter;
import jmri.InstanceManager;
import jmri.jmrix.tams.TamsMessage;
import jmri.jmrix.tams.TamsSystemConnectionMemo;
import jmri.jmrix.tams.swing.TamsNamedPaneAction;
import jmri.jmrix.tams.swing.TamsPanel;
import jmri.jmrix.tams.swing.locodatabase.Bundle;
import jmri.jmrix.tams.swing.locodatabase.LocoDataModel;
import jmri.util.swing.sdi.JmriJFrameInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocoDataPane
extends TamsPanel {
    LocoDataModel locoModel;
    JTable locoTable;
    JScrollPane locoScroll;
    String[] speed = new String[]{"126", "14", "27", "28"};
    String[] fmt = new String[]{"DCC", "MM1", "MM2"};
    JTextField addr = new JTextField(5);
    JTextField name = new JTextField(10);
    JComboBox<String> speedBox = new JComboBox<String>(this.speed);
    JComboBox<String> formatBox = new JComboBox<String>(this.fmt);
    JButton addButton = new JButton(Bundle.getMessage("AddLoco"));
    private static final Logger log = LoggerFactory.getLogger(LocoDataPane.class);

    @Override
    public void initComponents(TamsSystemConnectionMemo memo) {
        super.initComponents(memo);
        this.locoModel = new LocoDataModel(128, 16, memo);
        this.locoTable = new JTable(this.locoModel);
        this.locoTable.setRowSorter(new TableRowSorter<LocoDataModel>(this.locoModel));
        this.locoScroll = new JScrollPane(this.locoTable);
        this.locoModel.configureTable(this.locoTable);
        this.setLayout(new BoxLayout(this, 1));
        JPanel pane1 = new JPanel();
        pane1.setLayout(new FlowLayout());
        pane1.add(new JLabel(Bundle.getMessage("Address")));
        pane1.add(this.addr);
        pane1.add(new JLabel(Bundle.getMessage("Name")));
        pane1.add(this.name);
        pane1.add(new JLabel(Bundle.getMessage("Steps")));
        pane1.add(this.speedBox);
        pane1.add(new JLabel(Bundle.getMessage("Format")));
        pane1.add(this.formatBox);
        pane1.add(this.addButton);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocoDataPane.this.addLoco();
            }
        });
        this.add(pane1);
        this.add(this.locoScroll);
        if (pane1.getMaximumSize().height > 0 && pane1.getMaximumSize().width > 0) {
            pane1.setMaximumSize(pane1.getPreferredSize());
        }
    }

    void addLoco() {
        if (this.addr.getText() == null || this.addr.getText().equals("")) {
            log.error("Require an address to be entered");
            JOptionPane.showMessageDialog(null, Bundle.getMessage("ErrorNullAddress"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        try {
            Integer.valueOf(this.addr.getText());
        }
        catch (NumberFormatException numberFormatException) {
            log.error("Unable to convert {} to a number", (Object)this.addr.getText());
            JOptionPane.showMessageDialog(null, Bundle.getMessage("ErrorNotNumber"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("xLOCADD ");
        sb.append(this.addr.getText());
        sb.append(",");
        sb.append(this.speedBox.getSelectedItem());
        sb.append(",");
        sb.append(this.formatBox.getSelectedItem());
        sb.append(",'");
        sb.append(this.name.getText());
        sb.append("'");
        TamsMessage m = new TamsMessage(sb.toString());
        this.locoModel.addLoco(m);
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.tams.swing.locodatabase.LocoDataFrame";
    }

    @Override
    public String getTitle() {
        return Bundle.getMessage("Title");
    }

    @Override
    public void dispose() {
        this.locoModel.dispose();
        this.locoModel = null;
        this.locoTable = null;
        this.locoScroll = null;
        super.dispose();
    }

    public static class Default
    extends TamsNamedPaneAction {
        public Default() {
            super(Bundle.getMessage("Title"), new JmriJFrameInterface(), LocoDataPane.class.getName(), InstanceManager.getDefault(TamsSystemConnectionMemo.class));
        }
    }
}

