/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.tams.swing.locodatabase;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import jmri.jmrix.tams.TamsListener;
import jmri.jmrix.tams.TamsMessage;
import jmri.jmrix.tams.TamsReply;
import jmri.jmrix.tams.TamsSystemConnectionMemo;
import jmri.jmrix.tams.swing.locodatabase.Bundle;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocoDataModel
extends AbstractTableModel
implements TamsListener {
    public static final int ADDRCOLUMN = 0;
    public static final int SPDCOLUMN = 1;
    public static final int FMTCOLUMN = 2;
    public static final int NAMECOLUMN = 3;
    public static final int DELCOLUMN = 4;
    public static final int NUMCOLUMN = 5;
    TamsSystemConnectionMemo memo;
    ArrayList<String[]> locolist = new ArrayList();
    private static final Logger log = LoggerFactory.getLogger(LocoDataModel.class);

    LocoDataModel(int row, int column, TamsSystemConnectionMemo memo) {
        this.memo = memo;
        TamsMessage m = new TamsMessage("xLOCDUMP");
        memo.getTrafficController().sendTamsMessage(m, this);
    }

    @Override
    public int getRowCount() {
        return this.locolist.size();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("ColAddress");
            }
            case 1: {
                return Bundle.getMessage("ColSteps");
            }
            case 2: {
                return Bundle.getMessage("ColFormat");
            }
            case 3: {
                return Bundle.getMessage("ColName");
            }
            case 4: {
                return Bundle.getMessage("ColDelete");
            }
        }
        return "unknown";
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 4: {
                return JButton.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 4: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.locolist.size() == 0) {
            return null;
        }
        String[] loco = this.locolist.get(row);
        try {
            switch (col) {
                case 0: {
                    return loco[0];
                }
                case 1: {
                    return loco[1];
                }
                case 2: {
                    return loco[2];
                }
                case 3: {
                    return loco[3];
                }
                case 4: {
                    return "delete";
                }
            }
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
        log.error("internal state inconsistent with table request for {} {}", (Object)row, (Object)col);
        return null;
    }

    @SuppressFBWarnings(value={"DB_DUPLICATE_SWITCH_CLAUSES"}, justification="better to keep cases in column order rather than to combine")
    public int getPreferredWidth(int col) {
        switch (col) {
            case 0: {
                return new JTextField((int)5).getPreferredSize().width;
            }
            case 1: {
                return new JTextField((int)6).getPreferredSize().width;
            }
            case 2: {
                return new JTextField((int)6).getPreferredSize().width;
            }
            case 3: {
                return new JTextField((int)12).getPreferredSize().width;
            }
            case 4: {
                return new JButton((String)Bundle.getMessage((String)"DeleteLoco")).getPreferredSize().width;
            }
        }
        return new JLabel((String)" <unknown> ").getPreferredSize().width;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 4) {
            this.deleteLoco(row);
        }
    }

    void deleteLoco(int row) {
        this.locolist.remove(row);
        TamsMessage m = new TamsMessage("xLOCCLEAR");
        this.memo.getTrafficController().sendTamsMessage(m, this);
        for (String[] loco : this.locolist) {
            m = new TamsMessage("xLOCADD " + loco[0] + ", " + loco[1] + ", " + loco[2] + ", '" + loco[3] + "'");
            this.memo.getTrafficController().sendTamsMessage(m, this);
        }
        m = new TamsMessage("xLOCDUMP");
        this.memo.getTrafficController().sendTamsMessage(m, this);
    }

    public void configureTable(JTable slotTable) {
        slotTable.getTableHeader().setReorderingAllowed(true);
        slotTable.setAutoResizeMode(0);
        int i = 0;
        while (i < slotTable.getColumnCount()) {
            int width = this.getPreferredWidth(i);
            slotTable.getColumnModel().getColumn(i).setPreferredWidth(width);
            ++i;
        }
        slotTable.sizeColumnsToFit(-1);
        this.setColumnToHoldButton(slotTable, 4);
    }

    void setColumnToHoldButton(JTable slotTable, int column) {
        TableColumnModel tcm = slotTable.getColumnModel();
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        tcm.getColumn(column).setCellRenderer(buttonRenderer);
        ButtonEditor buttonEditor = new ButtonEditor(new JButton());
        tcm.getColumn(column).setCellEditor(buttonEditor);
        slotTable.setRowHeight(new JButton((String)new StringBuilder((String)"  ").append((Object)this.getValueAt((int)1, (int)column)).toString()).getPreferredSize().height);
        slotTable.getColumnModel().getColumn(column).setPreferredWidth(new JButton((String)new StringBuilder((String)"  ").append((Object)this.getValueAt((int)1, (int)column)).toString()).getPreferredSize().width);
    }

    void setColumnToHoldEStopButton(JTable slotTable, int column) {
        TableColumnModel tcm = slotTable.getColumnModel();
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        tcm.getColumn(column).setCellRenderer(buttonRenderer);
        ButtonEditor buttonEditor = new ButtonEditor(new JButton()){

            @Override
            public void mousePressed(MouseEvent e) {
                this.stopCellEditing();
            }
        };
        tcm.getColumn(column).setCellEditor(buttonEditor);
        slotTable.setRowHeight(new JButton((String)new StringBuilder((String)"  ").append((Object)this.getValueAt((int)1, (int)column)).toString()).getPreferredSize().height);
        slotTable.getColumnModel().getColumn(column).setPreferredWidth(new JButton((String)new StringBuilder((String)"  ").append((Object)this.getValueAt((int)1, (int)column)).toString()).getPreferredSize().width);
    }

    public void dispose() {
    }

    @Override
    public void message(TamsMessage m) {
    }

    @Override
    public void reply(TamsReply r) {
        if (r != null) {
            if (r.match("xLOCADD") >= 0) {
                TamsMessage m = new TamsMessage("xLOCDUMP");
                this.memo.getTrafficController().sendTamsMessage(m, this);
            } else {
                this.locolist = new ArrayList();
                String msg = r.toString();
                String[] rawlocolist = msg.split("\\r");
                log.info("Raw loco list length: {}", (Object)rawlocolist.length);
                String[] stringArray = rawlocolist;
                int n = rawlocolist.length;
                int n2 = 0;
                while (n2 < n) {
                    String loco = stringArray[n2];
                    log.info(loco);
                    if (loco.equals("*END*")) break;
                    String[] locodetails = loco.split(",");
                    this.locolist.add(locodetails);
                    ++n2;
                }
                this.fireTableDataChanged();
            }
        }
    }

    protected void addLoco(TamsMessage m) {
        this.memo.getTrafficController().sendTamsMessage(m, this);
    }
}

