/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.tams.swing;

import javax.swing.JMenu;
import javax.swing.JSeparator;
import jmri.InstanceManager;
import jmri.jmrit.beantable.ListedTableFrame;
import jmri.jmrix.tams.TamsSystemConnectionMemo;
import jmri.jmrix.tams.swing.Bundle;
import jmri.jmrix.tams.swing.TamsNamedPaneAction;
import jmri.util.swing.sdi.JmriJFrameInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TamsMenu
extends JMenu {
    Item[] panelItems = new Item[]{new Item("MenuItemTamsMonitor", "jmri.jmrix.tams.swing.monitor.TamsMonPane"), new Item("MenuItemSendPacket", "jmri.jmrix.tams.swing.packetgen.PacketGenPanel"), new Item("MenuItemInfo", "jmri.jmrix.tams.swing.statusframe.StatusPanel"), new Item("MenuItemLocoData", "jmri.jmrix.tams.swing.locodatabase.LocoDataPane")};
    private static final Logger log = LoggerFactory.getLogger(TamsMenu.class);

    public TamsMenu(TamsSystemConnectionMemo memo) {
        if (memo != null) {
            this.setText(memo.getUserName());
        } else {
            this.setText(Bundle.getMessage("MenuTams"));
        }
        JmriJFrameInterface wi = new JmriJFrameInterface();
        Item[] itemArray = this.panelItems;
        int n = this.panelItems.length;
        int n2 = 0;
        while (n2 < n) {
            Item item = itemArray[n2];
            if (item == null) {
                this.add(new JSeparator());
            } else {
                this.add(new TamsNamedPaneAction(Bundle.getMessage(item.name), wi, item.load, memo));
            }
            ++n2;
        }
        if (InstanceManager.getNullableDefault(ListedTableFrame.class) == null) {
            try {
                new ListedTableFrame();
            }
            catch (NullPointerException nullPointerException) {
                log.error("Unable to register Tams table");
            }
        }
    }

    static class Item {
        String name;
        String load;

        Item(String name, String load) {
            this.name = name;
            this.load = load;
        }
    }
}

