/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.tams;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.ConcurrentLinkedQueue;
import jmri.CommandStation;
import jmri.InstanceManager;
import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.AbstractMRTrafficController;
import jmri.jmrix.tams.TamsInterface;
import jmri.jmrix.tams.TamsListener;
import jmri.jmrix.tams.TamsMessage;
import jmri.jmrix.tams.TamsReply;
import jmri.jmrix.tams.TamsSystemConnectionMemo;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TamsTrafficController
extends AbstractMRTrafficController
implements TamsInterface,
CommandStation {
    TamsSystemConnectionMemo adaptermemo;
    ConcurrentLinkedQueue<PollMessage> pollQueue = new ConcurrentLinkedQueue();
    boolean disablePoll = false;
    protected static char replyType;
    protected static boolean replyBinary;
    protected static boolean replyOneByte;
    protected static int replyLastByte;
    protected static boolean unsolicitedSensorMessageSeen;
    @SuppressFBWarnings(value={"MS_PKGPROTECT"})
    protected static final TamsTrafficController self;
    protected int myCounter = 0;
    protected int groupSize = 0;
    protected boolean endReached = false;
    protected int numberOfNibbles = 0;
    protected int messageLength = 0;
    protected int index = 0;
    private boolean _isBinary;
    protected int[] _dataChars = null;
    protected int _nDataChars = 0;
    private static final Logger log;

    static {
        unsolicitedSensorMessageSeen = false;
        self = null;
        log = LoggerFactory.getLogger(TamsTrafficController.class);
    }

    public TamsTrafficController() {
        log.debug("creating a new TamsTrafficController object");
        log.debug("Just a silly change to force an staged change");
        InstanceManager.store(this, CommandStation.class);
        super.setAllowUnexpectedReply(false);
    }

    public void setAdapterMemo(TamsSystemConnectionMemo memo) {
        this.adaptermemo = memo;
        log.trace("setAdapterMemo method");
    }

    @Override
    public String getUserName() {
        if (this.adaptermemo == null) {
            return "Tams";
        }
        return this.adaptermemo.getUserName();
    }

    @Override
    public String getSystemPrefix() {
        if (this.adaptermemo == null) {
            return "T";
        }
        return this.adaptermemo.getSystemPrefix();
    }

    @Override
    public synchronized void addTamsListener(TamsListener l) {
        this.addListener(l);
    }

    @Override
    public synchronized void removeTamsListener(TamsListener l) {
        this.removeListener(l);
    }

    @Override
    protected int enterProgModeDelayTime() {
        return 1000;
    }

    @Override
    public boolean sendPacket(byte[] packet, int count) {
        log.trace("*** sendPacket ***");
        return true;
    }

    @Override
    protected void forwardMessage(AbstractMRListener client, AbstractMRMessage m) {
        log.trace("*** forwardMessage ***");
        ((TamsListener)client).message((TamsMessage)m);
    }

    @Override
    protected void forwardReply(AbstractMRListener client, AbstractMRReply tr) {
        log.trace("*** forward Tams Reply ***");
        ((TamsListener)client).reply((TamsReply)tr);
    }

    public boolean getPollQueueDisabled() {
        return this.disablePoll;
    }

    public void setPollQueueDisabled(boolean poll) {
        this.disablePoll = poll;
    }

    public void addPollMessage(TamsMessage tm, TamsListener tl) {
        log.trace("*** add Tams Poll Message ***");
        tm.setTimeout(1000);
        boolean found = false;
        for (PollMessage pm : this.pollQueue) {
            log.trace("comparing poll messages: {} {}", (Object)pm.getMessage(), (Object)tm);
            if (pm.getListener() != tl || !pm.getMessage().toString().equals(tm.toString())) continue;
            log.debug("Message is already in the poll queue so will not add");
            found = true;
        }
        if (!found) {
            PollMessage pm;
            log.trace("Added to poll queue = {}", (Object)tm);
            pm = new PollMessage(tm, tl);
            this.pollQueue.offer(pm);
        }
    }

    public void removePollMessage(TamsMessage tm, TamsListener tl) {
        log.trace("*** remove Tams Poll Message ***");
        for (PollMessage pm : this.pollQueue) {
            if (pm.getListener() != tl || !pm.getMessage().toString().equals(tm.toString())) continue;
            this.pollQueue.remove(pm);
        }
    }

    @Override
    protected TamsMessage pollMessage() {
        PollMessage pm;
        log.trace("*** Tams Poll Message ***");
        if (this.disablePoll) {
            log.trace("Nothing in the Poll Queue");
            return null;
        }
        if (!this.pollQueue.isEmpty() && (pm = this.pollQueue.peek()) != null) {
            log.trace("PollMessage = {}", (Object)pm.getMessage());
            return pm.getMessage();
        }
        return null;
    }

    @Override
    protected AbstractMRListener pollReplyHandler() {
        PollMessage pm;
        log.trace("*** Tams Poll Reply Handler ***");
        if (this.disablePoll) {
            return null;
        }
        if (!this.pollQueue.isEmpty() && (pm = this.pollQueue.poll()) != null) {
            this.pollQueue.offer(pm);
            return pm.getListener();
        }
        return null;
    }

    @Override
    public void sendTamsMessage(TamsMessage tm, TamsListener tl) {
        log.trace("*** Send Tams Message ***");
        if (log.isTraceEnabled()) {
            if (tm.isBinary()) {
                log.trace("Binary TamsMessage = {} {} and replyType = {}", new Object[]{StringUtil.appendTwoHexFromInt(tm.getElement(0) & 0xFF, ""), StringUtil.appendTwoHexFromInt(tm.getElement(1) & 0xFF, ""), Character.valueOf(tm.getReplyType())});
            } else {
                log.trace("ASCII TamsMessage = {} and replyType = {}", (Object)tm, (Object)Character.valueOf(tm.getReplyType()));
            }
        }
        this.sendMessage(tm, tl);
    }

    @Override
    protected void forwardToPort(AbstractMRMessage tm, AbstractMRListener reply) {
        log.trace("*** Forward Tams Message to Port ***");
        replyBinary = tm.isBinary();
        replyType = ((TamsMessage)tm).getReplyType();
        replyOneByte = ((TamsMessage)tm).getReplyOneByte();
        replyLastByte = ((TamsMessage)tm).getReplyLastByte();
        super.forwardToPort(tm, reply);
    }

    @Override
    protected TamsMessage enterProgMode() {
        return null;
    }

    @Override
    protected TamsMessage enterNormalMode() {
        return null;
    }

    protected void addTrailerToOutput(byte[] msg, int offset, TamsMessage m) {
        log.trace("*** Tams Add Trailer to Output ***");
        if (!m.isBinary()) {
            msg[offset] = 13;
        }
    }

    protected int lengthOfByteStream(TamsMessage m) {
        log.trace("*** Tams Length of Byte Stream ***");
        int len = m.getNumDataElements();
        int cr = 0;
        if (!m.isBinary()) {
            cr = 1;
        }
        log.trace("length ByteStream = {}, message = |{}|", (Object)(len + cr), (Object)m);
        return len + cr;
    }

    @Override
    protected TamsReply newReply() {
        log.trace("*** Tams Reply ***");
        TamsReply reply = new TamsReply();
        return reply;
    }

    @Override
    protected boolean endOfMessage(AbstractMRReply reply) {
        TamsReply tr = (TamsReply)reply;
        log.trace("*** Tams End of Message ***");
        this.index = tr.getNumDataElements() - 1;
        if (log.isTraceEnabled()) {
            log.trace("Reading byte number = {}, value = {}", (Object)tr.getNumDataElements(), (Object)StringUtil.appendTwoHexFromInt(tr.getElement(this.index) & 0xFF, ""));
        }
        if (replyBinary) {
            if (replyOneByte) {
                if (tr.getNumDataElements() < 1) {
                    this.endReached = false;
                } else {
                    if (log.isTraceEnabled()) {
                        log.trace("One byte binary reply = {}", (Object)StringUtil.appendTwoHexFromInt(tr.getElement(this.index) & 0xFF, ""));
                    }
                    this.myCounter = 0;
                    this.endReached = true;
                }
            } else {
                if (replyType == 'S') {
                    log.trace("*** Receiving Sensor Reply ***");
                    this.groupSize = 3;
                    log.trace("Looking for byte# = {} and index = {} and expect as last byte = {}", new Object[]{this.groupSize * this.myCounter + 1, this.index, replyLastByte});
                    if (tr.getNumDataElements() == this.groupSize * this.myCounter + 1 && tr.getElement(this.index) == replyLastByte) {
                        this.myCounter = 0;
                        this.endReached = true;
                        log.trace("S - End reached!");
                    } else {
                        if (tr.getNumDataElements() == this.groupSize * this.myCounter + 1) {
                            ++this.myCounter;
                        }
                        this.endReached = false;
                    }
                }
                if (replyType == 'T') {
                    log.trace("*** Receiving Turnout Reply ***");
                    this.numberOfNibbles = tr.getElement(0);
                    if (this.numberOfNibbles > 50) {
                        this.numberOfNibbles = 50;
                    }
                    this.messageLength = this.numberOfNibbles * 2;
                    log.trace("Number of turnout events# = {}", (Object)this.numberOfNibbles);
                    if (this.myCounter < this.messageLength) {
                        log.trace("myCounter = {}, reply length= {}", (Object)this.myCounter, (Object)tr.getNumDataElements());
                        ++this.myCounter;
                        this.endReached = false;
                    } else {
                        this.myCounter = 0;
                        this.endReached = true;
                        log.trace("myCounter = {}", (Object)this.myCounter);
                        log.trace("T - End reached!");
                    }
                }
                if (replyType == 'L') {
                    log.trace("*** Receiving Loco Reply ***");
                    if (log.isTraceEnabled()) {
                        log.trace("Current byte = {}", (Object)StringUtil.appendTwoHexFromInt(tr.getElement(this.index) & 0xFF, ""));
                    }
                    this.groupSize = 5;
                    if ((tr.getElement(this.index) & 0xFF) == 128) {
                        this.myCounter = 0;
                        this.endReached = true;
                        if (this.index > 1 && log.isTraceEnabled()) {
                            log.trace("reply = {} {} {} {} {}", new Object[]{StringUtil.appendTwoHexFromInt(tr.getElement(0) & 0xFF, ""), StringUtil.appendTwoHexFromInt(tr.getElement(1) & 0xFF, ""), StringUtil.appendTwoHexFromInt(tr.getElement(2) & 0xFF, ""), StringUtil.appendTwoHexFromInt(tr.getElement(3) & 0xFF, ""), StringUtil.appendTwoHexFromInt(tr.getElement(4) & 0xFF, "")});
                        }
                        log.trace("L - End reached!");
                    } else {
                        if (tr.getNumDataElements() == this.groupSize * this.myCounter + 1) {
                            ++this.myCounter;
                        }
                        this.endReached = false;
                    }
                }
            }
        } else if (tr.getNumDataElements() > 0 && tr.getElement(this.index) != 93) {
            log.trace("Building ASCII reply = {}", (Object)tr);
            this.endReached = false;
        } else {
            log.trace("ASCII reply = {} isBinary = {}", (Object)tr, (Object)replyBinary);
            this.myCounter = 0;
            this.endReached = true;
        }
        log.trace("End of Message = {}", (Object)this.endReached);
        return this.endReached;
    }

    public String toString() {
        String s = "";
        int i = 0;
        while (i < this._nDataChars) {
            if (this._isBinary) {
                if (i != 0) {
                    s = String.valueOf(s) + " ";
                }
                s = StringUtil.appendTwoHexFromInt(this._dataChars[i] & 0xFF, s);
            } else {
                s = String.valueOf(s) + (char)this._dataChars[i];
            }
            ++i;
        }
        return s;
    }

    static class PollMessage {
        TamsListener tl;
        TamsMessage tm;

        PollMessage(TamsMessage tm, TamsListener tl) {
            log.trace("*** Tams Poll Message ***");
            this.tm = tm;
            this.tl = tl;
        }

        TamsListener getListener() {
            return this.tl;
        }

        TamsMessage getMessage() {
            return this.tm;
        }
    }
}

