/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.tams;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jmri.ProgListener;
import jmri.ProgrammerException;
import jmri.ProgrammingMode;
import jmri.jmrix.AbstractProgrammer;
import jmri.jmrix.tams.TamsListener;
import jmri.jmrix.tams.TamsMessage;
import jmri.jmrix.tams.TamsReply;
import jmri.jmrix.tams.TamsTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TamsProgrammer
extends AbstractProgrammer
implements TamsListener {
    protected TamsTrafficController tc;
    int progState = 0;
    static final int NOTPROGRAMMING = 0;
    static final int COMMANDSENT = 2;
    static final int COMMANDSENT_2 = 4;
    boolean _progRead = false;
    int _val;
    int _cv;
    private ProgListener _usingProgrammer = null;
    private static final Logger log = LoggerFactory.getLogger(TamsProgrammer.class);

    public TamsProgrammer(TamsTrafficController tc) {
        this.tc = tc;
        this.SHORT_TIMEOUT = 6000;
    }

    @Override
    @Nonnull
    public List<ProgrammingMode> getSupportedModes() {
        ArrayList<ProgrammingMode> ret = new ArrayList<ProgrammingMode>();
        ret.add(ProgrammingMode.PAGEMODE);
        ret.add(ProgrammingMode.DIRECTBITMODE);
        ret.add(ProgrammingMode.DIRECTBYTEMODE);
        ret.add(ProgrammingMode.REGISTERMODE);
        return ret;
    }

    @Override
    public synchronized void writeCV(String CVname, int val, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        if (log.isDebugEnabled()) {
            log.debug("writeCV {} listens {}", (Object)CV, (Object)p);
        }
        this.useProgrammer(p);
        this._progRead = false;
        this.progState = 2;
        this._val = val;
        this._cv = CV;
        try {
            this.startLongTimer();
            this.tc.sendTamsMessage(this.progTaskStart(this._val, this._cv), this);
        }
        catch (ProgrammerException e) {
            this.useProgrammer(null);
            this.progState = 0;
            throw e;
        }
    }

    @Override
    public void confirmCV(String CV, int val, ProgListener p) throws ProgrammerException {
        this.readCV(CV, p);
    }

    @Override
    public synchronized void readCV(String CVname, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        if (log.isDebugEnabled()) {
            log.debug("readCV {} listens {}", (Object)CV, (Object)p);
        }
        this.useProgrammer(p);
        this._progRead = true;
        this.progState = 2;
        this._cv = CV;
        try {
            this.startLongTimer();
            this.tc.sendTamsMessage(this.progTaskStart(-1, this._cv), this);
        }
        catch (ProgrammerException e) {
            this.useProgrammer(null);
            this.progState = 0;
            throw e;
        }
    }

    protected void useProgrammer(ProgListener p) throws ProgrammerException {
        if (this._usingProgrammer != null && this._usingProgrammer != p) {
            if (log.isInfoEnabled()) {
                log.info("programmer already in use by {}", (Object)this._usingProgrammer);
            }
            throw new ProgrammerException("programmer in use");
        }
        this._usingProgrammer = p;
    }

    protected TamsMessage progTaskStart(int val, int cvnum) throws ProgrammerException {
        if (val < 0) {
            if (this.getMode() == ProgrammingMode.PAGEMODE) {
                return TamsMessage.getReadPagedCV(cvnum);
            }
            if (this.getMode() == ProgrammingMode.DIRECTBYTEMODE) {
                return TamsMessage.getReadDirectByteCV(cvnum);
            }
            return TamsMessage.getReadRegister(this.registerFromCV(cvnum));
        }
        if (this.getMode() == ProgrammingMode.PAGEMODE) {
            return TamsMessage.getWritePagedCV(cvnum, val);
        }
        if (this.getMode() == ProgrammingMode.DIRECTBYTEMODE) {
            return TamsMessage.getWriteDirectByteCV(cvnum, val);
        }
        return TamsMessage.getWriteRegister(this.registerFromCV(cvnum), val);
    }

    @Override
    public void message(TamsMessage m) {
        log.error("message received unexpectedly: {}", (Object)m.toString());
    }

    @Override
    public synchronized void reply(TamsReply m) {
        if (this.progState == 0) {
            if (log.isDebugEnabled()) {
                log.debug("reply in NOTPROGRAMMING state");
            }
            return;
        }
        if (this.progState == 2) {
            if (log.isDebugEnabled()) {
                log.debug("reply in COMMANDSENT state");
            }
            this.progState = 0;
            if (m.match("Ok") >= 0) {
                if (this._progRead) {
                    this._val = m.value();
                }
                this.notifyProgListenerEnd(this._val, 0);
            } else if (m.match("No ack") >= 0) {
                if (log.isDebugEnabled()) {
                    log.debug("handle NO Ack");
                }
                this.notifyProgListenerEnd(this._val, 32);
            } else if (m.match("Busy") >= 0) {
                if (log.isDebugEnabled()) {
                    log.debug("handle Busy");
                }
                this.notifyProgListenerEnd(this._val, 4);
            } else if (m.match("Timeout") >= 0) {
                if (log.isDebugEnabled()) {
                    log.debug("handle Timeout");
                }
                this.notifyProgListenerEnd(this._val, 128);
            } else if (m.match("Error") >= 0) {
                if (log.isDebugEnabled()) {
                    log.debug("handle Other Error");
                }
                this.notifyProgListenerEnd(this._val, 1);
            } else {
                if (this._progRead) {
                    this._val = m.value();
                }
                this.notifyProgListenerEnd(this._val, 0);
            }
        } else if (this.progState == 4) {
            if (log.isDebugEnabled()) {
                log.debug("first reply in COMMANDSENT_2 state");
            }
            this.progState = 2;
        } else if (log.isDebugEnabled()) {
            log.debug("reply in un-decoded state");
        }
    }

    @Override
    protected synchronized void timeout() {
        if (this.progState != 0) {
            if (log.isDebugEnabled()) {
                log.debug("timeout!");
            }
            this.progState = 0;
            this.cleanup();
            this.notifyProgListenerEnd(this._val, 128);
        }
    }

    void cleanup() {
    }

    protected void notifyProgListenerEnd(int value, int status) {
        if (log.isDebugEnabled()) {
            log.debug("notifyProgListenerEnd value {} status {}", (Object)value, (Object)status);
        }
        ProgListener temp = this._usingProgrammer;
        this._usingProgrammer = null;
        this.notifyProgListenerEnd(temp, value, status);
    }
}

