/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.tams;

import jmri.JmriException;
import jmri.jmrix.tams.TamsListener;
import jmri.jmrix.tams.TamsMessage;
import jmri.jmrix.tams.TamsReply;
import jmri.jmrix.tams.TamsSystemConnectionMemo;
import jmri.jmrix.tams.TamsTrafficController;
import jmri.managers.AbstractPowerManager;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TamsPowerManager
extends AbstractPowerManager<TamsSystemConnectionMemo>
implements TamsListener {
    TamsMessage tm = TamsPowerManager.myDummy();
    TamsTrafficController tc;
    Thread tamsPowerMonitorThread;
    int lastRequest = 0;
    private static final Logger log = LoggerFactory.getLogger(TamsPowerManager.class);

    private static TamsMessage myDummy() {
        TamsMessage m = new TamsMessage(2);
        m.setElement(0, 0);
        m.setElement(1, 162);
        m.setBinary(true);
        m.setReplyOneByte(true);
        m.setReplyType('P');
        return m;
    }

    public TamsPowerManager(TamsTrafficController ttc) {
        super(ttc.adaptermemo);
        log.debug("*** Tams PowerManager ***");
        this.tc = ttc;
        this.tc.addTamsListener(this);
        TamsMessage tm = TamsMessage.getXStatus();
        this.tc.sendTamsMessage(tm, this);
        this.tc.addPollMessage(tm, this);
        log.debug("TamsMessage added to pollqueue = {} {} and replyType = {}", new Object[]{StringUtil.appendTwoHexFromInt(tm.getElement(0) & 0xFF, ""), StringUtil.appendTwoHexFromInt(tm.getElement(1) & 0xFF, ""), Character.valueOf(tm.getReplyType())});
    }

    @Override
    public void setPower(int v) throws JmriException {
        log.debug("*** setPower ***");
        int old = this.power;
        this.power = 1;
        this.checkTC();
        if (v == 2) {
            TamsMessage tm = TamsMessage.setXPwrOn();
            this.tc.sendTamsMessage(tm, null);
        } else if (v == 4) {
            TamsMessage tm = TamsMessage.setXPwrOff();
            this.tc.sendTamsMessage(tm, null);
        }
        this.firePowerPropertyChange(old, this.power);
    }

    @Override
    public void dispose() throws JmriException {
        TamsMessage tm = TamsMessage.getXStatus();
        this.tc.removePollMessage(tm, this);
        this.tc = null;
    }

    private void checkTC() throws JmriException {
        if (this.tc == null) {
            throw new JmriException("attempt to use TamsPowerManager after dispose");
        }
    }

    @Override
    public void reply(TamsReply tr) {
        int old = this.power;
        if (TamsTrafficController.replyType == 'P') {
            log.debug("*** Tams Power Reply ***");
            log.debug("TamsReply = {}", (Object)StringUtil.appendTwoHexFromInt(tr.getElement(0) & 0xFF, ""));
            boolean valid = false;
            if (TamsTrafficController.replyBinary) {
                log.debug("Reply to Poll Message");
                if ((tr.getElement(0) & 8) == 0) {
                    log.debug("Power status = OFF");
                    this.power = 4;
                    this.firePowerPropertyChange(old, this.power);
                    valid = true;
                }
                if ((tr.getElement(0) & 8) == 8) {
                    log.debug("Power status = ON");
                    this.power = 2;
                    this.firePowerPropertyChange(old, this.power);
                    valid = true;
                }
            } else {
                log.debug("Reply to UI Message");
                if (this.tm.getElement(1) == 166) {
                    log.debug("Power set = OFF");
                    this.power = 4;
                    this.firePowerPropertyChange(old, this.power);
                    valid = true;
                }
                if (this.tm.getElement(1) == 167) {
                    log.debug("Power set = ON");
                    this.power = 2;
                    this.firePowerPropertyChange(old, this.power);
                    valid = true;
                }
            }
            if (!valid) {
                this.power = 1;
                log.debug("Unknown reply in power manager {}", (Object)tr.toString());
                this.firePowerPropertyChange(old, this.power);
            }
            this.tm = TamsPowerManager.myDummy();
        }
    }

    @Override
    public void message(TamsMessage tm) {
    }
}

