/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.tams;

import jmri.jmrix.AbstractMRMessage;

public class TamsMessage
extends AbstractMRMessage {
    private static final int TamsProgrammingTimeout = 5000;
    private char _replyType = (char)88;
    private boolean _replyOneByte = true;
    private int _replyLastByte = 0;
    public static final int POLLTIMEOUT = 100;

    @Override
    public int getElement(int n) {
        return this._dataChars[n];
    }

    public char getReplyType() {
        return this._replyType;
    }

    public void setReplyType(char rt) {
        this._replyType = rt;
    }

    public boolean getReplyOneByte() {
        return this._replyOneByte;
    }

    public void setReplyOneByte(boolean rob) {
        this._replyOneByte = rob;
    }

    public int getReplyLastByte() {
        return this._replyLastByte;
    }

    public void setReplyLastByte(int rlb) {
        this._replyLastByte = rlb;
    }

    public TamsMessage() {
    }

    public TamsMessage(int i) {
        super(i);
    }

    public TamsMessage(TamsMessage m) {
        super(m);
    }

    public TamsMessage(String m) {
        super(m);
        this.setBinary(false);
    }

    public TamsMessage(int[] m) {
        this(m.length);
        int j = 0;
        j = 0;
        while (j < m.length) {
            this.setElement(j, m[j]);
            ++j;
        }
        this.setBinary(true);
        this.setReplyOneByte(false);
        if (this.getElement(1) == 162 || this.getElement(1) == 200) {
            this.setReplyOneByte(true);
        }
        this.setReplyLastByte(0);
        if (this.getElement(1) == 201) {
            this.setReplyLastByte(128);
        }
        this.setRetries(5);
    }

    public static TamsMessage setXPwrOff() {
        TamsMessage m = new TamsMessage(2);
        m.setElement(0, 88);
        m.setElement(1, 166);
        m.setBinary(true);
        m.setReplyOneByte(true);
        m.setReplyType('P');
        return m;
    }

    public static TamsMessage setXPwrOn() {
        TamsMessage m = new TamsMessage(2);
        m.setElement(0, 88);
        m.setElement(1, 167);
        m.setBinary(true);
        m.setReplyOneByte(true);
        m.setReplyType('P');
        return m;
    }

    public static TamsMessage getXStatus() {
        TamsMessage m = new TamsMessage(2);
        m.setElement(0, 88);
        m.setElement(1, 162);
        m.setBinary(true);
        m.setReplyOneByte(true);
        m.setReplyType('P');
        return m;
    }

    public static TamsMessage getXEvtSen() {
        TamsMessage m = new TamsMessage(2);
        m.setElement(0, 88);
        m.setElement(1, 203);
        m.setBinary(true);
        m.setReplyOneByte(false);
        m.setReplyLastByte(0);
        m.setReplyType('S');
        return m;
    }

    public static TamsMessage getXEvtLok() {
        TamsMessage m = new TamsMessage(2);
        m.setElement(0, 88);
        m.setElement(1, 201);
        m.setBinary(true);
        m.setReplyOneByte(false);
        m.setReplyLastByte(128);
        m.setReplyType('L');
        return m;
    }

    public static TamsMessage getXEvtTrn() {
        TamsMessage m = new TamsMessage(2);
        m.setElement(0, 88);
        m.setElement(1, 202);
        m.setBinary(true);
        m.setReplyOneByte(false);
        m.setReplyType('T');
        return m;
    }

    public static TamsMessage setXSR() {
        TamsMessage m = new TamsMessage("xSR 1");
        m.setBinary(false);
        m.setReplyOneByte(false);
        m.setReplyType('S');
        return m;
    }

    public static TamsMessage setXSensOff() {
        TamsMessage m = new TamsMessage(2);
        m.setElement(0, 88);
        m.setElement(1, 153);
        m.setBinary(true);
        m.setReplyOneByte(false);
        m.setReplyType('S');
        return m;
    }

    public static TamsMessage getReadPagedCV(int cv) {
        TamsMessage m = new TamsMessage("xPTRP " + cv);
        m.setNeededMode(4);
        m.setTimeout(5000);
        m.setBinary(false);
        m.setReplyType('C');
        return m;
    }

    public static TamsMessage getWritePagedCV(int cv, int val) {
        TamsMessage m = new TamsMessage("xPTWP " + cv + ", " + val);
        m.setNeededMode(4);
        m.setTimeout(5000);
        m.setBinary(false);
        m.setReplyType('C');
        return m;
    }

    public static TamsMessage getReadRegister(int reg) {
        TamsMessage m = new TamsMessage("xPTRR " + reg);
        m.setNeededMode(4);
        m.setTimeout(5000);
        m.setBinary(false);
        m.setReplyType('C');
        return m;
    }

    public static TamsMessage getWriteRegister(int reg, int val) {
        TamsMessage m = new TamsMessage("xPTWR " + reg + ", " + val);
        m.setNeededMode(4);
        m.setTimeout(5000);
        m.setBinary(false);
        m.setReplyType('C');
        return m;
    }

    public static TamsMessage getReadDirectByteCV(int cv) {
        TamsMessage m = new TamsMessage("xPTRD " + cv);
        m.setNeededMode(4);
        m.setTimeout(5000);
        m.setBinary(false);
        m.setReplyType('C');
        return m;
    }

    public static TamsMessage getWriteDirectByteCV(int cv, int val) {
        TamsMessage m = new TamsMessage("xPTWD " + cv + ", " + val);
        m.setNeededMode(4);
        m.setTimeout(5000);
        m.setBinary(false);
        m.setReplyType('C');
        return m;
    }

    public static TamsMessage getReadDirectBitCV(int cv) {
        TamsMessage m = new TamsMessage("xPTRB " + cv);
        m.setNeededMode(4);
        m.setTimeout(5000);
        m.setBinary(false);
        m.setReplyType('C');
        return m;
    }

    public static TamsMessage getWriteDirectBitCV(int cv, int bit, int val) {
        TamsMessage m = new TamsMessage("xPTWB " + cv + ", " + bit + ", " + val);
        m.setNeededMode(4);
        m.setTimeout(5000);
        m.setBinary(false);
        m.setReplyType('C');
        return m;
    }

    public static TamsMessage getWriteOpsModeCVMsg(int adr, int cv, int val) {
        TamsMessage m = new TamsMessage("xPD " + adr + ", " + cv + ", " + val);
        m.setNeededMode(4);
        m.setTimeout(5000);
        m.setBinary(false);
        m.setReplyType('C');
        return m;
    }

    public static TamsMessage getWriteOpsModeAccCVMsg(int adr, int cv, int val) {
        TamsMessage m = new TamsMessage("xPA " + adr + ", " + cv + ", " + val);
        m.setNeededMode(4);
        m.setTimeout(5000);
        m.setBinary(false);
        m.setReplyType('C');
        return m;
    }
}

