/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.swing;

import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import jmri.InstanceManager;
import jmri.SystemConnectionMemo;

public class SystemConnectionComboBox
extends JComboBox<SystemConnectionMemo> {
    private final SystemConnectionComboBoxModel model = new SystemConnectionComboBoxModel();

    public SystemConnectionComboBox() {
        super.setModel(this.model);
    }

    public void dispose() {
        this.model.dispose();
    }

    private static class SystemConnectionComboBoxModel
    extends AbstractListModel<SystemConnectionMemo>
    implements ComboBoxModel<SystemConnectionMemo> {
        SystemConnectionMemo selectedItem = null;
        PropertyChangeListener memoListener = evt -> {
            switch (evt.getPropertyName()) {
                case "ConnectionNameChanged": {
                    int index = this.getSource().indexOf(evt.getSource());
                    this.fireContentsChanged(this, index, index);
                    break;
                }
            }
        };
        PropertyChangeListener imListener = evt -> {
            if (evt.getSource().equals(InstanceManager.getDefault())) {
                if (evt instanceof IndexedPropertyChangeEvent) {
                    IndexedPropertyChangeEvent event = (IndexedPropertyChangeEvent)evt;
                    if (event.getNewValue() != null) {
                        ((SystemConnectionMemo)event.getNewValue()).addPropertyChangeListener(this.memoListener);
                        this.fireIntervalAdded(this, event.getIndex(), event.getIndex());
                    } else if (event.getOldValue() != null) {
                        ((SystemConnectionMemo)event.getOldValue()).removePropertyChangeListener(this.memoListener);
                        this.fireIntervalRemoved(this, event.getIndex(), event.getIndex());
                    }
                    this.fireContentsChanged(this, event.getIndex(), event.getIndex());
                } else {
                    SystemConnectionMemo memo;
                    Object item = evt.getNewValue();
                    if ((item == null || item instanceof SystemConnectionMemo) && ((memo = (SystemConnectionMemo)item) == null || this.getSource().contains(memo))) {
                        this.setSelectedItem(memo);
                    }
                }
            }
        };

        public SystemConnectionComboBoxModel() {
            InstanceManager.addPropertyChangeListener(InstanceManager.getListPropertyName(SystemConnectionMemo.class), this.imListener);
            InstanceManager.addPropertyChangeListener(InstanceManager.getDefaultsPropertyName(SystemConnectionMemo.class), this.imListener);
            this.getSource().forEach(memo -> memo.addPropertyChangeListener(this.memoListener));
        }

        @Override
        public void setSelectedItem(Object anItem) {
            if ((anItem == null || anItem instanceof SystemConnectionMemo) && (this.selectedItem != null && !this.selectedItem.equals(anItem) || this.selectedItem == null && anItem != null)) {
                this.selectedItem = (SystemConnectionMemo)anItem;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public SystemConnectionMemo getSelectedItem() {
            return this.selectedItem;
        }

        @Override
        public int getSize() {
            return this.getSource().size();
        }

        @Override
        public SystemConnectionMemo getElementAt(int index) {
            return this.getSource().get(index);
        }

        public void dispose() {
            InstanceManager.removePropertyChangeListener(InstanceManager.getListPropertyName(SystemConnectionMemo.class), this.imListener);
            InstanceManager.removePropertyChangeListener(InstanceManager.getDefaultsPropertyName(SystemConnectionMemo.class), this.imListener);
        }

        private List<SystemConnectionMemo> getSource() {
            return InstanceManager.getList(SystemConnectionMemo.class);
        }
    }
}

