/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.srcp.swing.srcpmon;

import jmri.InstanceManager;
import jmri.jmrix.AbstractMonPane;
import jmri.jmrix.srcp.SRCPListener;
import jmri.jmrix.srcp.SRCPMessage;
import jmri.jmrix.srcp.SRCPReply;
import jmri.jmrix.srcp.SRCPSystemConnectionMemo;
import jmri.jmrix.srcp.SRCPTrafficController;
import jmri.jmrix.srcp.parser.SimpleNode;
import jmri.jmrix.srcp.swing.srcpmon.Bundle;
import jmri.util.swing.JmriNamedPaneAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SRCPMonPane
extends AbstractMonPane
implements SRCPListener {
    private SRCPSystemConnectionMemo _memo = null;
    private SRCPTrafficController tc = null;
    private static final Logger log = LoggerFactory.getLogger(SRCPMonPane.class);

    @Override
    public String getTitle() {
        return Bundle.getMessage("MenuItemSRCPCommandMonitorTitle");
    }

    @Override
    protected void init() {
    }

    @Override
    public void initContext(Object context) {
        if (context instanceof SRCPSystemConnectionMemo) {
            this._memo = (SRCPSystemConnectionMemo)context;
            this.tc = this._memo.getTrafficController();
            this.tc.addSRCPListener(this);
        }
    }

    @Override
    public void dispose() {
        this.tc.removeSRCPListener(this);
        super.dispose();
    }

    @Override
    public synchronized void message(SRCPMessage l) {
        this.logMessage("cmd: ", l);
    }

    @Override
    public synchronized void reply(SRCPReply l) {
        this.logMessage("reply: ", l);
    }

    @Override
    public synchronized void reply(SimpleNode n) {
        if (log.isDebugEnabled()) {
            log.debug("reply called with simpleNode {}", n.jjtGetValue());
        }
        this.reply(new SRCPReply(n));
    }

    public static class Default
    extends JmriNamedPaneAction {
        public Default() {
            super(Bundle.getMessage("MenuItemSRCPCommandMonitorTitle"), SRCPMonPane.class.getName());
            this.setContext(InstanceManager.getDefault(SRCPSystemConnectionMemo.class));
        }
    }
}

