/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.srcp.parser;

import jmri.GlobalProgrammerManager;
import jmri.PowerManager;
import jmri.SensorManager;
import jmri.ThrottleManager;
import jmri.TurnoutManager;
import jmri.jmrix.srcp.SRCPBusConnectionMemo;
import jmri.jmrix.srcp.SRCPPowerManager;
import jmri.jmrix.srcp.SRCPProgrammer;
import jmri.jmrix.srcp.SRCPSensor;
import jmri.jmrix.srcp.SRCPSensorManager;
import jmri.jmrix.srcp.SRCPSystemConnectionMemo;
import jmri.jmrix.srcp.SRCPTrafficController;
import jmri.jmrix.srcp.parser.ASTdescription;
import jmri.jmrix.srcp.parser.ASTfb;
import jmri.jmrix.srcp.parser.ASTga;
import jmri.jmrix.srcp.parser.ASTgl;
import jmri.jmrix.srcp.parser.ASTinfo;
import jmri.jmrix.srcp.parser.ASTlock;
import jmri.jmrix.srcp.parser.ASTok;
import jmri.jmrix.srcp.parser.ASTpower;
import jmri.jmrix.srcp.parser.ASTserver;
import jmri.jmrix.srcp.parser.ASTsession;
import jmri.jmrix.srcp.parser.ASTsm;
import jmri.jmrix.srcp.parser.ASTtime;
import jmri.jmrix.srcp.parser.SRCPClientParserDefaultVisitor;
import jmri.jmrix.srcp.parser.SimpleNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SRCPClientVisitor
extends SRCPClientParserDefaultVisitor {
    private static final Logger log = LoggerFactory.getLogger(SRCPClientVisitor.class);

    @Override
    public Object visit(ASTinfo node, Object data) {
        log.debug("Info Response {}", node.jjtGetValue());
        int bus = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(0)).jjtGetValue());
        SRCPBusConnectionMemo busMemo = ((SRCPSystemConnectionMemo)data).getMemo(bus);
        SimpleNode group = (SimpleNode)node.jjtGetChild(1);
        log.debug("Info Response Group: {}", group.jjtGetValue());
        if (group instanceof ASTfb) {
            if (busMemo.provides(SensorManager.class)) {
                int address = Integer.parseInt((String)((SimpleNode)group.jjtGetChild(0)).jjtGetValue());
                ((SRCPSensor)((SRCPSensorManager)busMemo.getSensorManager()).provideSensor("" + address)).reply(node);
            }
        } else if (group instanceof ASTga) {
            if (busMemo.provides(TurnoutManager.class)) {
                group.jjtGetNumChildren();
            }
        } else if (group instanceof ASTgl) {
            busMemo.provides(ThrottleManager.class);
        } else if (group instanceof ASTsm) {
            SRCPProgrammer programmer;
            if (busMemo.provides(GlobalProgrammerManager.class) && (programmer = (SRCPProgrammer)busMemo.getProgrammerManager().getGlobalProgrammer()) != null) {
                programmer.reply(node);
            }
        } else if (group instanceof ASTpower) {
            if (busMemo.provides(PowerManager.class)) {
                ((SRCPPowerManager)busMemo.getPowerManager()).reply(node);
            }
        } else if (group instanceof ASTtime) {
            log.debug("INFO Response for TIME group with bus {}", (Object)bus);
        } else if (group instanceof ASTsession) {
            log.debug("INFO Response for SESSION group with bus {}", (Object)bus);
        } else if (group instanceof ASTserver) {
            log.debug("INFO Response for SERVER group with bus {}", (Object)bus);
        } else if (group instanceof ASTdescription) {
            log.debug("INFO Response for DESCRIPTION group with bus {}", (Object)bus);
        } else if (group instanceof ASTlock) {
            log.debug("INFO Response for LOCK group with bus {}", (Object)bus);
        }
        return data;
    }

    @Override
    public Object visit(ASTok node, Object data) {
        log.debug("Ok Response {}", node.jjtGetValue());
        SRCPSystemConnectionMemo memo = (SRCPSystemConnectionMemo)data;
        if (((String)node.jjtGetValue()).contains("GO")) {
            memo.setMode(SRCPTrafficController.RUNMODE);
            return data;
        }
        return node.childrenAccept(this, data);
    }
}

