/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.srcp;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.NamedBean;
import jmri.Turnout;
import jmri.jmrix.srcp.SRCPBusConnectionMemo;
import jmri.jmrix.srcp.SRCPTurnout;
import jmri.managers.AbstractTurnoutManager;

public class SRCPTurnoutManager
extends AbstractTurnoutManager {
    public SRCPTurnoutManager(SRCPBusConnectionMemo memo) {
        super(memo);
    }

    @Deprecated
    public SRCPTurnoutManager(SRCPBusConnectionMemo memo, int bus) {
        this(memo);
    }

    @Override
    @Nonnull
    public SRCPBusConnectionMemo getMemo() {
        return (SRCPBusConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Turnout createNewTurnout(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        int addr;
        try {
            addr = Integer.parseInt(systemName.substring(this.getSystemPrefix().length() + 1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Failed to convert systemName '" + systemName + "' to a Turnout address");
        }
        SRCPTurnout t = new SRCPTurnout(addr, this.getMemo());
        t.setUserName(userName);
        return t;
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) throws NamedBean.BadSystemNameException {
        return this.validateSystemNameFormatOnlyNumeric(name, locale);
    }
}

