/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.srcp;

import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import javax.swing.SwingUtilities;
import jmri.InstanceManager;
import jmri.SensorManager;
import jmri.ShutDownManager;
import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.AbstractMRTrafficController;
import jmri.jmrix.srcp.SRCPInterface;
import jmri.jmrix.srcp.SRCPListener;
import jmri.jmrix.srcp.SRCPMessage;
import jmri.jmrix.srcp.SRCPReply;
import jmri.jmrix.srcp.SRCPSystemConnectionMemo;
import jmri.jmrix.srcp.parser.ParseException;
import jmri.jmrix.srcp.parser.SRCPClientParser;
import jmri.jmrix.srcp.parser.SRCPClientVisitor;
import jmri.jmrix.srcp.parser.SimpleNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SRCPTrafficController
extends AbstractMRTrafficController
implements SRCPInterface {
    protected SRCPSystemConnectionMemo _memo = null;
    final Runnable shutDownTask = () -> this.sendSRCPMessage(new SRCPMessage("TERM 0 SESSION"), null);
    public static int HANDSHAKEMODE = 0;
    public static int RUNMODE = 1;
    private int mode = HANDSHAKEMODE;
    private static final Logger log = LoggerFactory.getLogger(SRCPTrafficController.class);

    public SRCPTrafficController() {
        InstanceManager.getDefault(ShutDownManager.class).register(this.shutDownTask);
    }

    @Override
    public synchronized void addSRCPListener(SRCPListener l) {
        this.addListener(l);
    }

    @Override
    public synchronized void removeSRCPListener(SRCPListener l) {
        this.removeListener(l);
    }

    void setSystemConnectionMemo(SRCPSystemConnectionMemo memo) {
        this._memo = memo;
    }

    SRCPSystemConnectionMemo getSystemConnectionMemo() {
        return this._memo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveLoop() {
        log.debug("SRCP receiveLoop starts");
        SRCPClientParser parser = new SRCPClientParser(this.istream);
        try {
            block26: while (true) {
                Runnable runnable;
                SimpleNode e = this._memo.getMode() == HANDSHAKEMODE ? parser.handshakeresponse() : parser.commandresponse();
                SRCPRcvNotifier r = new SRCPRcvNotifier(e, this.mLastSender, this);
                try {
                    SwingUtilities.invokeAndWait(r);
                }
                catch (InterruptedException | InvocationTargetException ex) {
                    log.error("Unexpected exception in invokeAndWait:", (Throwable)ex);
                }
                log.debug("dispatch thread invoked");
                log.debug("Mode {} child contains {}", (Object)this.mode, ((SimpleNode)e.jjtGetChild(1)).jjtGetValue());
                SRCPClientVisitor v = new SRCPClientVisitor();
                e.jjtAccept(v, this._memo);
                switch (this.mCurrentState) {
                    case 25: {
                        Runnable runnable2 = this.xmtRunnable;
                        synchronized (runnable2) {
                            this.mCurrentState = 15;
                            this.replyInDispatch = false;
                            this.xmtRunnable.notify();
                            continue block26;
                        }
                    }
                    case 30: {
                        this.mCurrentMode = 4;
                        this.replyInDispatch = false;
                        int warmUpDelay = this.enterProgModeDelayTime();
                        if (warmUpDelay != 0) {
                            try {
                                runnable = this.xmtRunnable;
                                synchronized (runnable) {
                                    this.xmtRunnable.wait(warmUpDelay);
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        runnable = this.xmtRunnable;
                        synchronized (runnable) {
                            this.mCurrentState = 40;
                            this.xmtRunnable.notify();
                            continue block26;
                        }
                    }
                    case 35: {
                        this.mCurrentMode = 1;
                        this.replyInDispatch = false;
                        runnable = this.xmtRunnable;
                        synchronized (runnable) {
                            this.mCurrentState = 40;
                            this.xmtRunnable.notify();
                            continue block26;
                        }
                    }
                }
                this.replyInDispatch = false;
                if (this.allowUnexpectedReply) {
                    log.debug("Allowed unexpected reply received in state: {} was {}", (Object)this.mCurrentState, (Object)e);
                    runnable = this.xmtRunnable;
                    synchronized (runnable) {
                        this.xmtRunnable.notify();
                    }
                }
                this.unexpectedReplyStateError(this.mCurrentState, e.toString());
            }
        }
        catch (ParseException pe) {
            this.rcvException = true;
            this.reportReceiveLoopException(pe);
            return;
        }
    }

    @Override
    public void terminateThreads() {
        this.sendSRCPMessage(new SRCPMessage("TERM 0 SESSION"), null);
        InstanceManager.getDefault(ShutDownManager.class).deregister(this.shutDownTask);
        super.terminateThreads();
    }

    @Override
    protected void forwardMessage(AbstractMRListener client, AbstractMRMessage m) {
        ((SRCPListener)client).message((SRCPMessage)m);
    }

    @Override
    protected void forwardReply(AbstractMRListener client, AbstractMRReply m) {
        ((SRCPListener)client).reply((SRCPReply)m);
    }

    protected void forwardReply(AbstractMRListener client, SimpleNode n) {
        ((SRCPListener)client).reply(n);
    }

    public void setSensorManager(SensorManager m) {
    }

    @Override
    protected AbstractMRMessage pollMessage() {
        return null;
    }

    @Override
    protected AbstractMRListener pollReplyHandler() {
        return null;
    }

    @Override
    public void sendSRCPMessage(SRCPMessage m, SRCPListener reply) {
        this.sendMessage(m, reply);
    }

    @Override
    protected AbstractMRMessage enterProgMode() {
        return SRCPMessage.getProgMode(1);
    }

    @Override
    protected AbstractMRMessage enterNormalMode() {
        return SRCPMessage.getExitProgMode(1);
    }

    @Override
    protected AbstractMRReply newReply() {
        return new SRCPReply();
    }

    @Override
    protected boolean endOfMessage(AbstractMRReply msg) {
        int index = msg.getNumDataElements() - 1;
        switch (msg.getElement(index)) {
            case 10: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyReply(SimpleNode r, AbstractMRListener dest) {
        Vector v;
        SRCPTrafficController sRCPTrafficController = this;
        synchronized (sRCPTrafficController) {
            v = (Vector)this.cmdListeners.clone();
        }
        int cnt = v.size();
        int i = 0;
        while (i < cnt) {
            AbstractMRListener client = (AbstractMRListener)v.elementAt(i);
            log.debug("notify client: {}", (Object)client);
            try {
                if (dest != client) {
                    this.forwardReply(client, r);
                }
            }
            catch (Exception ex) {
                log.warn("notify: During reply dispatch to {}", (Object)client, (Object)ex);
            }
            if (dest != null) {
                this.forwardReply(dest, r);
            }
            ++i;
        }
    }

    protected static class SRCPRcvNotifier
    implements Runnable {
        SimpleNode e;
        SRCPListener mDest;
        SRCPTrafficController mTC;

        SRCPRcvNotifier(SimpleNode n, AbstractMRListener pDest, AbstractMRTrafficController pTC) {
            this.e = (SimpleNode)n.jjtGetChild(1);
            this.mDest = (SRCPListener)pDest;
            this.mTC = (SRCPTrafficController)pTC;
        }

        @Override
        public void run() {
            log.debug("Delayed rcv notify starts");
            this.mTC.notifyReply(this.e, (AbstractMRListener)this.mDest);
        }
    }
}

