/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.srcp;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jmri.DccLocoAddress;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.jmrix.AbstractThrottle;
import jmri.jmrix.srcp.SRCPBusConnectionMemo;
import jmri.jmrix.srcp.SRCPMessage;

public class SRCPThrottle
extends AbstractThrottle {
    private DccLocoAddress address;
    private int bus;
    private int maxsteps;

    public SRCPThrottle(SRCPBusConnectionMemo memo, DccLocoAddress address) {
        this(memo, address, "N", SpeedStepMode.NMRA_DCC_128, 28);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SRCPThrottle(SRCPBusConnectionMemo memo, DccLocoAddress address, String protocol, SpeedStepMode mode, int functions) {
        super(memo);
        if (!protocol.equals("N")) {
            throw new IllegalArgumentException("Protocol " + protocol + " not supported");
        }
        this.setSpeedStepMode(mode);
        this.bus = memo.getBus();
        SRCPThrottle sRCPThrottle = this;
        synchronized (sRCPThrottle) {
            this.speedSetting = 0.0f;
        }
        this.address = address;
        this.isForward = true;
        String msg = "INIT " + this.bus + " GL " + address.getNumber() + " " + protocol + " " + (address.isLongAddress() ? " 2 " : " 1 ") + this.maxsteps + " " + functions + "\n";
        memo.getTrafficController().sendSRCPMessage(new SRCPMessage(msg), null);
    }

    @Override
    protected void sendFunctionGroup1() {
        this.sendUpdate();
    }

    @Override
    protected void sendFunctionGroup2() {
        this.sendUpdate();
    }

    @Override
    protected void sendFunctionGroup3() {
        this.sendUpdate();
    }

    @Override
    protected void sendFunctionGroup4() {
        this.sendUpdate();
    }

    @Override
    protected void sendFunctionGroup5() {
        this.sendUpdate();
    }

    @Override
    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"})
    public synchronized void setSpeedSetting(float speed) {
        float oldSpeed = this.speedSetting;
        this.speedSetting = speed;
        this.sendUpdate();
        this.firePropertyChange("SpeedSetting", Float.valueOf(oldSpeed), Float.valueOf(this.speedSetting));
        this.record(speed);
    }

    @Override
    public void setIsForward(boolean forward) {
        boolean old = this.isForward;
        this.isForward = forward;
        this.sendUpdate();
        this.firePropertyChange("IsForward", old, this.isForward);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendUpdate() {
        String msg = "SET " + this.bus + " GL ";
        msg = String.valueOf(msg) + this.address.getNumber();
        msg = String.valueOf(msg) + (this.isForward ? " 1" : " 0");
        SRCPThrottle sRCPThrottle = this;
        synchronized (sRCPThrottle) {
            msg = String.valueOf(msg) + " " + (int)(this.speedSetting * (float)this.maxsteps);
        }
        msg = String.valueOf(msg) + " ";
        msg = String.valueOf(msg) + this.maxsteps;
        msg = String.valueOf(msg) + (this.getFunction(0) ? " 1" : " 0");
        msg = String.valueOf(msg) + (this.getFunction(1) ? " 1" : " 0");
        msg = String.valueOf(msg) + (this.getFunction(2) ? " 1" : " 0");
        msg = String.valueOf(msg) + (this.getFunction(3) ? " 1" : " 0");
        msg = String.valueOf(msg) + (this.getFunction(4) ? " 1" : " 0");
        msg = String.valueOf(msg) + (this.getFunction(5) ? " 1" : " 0");
        msg = String.valueOf(msg) + (this.getFunction(6) ? " 1" : " 0");
        msg = String.valueOf(msg) + (this.getFunction(7) ? " 1" : " 0");
        msg = String.valueOf(msg) + (this.getFunction(8) ? " 1" : " 0");
        msg = String.valueOf(msg) + (this.getFunction(9) ? " 1" : " 0");
        msg = String.valueOf(msg) + (this.getFunction(10) ? " 1" : " 0");
        msg = String.valueOf(msg) + (this.getFunction(11) ? " 1" : " 0");
        msg = String.valueOf(msg) + (this.getFunction(12) ? " 1" : " 0");
        msg = String.valueOf(msg) + (this.getFunction(13) ? " 1" : " 0");
        msg = String.valueOf(msg) + (this.getFunction(14) ? " 1" : " 0");
        msg = String.valueOf(msg) + (this.getFunction(15) ? " 1" : " 0");
        msg = String.valueOf(msg) + (this.getFunction(16) ? " 1" : " 0");
        msg = String.valueOf(msg) + (this.getFunction(17) ? " 1" : " 0");
        msg = String.valueOf(msg) + (this.getFunction(18) ? " 1" : " 0");
        msg = String.valueOf(msg) + (this.getFunction(19) ? " 1" : " 0");
        msg = String.valueOf(msg) + (this.getFunction(20) ? " 1" : " 0");
        msg = String.valueOf(msg) + (this.getFunction(21) ? " 1" : " 0");
        msg = String.valueOf(msg) + (this.getFunction(22) ? " 1" : " 0");
        msg = String.valueOf(msg) + (this.getFunction(23) ? " 1" : " 0");
        msg = String.valueOf(msg) + (this.getFunction(24) ? " 1" : " 0");
        msg = String.valueOf(msg) + (this.getFunction(25) ? " 1" : " 0");
        msg = String.valueOf(msg) + (this.getFunction(26) ? " 1" : " 0");
        msg = String.valueOf(msg) + (this.getFunction(27) ? " 1" : " 0");
        msg = String.valueOf(msg) + (this.getFunction(28) ? " 1" : " 0");
        SRCPMessage m = new SRCPMessage(String.valueOf(msg) + "\n");
        ((SRCPBusConnectionMemo)this.adapterMemo).getTrafficController().sendSRCPMessage(m, null);
    }

    @Override
    public void setSpeedStepMode(SpeedStepMode Mode) {
        super.setSpeedStepMode(Mode);
        switch (Mode) {
            case NMRA_DCC_128: 
            case NMRA_DCC_28: 
            case NMRA_DCC_27: 
            case NMRA_DCC_14: {
                this.maxsteps = Mode.numSteps;
                break;
            }
            default: {
                this.maxsteps = 126;
            }
        }
    }

    @Override
    public LocoAddress getLocoAddress() {
        return this.address;
    }

    @Override
    public void throttleDispose() {
        this.finishRecord();
    }
}

