/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.srcp;

import jmri.JmriException;
import jmri.implementation.AbstractSensor;
import jmri.jmrix.srcp.SRCPBusConnectionMemo;
import jmri.jmrix.srcp.SRCPListener;
import jmri.jmrix.srcp.SRCPMessage;
import jmri.jmrix.srcp.SRCPReply;
import jmri.jmrix.srcp.SRCPTrafficController;
import jmri.jmrix.srcp.parser.SimpleNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SRCPSensor
extends AbstractSensor
implements SRCPListener {
    private final int _number;
    private final int _bus;
    private SRCPTrafficController tc = null;
    private static final Logger log = LoggerFactory.getLogger(SRCPSensor.class);

    public SRCPSensor(int number, SRCPBusConnectionMemo memo) {
        super(String.valueOf(memo.getSystemPrefix()) + "S" + number);
        this._number = number;
        this._bus = memo.getBus();
        this.tc = memo.getTrafficController();
        this.tc.addSRCPListener(this);
        this.requestUpdateFromLayout();
    }

    public int getNumber() {
        return this._number;
    }

    @Override
    public void setKnownState(int newState) throws JmriException {
        if ((newState & 2) != 0) {
            if ((newState & 4) != 0) {
                log.error("Cannot command both ACTIVE and INACTIVE {}", (Object)newState);
                return;
            }
            this.sendMessage(!this.getInverted());
        } else {
            this.sendMessage(this.getInverted());
        }
        if (this._knownState != newState) {
            int oldState = this._knownState;
            this._knownState = newState;
            this.firePropertyChange("KnownState", oldState, this._knownState);
        }
    }

    @Override
    public void requestUpdateFromLayout() {
        String text = "GET " + this._bus + " FB " + this._number + "\n";
        this.tc.sendSRCPMessage(new SRCPMessage(text), this);
    }

    protected void sendMessage(boolean active) {
        String text = active ? "SET " + this._bus + " FB " + this._number + " 1\n" : "SET " + this._bus + " FB " + this._number + " 0\n";
        this.tc.sendSRCPMessage(new SRCPMessage(text), this);
    }

    @Override
    public void reply(SRCPReply m) {
        String message = m.toString();
        log.debug("Message Received: {}", (Object)m);
        if (!message.contains(String.valueOf(this._bus) + " FB " + this._number)) {
            return;
        }
        if (m.toString().contains(String.valueOf(this._bus) + " FB " + this._number + " 0")) {
            this.setOwnState(!this.getInverted() ? 4 : 2);
        } else if (m.toString().contains(String.valueOf(this._bus) + " FB " + this._number + " 1")) {
            this.setOwnState(!this.getInverted() ? 2 : 4);
        } else {
            this.setOwnState(1);
        }
    }

    @Override
    public void reply(SimpleNode n) {
        if (log.isDebugEnabled()) {
            log.debug("reply called with simpleNode {}", n.jjtGetValue());
        }
        this.reply(new SRCPReply(n));
    }

    @Override
    public void message(SRCPMessage m) {
    }
}

