/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.srcp;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jmri.ProgListener;
import jmri.ProgrammerException;
import jmri.ProgrammingMode;
import jmri.jmrix.AbstractProgrammer;
import jmri.jmrix.srcp.SRCPBusConnectionMemo;
import jmri.jmrix.srcp.SRCPListener;
import jmri.jmrix.srcp.SRCPMessage;
import jmri.jmrix.srcp.SRCPReply;
import jmri.jmrix.srcp.SRCPTrafficController;
import jmri.jmrix.srcp.parser.ASTsm;
import jmri.jmrix.srcp.parser.SimpleNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SRCPProgrammer
extends AbstractProgrammer
implements SRCPListener {
    protected SRCPBusConnectionMemo _memo = null;
    private int _bus;
    int progState = 0;
    static final int NOTPROGRAMMING = 0;
    static final int COMMANDSENT = 2;
    boolean _progRead = false;
    boolean _progConfirm = false;
    int _confirmVal;
    int _val;
    int _cv;
    private ProgListener _usingProgrammer = null;
    SRCPTrafficController _controller = null;
    private static final Logger log = LoggerFactory.getLogger(SRCPProgrammer.class);

    public SRCPProgrammer(SRCPBusConnectionMemo memo) {
        this._bus = memo.getBus();
        this._memo = memo;
        this.LONG_TIMEOUT = 180000;
    }

    @Override
    @Nonnull
    public List<ProgrammingMode> getSupportedModes() {
        ArrayList<ProgrammingMode> ret = new ArrayList<ProgrammingMode>();
        ret.add(ProgrammingMode.DIRECTBYTEMODE);
        ret.add(ProgrammingMode.REGISTERMODE);
        return ret;
    }

    @Override
    public synchronized void writeCV(String CVname, int val, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        if (log.isDebugEnabled()) {
            log.debug("writeCV {} listens {}", (Object)CV, (Object)p);
        }
        this.useProgrammer(p);
        this._progRead = false;
        this._progConfirm = false;
        this.progState = 2;
        this._val = val;
        this._cv = CV;
        try {
            this.startLongTimer();
            SRCPMessage m = this.getMode() == ProgrammingMode.DIRECTBYTEMODE ? SRCPMessage.getWriteDirectCV(this._bus, this._cv, this._val) : SRCPMessage.getWriteRegister(this._bus, this.registerFromCV(this._cv), this._val);
            this.controller().sendSRCPMessage(m, this);
        }
        catch (ProgrammerException e) {
            this.progState = 0;
            throw e;
        }
    }

    @Override
    public synchronized void confirmCV(String CVname, int val, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        if (log.isDebugEnabled()) {
            log.debug("confirmCV {} val {} listens {}", new Object[]{CV, val, p});
        }
        this.useProgrammer(p);
        this._progRead = false;
        this._progConfirm = true;
        this.progState = 2;
        this._cv = CV;
        this._confirmVal = val;
        try {
            this.startLongTimer();
            SRCPMessage m = this.getMode() == ProgrammingMode.DIRECTBYTEMODE ? SRCPMessage.getConfirmDirectCV(this._bus, this._cv, this._confirmVal) : SRCPMessage.getConfirmRegister(this._bus, this.registerFromCV(this._cv), this._confirmVal);
            this.controller().sendSRCPMessage(m, this);
        }
        catch (ProgrammerException e) {
            this.progState = 0;
            throw e;
        }
    }

    @Override
    public synchronized void readCV(String CVname, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        if (log.isDebugEnabled()) {
            log.debug("readCV {} listens {}", (Object)CV, (Object)p);
        }
        this.useProgrammer(p);
        this._progRead = true;
        this._progConfirm = false;
        this.progState = 2;
        this._cv = CV;
        try {
            this.startLongTimer();
            SRCPMessage m = this.getMode() == ProgrammingMode.DIRECTBYTEMODE ? SRCPMessage.getReadDirectCV(this._bus, this._cv) : SRCPMessage.getReadRegister(this._bus, this.registerFromCV(this._cv));
            this.controller().sendSRCPMessage(m, this);
        }
        catch (ProgrammerException e) {
            this.progState = 0;
            throw e;
        }
    }

    protected void useProgrammer(ProgListener p) throws ProgrammerException {
        if (this._usingProgrammer != null && this._usingProgrammer != p) {
            if (log.isDebugEnabled()) {
                log.debug("programmer already in use by {}", (Object)this._usingProgrammer);
            }
            throw new ProgrammerException("programmer in use");
        }
        this._usingProgrammer = p;
    }

    @Override
    public void message(SRCPMessage m) {
        log.error("message received unexpectedly: {}", (Object)m.toString());
    }

    @Override
    public synchronized void reply(SRCPReply m) {
        if (this.progState == 0) {
            if (log.isDebugEnabled()) {
                log.debug("reply in NOTPROGRAMMING state");
            }
            if (!m.isResponseOK()) {
                log.warn("Reply \"{}\"", (Object)m.toString());
            }
        } else if (this.progState == 2) {
            if (log.isDebugEnabled()) {
                log.debug("reply in COMMANDSENT state");
            }
            this.progState = 0;
            if (!m.isResponseOK()) {
                if (log.isDebugEnabled()) {
                    log.debug("handle error reply {}", (Object)m);
                }
                log.warn("Reply \"{}\"", (Object)m.toString());
                if (this._progConfirm && m.getResponseCode().equals("412")) {
                    this.notifyProgListenerEnd(this._val, 64);
                    return;
                }
                this.notifyProgListenerEnd(-1, 2);
            } else {
                if (this._progRead) {
                    this._val = m.value();
                }
                if (this._progConfirm) {
                    this._val = this._confirmVal;
                }
                this.notifyProgListenerEnd(this._val, 0);
            }
        }
    }

    @Override
    public synchronized void reply(SimpleNode n) {
        if (log.isDebugEnabled()) {
            log.debug("reply called with simpleNode {}", n.jjtGetValue());
        }
        if (n.jjtGetChild(3) instanceof ASTsm) {
            this.reply(new SRCPReply(n));
        }
    }

    @Override
    protected synchronized void timeout() {
        if (this.progState != 0) {
            if (log.isDebugEnabled()) {
                log.debug("timeout!");
            }
            this.progState = 0;
            this.cleanup();
            this.notifyProgListenerEnd(this._val, 128);
        }
    }

    void cleanup() {
        this.controller().sendSRCPMessage(SRCPMessage.getExitProgMode(this._bus), this);
    }

    protected void notifyProgListenerEnd(int value, int status) {
        if (log.isDebugEnabled()) {
            log.debug("notifyProgListenerEnd value {} status {}", (Object)value, (Object)status);
        }
        ProgListener temp = this._usingProgrammer;
        this._usingProgrammer = null;
        this.notifyProgListenerEnd(temp, value, status);
    }

    protected SRCPTrafficController controller() {
        if (this._controller == null) {
            this._controller = this._memo.getTrafficController();
        }
        return this._controller;
    }
}

