/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.srcp;

import jmri.JmriException;
import jmri.jmrix.srcp.SRCPBusConnectionMemo;
import jmri.jmrix.srcp.SRCPListener;
import jmri.jmrix.srcp.SRCPMessage;
import jmri.jmrix.srcp.SRCPReply;
import jmri.jmrix.srcp.SRCPTrafficController;
import jmri.jmrix.srcp.parser.SimpleNode;
import jmri.managers.AbstractPowerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SRCPPowerManager
extends AbstractPowerManager<SRCPBusConnectionMemo>
implements SRCPListener {
    boolean waiting = false;
    int onReply = 1;
    int _bus = 0;
    SRCPTrafficController tc = null;
    private static final Logger log = LoggerFactory.getLogger(SRCPPowerManager.class);

    public SRCPPowerManager(SRCPBusConnectionMemo memo, int bus) {
        super(memo);
        this.tc = memo.getTrafficController();
        this.tc.addSRCPListener(this);
        this._bus = bus;
    }

    @Override
    public void setPower(int v) throws JmriException {
        int old = this.power;
        this.power = 1;
        this.checkTC();
        if (v == 2) {
            this.waiting = true;
            this.onReply = 2;
            SRCPMessage l = SRCPMessage.getEnableMain();
            this.tc.sendSRCPMessage(l, this);
        } else if (v == 4) {
            this.waiting = true;
            this.onReply = 4;
            this.firePowerPropertyChange(old, this.power);
            SRCPMessage l = SRCPMessage.getKillMain();
            this.tc.sendSRCPMessage(l, this);
        }
        this.firePowerPropertyChange(old, this.power);
    }

    @Override
    public void dispose() throws JmriException {
        this.tc.removeSRCPListener(this);
        this.tc = null;
    }

    private void checkTC() throws JmriException {
        if (this.tc == null) {
            throw new JmriException("attempt to use SRCPPowerManager after dispose");
        }
    }

    @Override
    public void reply(SRCPReply m) {
        if (this.waiting) {
            int old = this.power;
            this.power = this.onReply;
            this.firePowerPropertyChange(old, this.power);
        }
        this.waiting = false;
    }

    @Override
    public void reply(SimpleNode n) {
        log.debug("reply called with simpleNode {}", n.jjtGetValue());
        this.reply(new SRCPReply(n));
    }

    @Override
    public void message(SRCPMessage m) {
        if (m.isKillMain()) {
            this.waiting = true;
            this.onReply = 4;
        } else if (m.isEnableMain()) {
            this.waiting = true;
            this.onReply = 2;
        }
    }
}

