/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.srcp;

import java.text.SimpleDateFormat;
import java.util.Date;
import jmri.InstanceManager;
import jmri.Timebase;
import jmri.implementation.DefaultClockControl;
import jmri.jmrix.srcp.SRCPBusConnectionMemo;
import jmri.jmrix.srcp.SRCPMessage;
import jmri.jmrix.srcp.SRCPTrafficController;

public class SRCPClockControl
extends DefaultClockControl {
    SRCPBusConnectionMemo _memo = null;
    SRCPTrafficController _tc = null;

    public SRCPClockControl(SRCPBusConnectionMemo memo) {
        this._memo = memo;
        this._tc = this._memo.getTrafficController();
    }

    @Override
    public String getHardwareClockName() {
        return "SRCP Fast Clock";
    }

    @Override
    public void setRate(double newRate) {
        String text = "INIT " + this._memo.getBus() + " TIME 1 " + newRate;
        this._tc.sendSRCPMessage(new SRCPMessage(text), null);
    }

    @Override
    public double getRate() {
        return InstanceManager.getDefault(Timebase.class).getRate();
    }

    @Override
    public void setTime(Date now) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyDDD hh mm ss");
        String text = "SET " + this._memo.getBus() + " TIME " + sdf.format(now);
        this._tc.sendSRCPMessage(new SRCPMessage(text), null);
    }

    @Override
    public Date getTime() {
        String text = "GET " + this._memo.getBus() + " TIME";
        this._tc.sendSRCPMessage(new SRCPMessage(text), null);
        return InstanceManager.getDefault(Timebase.class).getTime();
    }

    @Override
    public void startHardwareClock(Date now) {
        this.setTime(now);
    }

    @Override
    public void stopHardwareClock() {
    }

    @Override
    public void initializeHardwareClock(double rate, Date now, boolean getTime) {
    }
}

