/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.srcp;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Comparator;
import java.util.ResourceBundle;
import jmri.ClockControl;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.PowerManager;
import jmri.Programmer;
import jmri.SensorManager;
import jmri.ThrottleManager;
import jmri.TurnoutManager;
import jmri.jmrix.ConfiguringSystemConnectionMemo;
import jmri.jmrix.DefaultSystemConnectionMemo;
import jmri.jmrix.srcp.SRCPClockControl;
import jmri.jmrix.srcp.SRCPListener;
import jmri.jmrix.srcp.SRCPMessage;
import jmri.jmrix.srcp.SRCPPowerManager;
import jmri.jmrix.srcp.SRCPProgrammer;
import jmri.jmrix.srcp.SRCPProgrammerManager;
import jmri.jmrix.srcp.SRCPReply;
import jmri.jmrix.srcp.SRCPSensorManager;
import jmri.jmrix.srcp.SRCPThrottleManager;
import jmri.jmrix.srcp.SRCPTrafficController;
import jmri.jmrix.srcp.SRCPTurnoutManager;
import jmri.jmrix.srcp.parser.ASTdescription;
import jmri.jmrix.srcp.parser.ASTdevicegroup;
import jmri.jmrix.srcp.parser.ASTinfo;
import jmri.jmrix.srcp.parser.SimpleNode;
import jmri.jmrix.swing.ComponentFactory;
import jmri.util.NamedBeanComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SRCPBusConnectionMemo
extends DefaultSystemConnectionMemo
implements SRCPListener,
ConfiguringSystemConnectionMemo {
    private int _bus = 0;
    private boolean configured = false;
    private ComponentFactory cf = null;
    private SRCPTrafficController et;
    private static final Logger log = LoggerFactory.getLogger(SRCPBusConnectionMemo.class);

    public SRCPBusConnectionMemo(SRCPTrafficController et, String Prefix, int bus) {
        super(String.valueOf(Prefix) + bus, "SRCP:" + bus);
        this.et = et;
        this._bus = bus;
        log.debug("Created SRCPBusConnectionMemo for bus {}", (Object)bus);
        et.addSRCPListener(this);
        et.sendSRCPMessage(new SRCPMessage("GET " + bus + " DESCRIPTION\n"), null);
        this.configured = false;
    }

    public SRCPTrafficController getTrafficController() {
        return this.et;
    }

    public void setTrafficController(SRCPTrafficController et) {
        this.et = et;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"UW_UNCOND_WAIT"}, justification="false postive, guarded by while statement")
    public void configureManagers() {
        while (!this.configured) {
            SRCPBusConnectionMemo sRCPBusConnectionMemo = this;
            synchronized (sRCPBusConnectionMemo) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.register();
        log.debug("Manager configuration complete for bus {}", (Object)this._bus);
    }

    int getBus() {
        return this._bus;
    }

    public SRCPProgrammerManager getProgrammerManager() {
        return (SRCPProgrammerManager)this.get(GlobalProgrammerManager.class);
    }

    public void setProgrammerManager(SRCPProgrammerManager p) {
        this.store(p, GlobalProgrammerManager.class);
    }

    public ThrottleManager getThrottleManager() {
        return (ThrottleManager)this.get(ThrottleManager.class);
    }

    public void setThrottleManager(ThrottleManager t) {
        this.store(t, ThrottleManager.class);
    }

    public ClockControl getClockControl() {
        return (ClockControl)this.get(ClockControl.class);
    }

    public void setClockControl(ClockControl t) {
        this.store(t, ClockControl.class);
        InstanceManager.store(t, ClockControl.class);
        InstanceManager.setDefault(ClockControl.class, t);
    }

    public PowerManager getPowerManager() {
        return (PowerManager)this.get(PowerManager.class);
    }

    public void setPowerManager(PowerManager p) {
        this.store(p, PowerManager.class);
    }

    public SensorManager getSensorManager() {
        return (SensorManager)this.get(SensorManager.class);
    }

    public void setSensorManager(SensorManager s) {
        this.store(s, SensorManager.class);
    }

    public TurnoutManager getTurnoutManager() {
        return (TurnoutManager)this.get(TurnoutManager.class);
    }

    public void setTurnoutManager(TurnoutManager t) {
        this.store(t, TurnoutManager.class);
    }

    @Override
    protected ResourceBundle getActionModelResourceBundle() {
        return ResourceBundle.getBundle("jmri.jmrix.srcp.SrcpActionListBundle");
    }

    @Override
    public <B extends NamedBean> Comparator<B> getNamedBeanComparator(Class<B> type) {
        return new NamedBeanComparator();
    }

    @Override
    public void dispose() {
        if (this.et != null) {
            this.et = null;
        }
        InstanceManager.deregister(this, SRCPBusConnectionMemo.class);
        if (this.cf != null) {
            InstanceManager.deregister(this.cf, ComponentFactory.class);
        }
        super.dispose();
    }

    @Override
    public void message(SRCPMessage m) {
    }

    @Override
    public void reply(SRCPReply m) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"}, justification="Notify passing reply event, not state")
    public void reply(SimpleNode n) {
        block27: {
            log.debug("SimpleNode Reply called with {}", (Object)n.toString());
            this.reply(new SRCPReply(n));
            if (!(n.jjtGetChild(1) instanceof ASTinfo)) break block27;
            SimpleNode infonode = (SimpleNode)n.jjtGetChild(1);
            if (!((String)((SimpleNode)infonode.jjtGetChild(0)).jjtGetValue()).equals("" + this._bus)) {
                return;
            }
            if (!(infonode.jjtGetChild(1) instanceof ASTdescription)) break block27;
            SimpleNode descnode = (SimpleNode)infonode.jjtGetChild(1);
            int i = 0;
            while (i < descnode.jjtGetNumChildren()) {
                block28: {
                    String DeviceType;
                    SimpleNode child = (SimpleNode)descnode.jjtGetChild(i);
                    log.debug("child node type {} value {}", (Object)child.toString(), child.jjtGetValue());
                    if (!(child instanceof ASTdevicegroup)) break block28;
                    switch (DeviceType = (String)child.jjtGetValue()) {
                        case "FB": {
                            this.setSensorManager(new SRCPSensorManager(this));
                            InstanceManager.setSensorManager(this.getSensorManager());
                            break;
                        }
                        case "GA": {
                            this.setTurnoutManager(new SRCPTurnoutManager(this));
                            InstanceManager.setTurnoutManager(this.getTurnoutManager());
                            break;
                        }
                        case "SM": {
                            this.setProgrammerManager(new SRCPProgrammerManager((Programmer)new SRCPProgrammer(this), this));
                            InstanceManager.store(this.getProgrammerManager(), GlobalProgrammerManager.class);
                            break;
                        }
                        case "POWER": {
                            this.setPowerManager(new SRCPPowerManager(this, this._bus));
                            InstanceManager.store(this.getPowerManager(), PowerManager.class);
                            break;
                        }
                        case "GL": {
                            this.setThrottleManager(new SRCPThrottleManager(this));
                            InstanceManager.setThrottleManager(this.getThrottleManager());
                            break;
                        }
                        case "TIME": {
                            this.setClockControl(new SRCPClockControl(this));
                            break;
                        }
                        default: {
                            log.warn("unexpected DeviceType");
                        }
                    }
                }
                ++i;
            }
            this.configured = true;
            SRCPBusConnectionMemo sRCPBusConnectionMemo = this;
            synchronized (sRCPBusConnectionMemo) {
                this.notifyAll();
            }
        }
    }
}

