/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.sprog.update;

import jmri.jmrix.sprog.update.SprogType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SprogVersion {
    public SprogType sprogType = null;
    public String sprogVersion = "";
    private static final Logger log = LoggerFactory.getLogger(SprogVersion.class);

    public SprogVersion(SprogType t) {
        if (log.isDebugEnabled()) {
            log.debug("SprogVersion(SprogType) ctor: {}", (Object)t.toString());
        }
        this.sprogType = t;
        this.sprogVersion = "";
    }

    public SprogVersion(SprogType t, String s) {
        if (log.isDebugEnabled()) {
            log.debug("SprogVersion(SprogType, String) ctor: {}v{}", (Object)t.toString(), (Object)s);
        }
        if (log.isDebugEnabled()) {
            log.debug("sprogType: {}", (Object)t.sprogType);
        }
        this.sprogType = t;
        this.sprogVersion = s;
    }

    public int getMajorVersion() {
        int major = 0;
        if (this.sprogType.isSprog()) {
            try {
                major = Integer.parseInt(this.sprogVersion.substring(this.sprogVersion.indexOf(".") - 1, this.sprogVersion.indexOf(".")));
            }
            catch (NumberFormatException numberFormatException) {
                log.error("Cannot parse SPROG major version number");
            }
        }
        return major;
    }

    public int getMinorVersion() {
        int minor = 0;
        if (this.sprogType.isSprog()) {
            try {
                minor = Integer.parseInt(this.sprogVersion.substring(this.sprogVersion.indexOf(".") + 1, this.sprogVersion.indexOf(".") + 2));
            }
            catch (NumberFormatException numberFormatException) {
                log.error("Cannot parse SPROG minor version number");
            }
        }
        return minor;
    }

    public boolean hasExtraFeatures() {
        int major = this.getMajorVersion();
        int minor = this.getMinorVersion();
        if (log.isDebugEnabled()) {
            log.debug("Major: {} Minor: {}", (Object)major, (Object)minor);
        }
        if (this.sprogType.isSprogII() && (major == 1 && minor >= 6 || major == 2 && minor >= 1 || major >= 3) || this.sprogType.sprogType >= 23 && this.sprogType.sprogType < 1000) {
            if (log.isDebugEnabled()) {
                log.debug("This version has extra features");
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("This version does not have extra features");
        }
        return false;
    }

    public boolean hasBlueLine() {
        return this.hasExtraFeatures();
    }

    public boolean hasCurrentLimit() {
        return this.hasExtraFeatures();
    }

    public boolean hasFirmwareLock() {
        return this.hasExtraFeatures() || this.sprogType.sprogType <= 1000;
    }

    public boolean hasZTCMode() {
        return this.sprogType.sprogType < 1000;
    }

    public boolean supportsCVHints() {
        int major = this.getMajorVersion();
        int minor = this.getMinorVersion();
        if (log.isDebugEnabled()) {
            log.debug("Major: {} Minor: {}", (Object)major, (Object)minor);
        }
        if (this.sprogType.sprogType == 24 && minor >= 5 || this.sprogType.sprogType == 30 && major == 4 && minor >= 5) {
            if (log.isDebugEnabled()) {
                log.debug("This version supports CV hints");
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("This version does not support CV hints");
        }
        return false;
    }

    public String toString() {
        return this.toString(this);
    }

    public String toString(SprogVersion s) {
        if (log.isDebugEnabled()) {
            log.debug("sprogType: {}", (Object)s.sprogType.sprogType);
        }
        return String.valueOf(s.sprogType.toString()) + " v" + this.sprogVersion;
    }
}

