/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.sprog.update;

import java.awt.event.ActionEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;
import jmri.jmrix.sprog.SprogConstants;
import jmri.jmrix.sprog.SprogListener;
import jmri.jmrix.sprog.SprogMessage;
import jmri.jmrix.sprog.SprogReply;
import jmri.jmrix.sprog.SprogSystemConnectionMemo;
import jmri.jmrix.sprog.SprogTrafficController;
import jmri.jmrix.sprog.update.Bundle;
import jmri.jmrix.sprog.update.SprogHexFile;
import jmri.jmrix.sprog.update.SprogVersion;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SprogUpdateFrame
extends JmriJFrame
implements SprogListener {
    protected JButton programButton = new JButton();
    protected JButton openFileChooserButton = new JButton();
    protected JButton setSprogModeButton = new JButton();
    protected SprogVersion sv;
    final JFileChooser hexFileChooser = new JFileChooser(FileUtil.getUserFilesPath());
    JLabel statusBar = new JLabel();
    transient SprogHexFile hexFile = null;
    SprogMessage msg;
    protected BootState bootState = BootState.IDLE;
    protected int eraseAddress;
    static final boolean UNKNOWN = false;
    static final boolean KNOWN = true;
    protected SprogReply reply;
    protected String replyString;
    int blockLen = 0;
    protected SprogTrafficController tc = null;
    protected SprogSystemConnectionMemo _memo = null;
    protected int V_SHORT_TIMEOUT = 5;
    protected int SHORT_TIMEOUT = 500;
    protected int LONG_TIMEOUT = 4000;
    Timer timer = null;
    private static final Logger log = LoggerFactory.getLogger(SprogUpdateFrame.class);

    public SprogUpdateFrame(SprogSystemConnectionMemo memo) {
        this._memo = memo;
    }

    protected String title() {
        return Bundle.getMessage("SprogXFirmwareUpdate");
    }

    protected void init() {
        this.tc = this._memo.getSprogTrafficController();
        this.tc.setSprogState(SprogConstants.SprogState.NORMAL);
    }

    @Override
    public void dispose() {
        this.tc = null;
        this._memo = null;
        super.dispose();
    }

    @Override
    public void initComponents() {
        this.programButton.setText(Bundle.getMessage("ButtonProgram"));
        this.programButton.setVisible(true);
        this.programButton.setEnabled(false);
        this.programButton.setToolTipText(Bundle.getMessage("ButtonProgramTooltip"));
        this.openFileChooserButton.setText(Bundle.getMessage("ButtonSelectHexFile"));
        this.openFileChooserButton.setVisible(true);
        this.openFileChooserButton.setEnabled(false);
        this.openFileChooserButton.setToolTipText(Bundle.getMessage("ButtonSelectHexFileTooltip"));
        this.setSprogModeButton.setText(Bundle.getMessage("ButtonSetSPROGMode"));
        this.setSprogModeButton.setVisible(true);
        this.setSprogModeButton.setEnabled(false);
        this.setSprogModeButton.setToolTipText(Bundle.getMessage("ButtonSetSPROGModeTooltip"));
        this.statusBar.setVisible(true);
        this.statusBar.setText(" ");
        this.statusBar.setHorizontalTextPosition(2);
        this.setTitle(this.title());
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel paneA = new JPanel();
        paneA.setLayout(new BoxLayout(paneA, 1));
        JPanel buttons1 = new JPanel();
        buttons1.setLayout(new BoxLayout(buttons1, 0));
        buttons1.add(this.openFileChooserButton);
        buttons1.add(this.programButton);
        JPanel buttons2 = new JPanel();
        buttons2.setLayout(new BoxLayout(buttons2, 0));
        buttons2.add(this.setSprogModeButton);
        JPanel status = new JPanel();
        status.setLayout(new BoxLayout(status, 0));
        status.add(this.statusBar);
        paneA.add(buttons1);
        paneA.add(buttons2);
        paneA.add(status);
        this.getContentPane().add(paneA);
        this.openFileChooserButton.addActionListener(e -> this.openFileChooserButtonActionPerformed(e));
        this.programButton.addActionListener(e -> this.programButtonActionPerformed(e));
        this.setSprogModeButton.addActionListener(e -> this.setSprogModeButtonActionPerformed(e));
        this.init();
        this.pack();
        paneA.setMaximumSize(paneA.getSize());
    }

    @Override
    public void notifyMessage(SprogMessage m) {
    }

    @Override
    public synchronized void notifyReply(SprogReply m) {
        this.reply = m;
        this.frameCheck();
        this.replyString = m.toString();
        switch (this.bootState) {
            case IDLE: {
                this.stateIdle();
                break;
            }
            case SETBOOTSENT: {
                this.stateSetBootSent();
                break;
            }
            case VERREQSENT: {
                this.stateBootVerReqSent();
                break;
            }
            case WRITESENT: {
                this.stateWriteSent();
                break;
            }
            case ERASESENT: {
                this.stateEraseSent();
                break;
            }
            case SPROGMODESENT: {
                this.stateSprogModeSent();
                break;
            }
            case RESETSENT: {
                this.stateResetSent();
                break;
            }
            case EOFSENT: {
                this.stateEofSent();
                break;
            }
            case V4RESET: {
                this.stateV4Reset();
                break;
            }
            default: {
                this.stateDefault();
            }
        }
    }

    protected void frameCheck() {
    }

    protected void stateIdle() {
        if (log.isDebugEnabled()) {
            log.debug("reply in IDLE state");
        }
    }

    protected void stateSetBootSent() {
    }

    protected void stateBootVerReqSent() {
    }

    protected void stateWriteSent() {
    }

    protected void stateEraseSent() {
    }

    protected void stateSprogModeSent() {
    }

    protected void stateResetSent() {
    }

    protected void stateEofSent() {
    }

    protected void stateV4Reset() {
    }

    protected synchronized void stateDefault() {
        if (log.isDebugEnabled()) {
            log.debug("Reply in unknown state");
        }
        this.bootState = BootState.IDLE;
        this.tc.setSprogState(SprogConstants.SprogState.NORMAL);
    }

    public synchronized void openFileChooserButtonActionPerformed(ActionEvent e) {
        int retVal = this.hexFileChooser.showOpenDialog(this);
        if (retVal == 0) {
            this.hexFile = new SprogHexFile(this.hexFileChooser.getSelectedFile().getPath());
            if (log.isDebugEnabled()) {
                log.debug("hex file chosen: {}", (Object)this.hexFile.getName());
            }
            if (!this.hexFile.getName().contains("sprog")) {
                JOptionPane.showMessageDialog(this, Bundle.getMessage("HexFileSelectDialogString"), Bundle.getMessage("HexFileSelectTitle"), 0);
                this.hexFile = null;
            } else {
                this.hexFile.openRd();
                this.programButton.setEnabled(true);
            }
        }
    }

    public synchronized void programButtonActionPerformed(ActionEvent e) {
    }

    public void setSprogModeButtonActionPerformed(ActionEvent e) {
    }

    protected abstract void requestBoot();

    protected abstract void sendWrite();

    protected abstract void doneWriting();

    protected synchronized void timeout() {
        if (this.bootState == BootState.CRSENT || this.bootState == BootState.SETBOOTSENT) {
            log.debug("timeout in CRSENT - assuming boot mode");
            this.requestBoot();
        } else if (this.bootState == BootState.VERREQSENT) {
            log.error("timeout in VERREQSENT!");
            JOptionPane.showMessageDialog(this, Bundle.getMessage("ErrorConnectingDialogString"), Bundle.getMessage("FatalErrorTitle"), 0);
            this.statusBar.setText(Bundle.getMessage("ErrorConnectingStatus"));
            this.bootState = BootState.IDLE;
            this.tc.setSprogState(SprogConstants.SprogState.NORMAL);
        } else if (this.bootState == BootState.WRITESENT) {
            log.error("timeout in WRITESENT!");
            JOptionPane.showMessageDialog(this, Bundle.getMessage("ErrorTimeoutDialogString"), Bundle.getMessage("FatalErrorTitle"), 0);
            this.statusBar.setText(Bundle.getMessage("ErrorTimeoutStatus"));
            this.bootState = BootState.IDLE;
            this.tc.setSprogState(SprogConstants.SprogState.NORMAL);
        } else if (this.bootState == BootState.NULLWRITE) {
            if (this.hexFile.read() > 0) {
                this.sendWrite();
            } else {
                this.doneWriting();
            }
        }
    }

    protected void startVShortTimer() {
        this.restartTimer(this.V_SHORT_TIMEOUT);
    }

    protected void startShortTimer() {
        this.restartTimer(this.SHORT_TIMEOUT);
    }

    protected synchronized void startLongTimer() {
        this.restartTimer(this.LONG_TIMEOUT);
    }

    synchronized void stopTimer() {
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    protected synchronized void restartTimer(int delay) {
        if (this.timer == null) {
            this.timer = new Timer(delay, e -> this.timeout());
        }
        this.timer.stop();
        this.timer.setInitialDelay(delay);
        this.timer.setRepeats(false);
        this.timer.start();
    }

    protected static enum BootState {
        IDLE,
        CRSENT,
        QUERYSENT,
        SETBOOTSENT,
        VERREQSENT,
        WRITESENT,
        NULLWRITE,
        ERASESENT,
        SPROGMODESENT,
        RESETSENT,
        EOFSENT,
        V4RESET;

    }
}

