/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.sprog.update;

import jmri.jmrix.sprog.update.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SprogType {
    public static final int UNKNOWN = 0;
    public static final int NO_PROMPT_FOUND = 1;
    public static final int NOT_A_SPROG = 2;
    public static final int NOT_RECOGNISED = 3;
    public static final int TIMEOUT = 4;
    public static final int SPROGV4 = 10;
    public static final int SPROGII = 20;
    public static final int SPROGIIUSB = 21;
    public static final int SPROGIIv3 = 23;
    public static final int SPROGIIv4 = 24;
    public static final int SPROG3 = 30;
    public static final int SPROGIV = 40;
    public static final int SPROG5 = 50;
    public static final int PISPROGONE = 60;
    public static final int NANO = 1000;
    public static final int PISPROGNANO = 1001;
    public static final int SNIFFER = 2000;
    public int sprogType = 0;
    private static final Logger log = LoggerFactory.getLogger(SprogType.class);

    public SprogType(int type) {
        if (log.isDebugEnabled()) {
            log.debug("SprogType(int) ctor, type: {}", (Object)type);
        }
        this.sprogType = type;
    }

    public boolean isSprog() {
        return this.sprogType >= 10;
    }

    public boolean isSprogII() {
        return this.sprogType >= 20 && this.sprogType <= 24;
    }

    public double getCurrentMultiplier() {
        switch (this.sprogType) {
            case 60: {
                return 6.851063829787234;
            }
        }
        return 10.382978723404255;
    }

    public int getBlockLen() {
        switch (this.sprogType) {
            default: {
                return -1;
            }
            case 10: 
            case 20: 
            case 21: {
                return 8;
            }
            case 23: 
            case 24: 
            case 30: 
            case 40: 
            case 50: 
            case 60: 
            case 1000: 
            case 1001: 
            case 2000: 
        }
        return 16;
    }

    public static int getBlockLen(int bootVer) {
        switch (bootVer) {
            case 10: 
            case 11: {
                return 8;
            }
            case 13: {
                return 16;
            }
        }
        return -1;
    }

    public Boolean isValidFlashAddress(int addr) {
        switch (this.sprogType) {
            case 10: 
            case 20: 
            case 21: {
                if (addr < 512) break;
                return true;
            }
            case 23: 
            case 24: 
            case 30: 
            case 40: 
            case 50: 
            case 1000: 
            case 2000: {
                if (addr < 8704 || addr >= 16128) break;
                return true;
            }
            case 1001: {
                if (addr < 3072 || addr >= 8176) break;
                return true;
            }
            case 60: {
                if (addr < 4096 || addr >= 15872) break;
                return true;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    public int getEraseStart() {
        switch (this.sprogType) {
            case 20: 
            case 21: {
                return 512;
            }
            case 23: 
            case 24: 
            case 30: 
            case 40: 
            case 50: 
            case 1000: 
            case 2000: {
                return 8704;
            }
            case 1001: {
                return 3072;
            }
            case 60: {
                return 4096;
            }
        }
        log.error("Can't determine erase start adress");
        return -1;
    }

    public String toString() {
        return this.toString(this.sprogType);
    }

    public String toString(int t) {
        switch (t) {
            case 1: {
                return Bundle.getMessage("TypeNoSprogPromptFound");
            }
            case 2: {
                return Bundle.getMessage("TypeNotConnectedToSPROG");
            }
            case 3: {
                return Bundle.getMessage("TypeUnrecognisedSPROG");
            }
            case 4: {
                return Bundle.getMessage("TypeTimeoutTalkingToSPROG");
            }
            case 10: {
                return "SPROG ";
            }
            case 21: {
                return "SPROG II USB ";
            }
            case 20: {
                return "SPROG II ";
            }
            case 23: {
                return "SPROG IIv3 ";
            }
            case 24: {
                return "SPROG IIv4 ";
            }
            case 30: {
                return "SPROG 3 ";
            }
            case 40: {
                return "SPROG IV ";
            }
            case 50: {
                return "SPROG 5 ";
            }
            case 60: {
                return "Pi-SPROG One ";
            }
            case 1000: {
                return "SPROG Nano ";
            }
            case 1001: {
                return "Pi-SPROG Nano ";
            }
            case 2000: {
                return "SPROG Sniffer ";
            }
        }
        return Bundle.getMessage("TypeUnknownHardware");
    }
}

