/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.sprog.update;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import jmri.jmrix.sprog.SprogConstants;
import jmri.jmrix.sprog.SprogMessage;
import jmri.jmrix.sprog.SprogSystemConnectionMemo;
import jmri.jmrix.sprog.update.Bundle;
import jmri.jmrix.sprog.update.SprogType;
import jmri.jmrix.sprog.update.SprogUpdateFrame;
import jmri.jmrix.sprog.update.SprogVersion;
import jmri.jmrix.sprog.update.SprogVersionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SprogIIUpdateFrame
extends SprogUpdateFrame
implements SprogVersionListener {
    int bootVer = 0;
    private static final Logger log = LoggerFactory.getLogger(SprogIIUpdateFrame.class);

    public SprogIIUpdateFrame(SprogSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    public void initComponents() {
        super.initComponents();
        this.addHelpMenu("package.jmri.jmrix.sprog.update.SprogIIUpdateFrame", true);
        this.tc.setTimeout(SprogConstants.TC_BOOT_REPLY_TIMEOUT);
        this._memo.getSprogVersionQuery().requestVersion(this);
    }

    @Override
    public void dispose() {
        this.stopTimer();
        super.dispose();
    }

    @Override
    @SuppressFBWarnings(value={"SWL_SLEEP_WITH_LOCK_HELD"})
    public synchronized void notifyVersion(SprogVersion v) {
        this.sv = v;
        if (this.sv != null && !this.sv.sprogType.isSprog()) {
            log.debug("SPROG not found - looking for bootloader");
            this.statusBar.setText(Bundle.getMessage("StatusSprogNotFound"));
            this.blockLen = -1;
            this.requestBoot();
        } else if (this.sv != null && this.sv.sprogType.sprogType > 10) {
            this.statusBar.setText(Bundle.getMessage("StatusFoundX", this.sv.toString()));
            this.blockLen = this.sv.sprogType.getBlockLen();
            log.debug("Putting SPROG in boot mode");
            this.msg = new SprogMessage("b 1 1 1");
            this.bootState = SprogUpdateFrame.BootState.SETBOOTSENT;
            this.tc.sendSprogMessage(this.msg, this);
            this.startLongTimer();
        } else {
            log.error("Incorrect SPROG Type detected");
            this.statusBar.setText(Bundle.getMessage("StatusIncorrectSprogType"));
            this.bootState = SprogUpdateFrame.BootState.IDLE;
        }
    }

    @Override
    protected synchronized void frameCheck() {
        if (this.bootState != SprogUpdateFrame.BootState.RESETSENT && this.tc.isSIIBootMode() && !this.reply.strip()) {
            this.stopTimer();
            JOptionPane.showMessageDialog(this, Bundle.getMessage("ErrorFrameDialogString"), Bundle.getMessage("ErrorFrameDialogTitle"), 0);
            log.error("Malformed bootloader reply");
            this.statusBar.setText(Bundle.getMessage("StatusMalformedbootLoaderReply"));
            this.bootState = SprogUpdateFrame.BootState.IDLE;
            this.tc.setSprogState(SprogConstants.SprogState.NORMAL);
            return;
        }
        if (this.bootState != SprogUpdateFrame.BootState.RESETSENT && this.tc.isSIIBootMode() && !this.reply.getChecksum()) {
            log.error("Bad bootloader checksum");
            this.statusBar.setText(Bundle.getMessage("StatusBadBootloaderChecksum"));
            this.bootState = SprogUpdateFrame.BootState.IDLE;
            this.tc.setSprogState(SprogConstants.SprogState.NORMAL);
        }
    }

    @Override
    protected synchronized void stateSetBootSent() {
        this.stopTimer();
        log.debug("reply in SETBOOTSENT state");
        this.bootState = SprogUpdateFrame.BootState.IDLE;
        this.tc.setSprogState(SprogConstants.SprogState.NORMAL);
        JOptionPane.showMessageDialog(this, Bundle.getMessage("ErrorFirmwareLocked"), Bundle.getMessage("SprogXFirmwareUpdate"), 0);
        this.statusBar.setText(Bundle.getMessage("ErrorFirmwareLocked"));
    }

    @Override
    protected synchronized void stateBootVerReqSent() {
        this.stopTimer();
        if (log.isDebugEnabled()) {
            log.debug("reply in VERREQSENT state");
        }
        if (this.reply.getOpCode() == 0 && this.reply.getElement(1) == 2) {
            this.bootVer = this.reply.getElement(2);
            if (log.isDebugEnabled()) {
                log.debug("Found bootloader version {}", (Object)this.bootVer);
            }
            this.statusBar.setText(Bundle.getMessage("StatusConnectedToBootloader", this.bootVer));
            this.setSprogModeButton.setEnabled(true);
            this.openFileChooserButton.setEnabled(true);
            if (this.blockLen > 0) {
                if (this.blockLen != SprogType.getBlockLen(this.bootVer)) {
                    log.error("Bootloader version does not match SPROG type");
                    this.bootState = SprogUpdateFrame.BootState.IDLE;
                }
            } else {
                this.sv = this.bootVer <= 11 ? new SprogVersion(new SprogType(20), "") : new SprogVersion(new SprogType(23), "");
                this.blockLen = this.sv.sprogType.getBlockLen();
            }
        } else {
            log.error("Bad reply to RD_VER request");
            this.bootState = SprogUpdateFrame.BootState.IDLE;
            this.tc.setSprogState(SprogConstants.SprogState.NORMAL);
            JOptionPane.showMessageDialog(this, Bundle.getMessage("StatusUnableToConnectBootloader"), Bundle.getMessage("SprogXFirmwareUpdate"), 0);
            this.statusBar.setText(Bundle.getMessage("StatusUnableToConnectBootloader"));
        }
    }

    @Override
    protected synchronized void stateWriteSent() {
        this.stopTimer();
        if (log.isDebugEnabled()) {
            log.debug("reply in WRITESENT state");
        }
        if (this.reply.getOpCode() == this.msg.getElement(2) && this.reply.getNumDataElements() == 1 || this.reply.getElement(this.reply.getNumDataElements() - 1) == 46) {
            if (this.hexFile.read() > 0) {
                this.sendWrite();
            } else {
                this.doneWriting();
            }
        } else {
            log.error("Bad reply to write request");
            this.statusBar.setText(Bundle.getMessage("StatusBadReplyWriteRequest"));
            this.bootState = SprogUpdateFrame.BootState.IDLE;
            this.tc.setSprogState(SprogConstants.SprogState.NORMAL);
        }
    }

    @Override
    protected synchronized void stateEraseSent() {
        this.stopTimer();
        if (log.isDebugEnabled()) {
            log.debug("reply in ERASESENT state");
        }
        if (this.reply.getOpCode() == this.msg.getElement(2) && this.reply.getNumDataElements() == 1) {
            if (this.sv.sprogType.sprogType < 23 && this.eraseAddress < 31744 || this.sv.sprogType.sprogType >= 23 && this.eraseAddress < 16128) {
                this.sendErase();
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Finished erasing");
                }
                this.statusBar.setText(Bundle.getMessage("StatusEraseComplete"));
                if (this.hexFile.read() > 0) {
                    if (log.isDebugEnabled()) {
                        log.debug("First write {} {}", (Object)this.hexFile.getLen(), (Object)this.hexFile.getAddress());
                    }
                    this.sendWrite();
                } else {
                    this.doneWriting();
                }
            }
        } else {
            log.error("Bad reply to erase request");
            this.bootState = SprogUpdateFrame.BootState.IDLE;
            this.tc.setSprogState(SprogConstants.SprogState.NORMAL);
        }
    }

    @Override
    protected synchronized void stateSprogModeSent() {
        this.stopTimer();
        if (log.isDebugEnabled()) {
            log.debug("reply in SROGMODESENT state");
        }
        if (this.reply.getOpCode() == this.msg.getElement(2) && this.reply.getNumDataElements() == 1) {
            if (log.isDebugEnabled()) {
                log.debug("Reset SPROG");
            }
            this.msg = SprogMessage.getReset();
            this.bootState = SprogUpdateFrame.BootState.RESETSENT;
            this.tc.sendSprogMessage(this.msg, this);
            this.startLongTimer();
        } else {
            log.error("Bad reply to SPROG Mode request");
            this.bootState = SprogUpdateFrame.BootState.IDLE;
            this.tc.setSprogState(SprogConstants.SprogState.NORMAL);
        }
    }

    @Override
    protected synchronized void stateResetSent() {
        this.stopTimer();
        if (log.isDebugEnabled()) {
            log.debug("reply in RESETSENT state");
        }
        this.statusBar.setText(Bundle.getMessage("DefaultStatusText"));
        this.tc.setSprogState(SprogConstants.SprogState.NORMAL);
        this.bootState = SprogUpdateFrame.BootState.IDLE;
    }

    @Override
    protected synchronized void requestBoot() {
        if (log.isDebugEnabled()) {
            log.debug("Request bootloader version");
        }
        if (this.tc == null) {
            log.warn("requestBoot with null tc, ignored");
            return;
        }
        this.tc.setSprogState(SprogConstants.SprogState.SIIBOOTMODE);
        this.bootState = SprogUpdateFrame.BootState.VERREQSENT;
        this.msg = SprogMessage.getReadBootVersion();
        this.tc.sendSprogMessage(this.msg, this);
        this.startLongTimer();
    }

    @Override
    protected synchronized void sendWrite() {
        if ((this.hexFile.getAddressU() & 0xFF) >= 240) {
            if (log.isDebugEnabled()) {
                log.debug("Send write EE {}", (Object)this.hexFile.getAddress());
            }
            this.msg = SprogMessage.getWriteEE(this.hexFile.getAddress(), this.hexFile.getData());
        } else if ((this.hexFile.getAddressU() & 0xFF) >= 32) {
            if (log.isDebugEnabled()) {
                log.debug("null write {}", (Object)this.hexFile.getAddress());
            }
            this.msg = null;
        } else if (this.sv.sprogType.isValidFlashAddress(this.hexFile.getAddress()).booleanValue()) {
            if (log.isDebugEnabled()) {
                log.debug("Send write Flash {}", (Object)this.hexFile.getAddress());
            }
            this.msg = SprogMessage.getWriteFlash(this.hexFile.getAddress(), this.hexFile.getData(), this.blockLen);
            if (log.isDebugEnabled()) {
                log.debug(this.msg.toString(true));
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug("null write {}", (Object)this.hexFile.getAddress());
            }
            this.msg = null;
        }
        if (this.msg != null) {
            this.bootState = SprogUpdateFrame.BootState.WRITESENT;
            this.statusBar.setText(Bundle.getMessage("StatusWriteX", this.hexFile.getAddress()));
            this.tc.sendSprogMessage(this.msg, this);
            if (log.isDebugEnabled()) {
                log.debug("Sent write command to address {}", (Object)this.hexFile.getAddress());
            }
            this.startLongTimer();
        } else {
            this.bootState = SprogUpdateFrame.BootState.NULLWRITE;
            this.statusBar.setText(Bundle.getMessage("StatusSkipX", this.hexFile.getAddress()));
            this.startVShortTimer();
        }
    }

    private synchronized void sendErase() {
        if (log.isDebugEnabled()) {
            log.debug("Erase Flash {}", (Object)this.eraseAddress);
        }
        int rows = 8;
        this.msg = SprogMessage.getEraseFlash(this.eraseAddress, rows);
        this.bootState = SprogUpdateFrame.BootState.ERASESENT;
        this.statusBar.setText(Bundle.getMessage("StatusEraseX", this.eraseAddress));
        this.tc.sendSprogMessage(this.msg, this);
        if (log.isDebugEnabled()) {
            log.debug("Sent erase command to address {}", (Object)this.eraseAddress);
        }
        this.eraseAddress += rows * 64;
        this.startLongTimer();
    }

    @Override
    protected synchronized void doneWriting() {
        if (log.isDebugEnabled()) {
            log.debug("Done writing");
        }
        this.statusBar.setText(Bundle.getMessage("StatusWriteComplete"));
        this.openFileChooserButton.setEnabled(false);
        this.programButton.setEnabled(false);
        this.setSprogModeButton.setEnabled(true);
        this.bootState = SprogUpdateFrame.BootState.IDLE;
    }

    @Override
    public synchronized void programButtonActionPerformed(ActionEvent e) {
        if (this.hexFile != null) {
            this.openFileChooserButton.setEnabled(false);
            this.programButton.setEnabled(false);
            this.setSprogModeButton.setEnabled(false);
            this.eraseAddress = this.sv.sprogType.getEraseStart();
            if (this.eraseAddress > 0) {
                if (log.isDebugEnabled()) {
                    log.debug("Start erasing @{}", (Object)this.eraseAddress);
                }
                this.sendErase();
            }
        }
    }

    @Override
    public synchronized void setSprogModeButtonActionPerformed(ActionEvent e) {
        if (log.isDebugEnabled()) {
            log.debug("Set SPROG mode");
        }
        this.msg = SprogMessage.getWriteEE(255, new int[1]);
        this.bootState = SprogUpdateFrame.BootState.SPROGMODESENT;
        this.tc.resetTimeout();
        this.tc.sendSprogMessage(this.msg, this);
        this.startLongTimer();
    }
}

