/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.sprog.simulator;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import jmri.JmriException;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.sprog.SprogConstants;
import jmri.jmrix.sprog.SprogMessage;
import jmri.jmrix.sprog.SprogPortController;
import jmri.jmrix.sprog.SprogReply;
import jmri.jmrix.sprog.SprogSystemConnectionMemo;
import jmri.jmrix.sprog.SprogTrafficController;
import jmri.jmrix.sprog.simulator.Bundle;
import jmri.util.ImmediatePipedOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimulatorAdapter
extends SprogPortController
implements Runnable {
    private boolean opened = false;
    private Thread sourceThread;
    private SprogTrafficController control;
    private boolean outputBufferEmpty = true;
    private boolean checkBuffer = true;
    private SprogConstants.SprogMode operatingMode = SprogConstants.SprogMode.SERVICE;
    String SPR_OK = "OK";
    String SPR_NO = "No Ack";
    String SPR_PR = "\nP> ";
    private DataOutputStream pout = null;
    private DataInputStream pin = null;
    private DataOutputStream outpipe = null;
    private DataInputStream inpipe = null;
    private static final Logger log = LoggerFactory.getLogger(SimulatorAdapter.class);

    public SimulatorAdapter() {
        super(new SprogSystemConnectionMemo(SprogConstants.SprogMode.SERVICE));
        this.setManufacturer("SPROG DCC");
        this.getSystemConnectionMemo().setUserName(Bundle.getMessage("SprogSimulatorTitle"));
        this.control = new SprogTrafficController(this.getSystemConnectionMemo());
        this.getSystemConnectionMemo().setSprogTrafficController(this.control);
        this.options.put("NumSlots", new AbstractPortController.Option(Bundle.getMessage("MakeLabel", Bundle.getMessage("NumSlotOptions")), new String[]{"16", "8", "32", "48", "64"}, true));
        this.options.put("OperatingMode", new AbstractPortController.Option(Bundle.getMessage("MakeLabel", Bundle.getMessage("SprogSimOption")), new String[]{Bundle.getMessage("SprogProgrammerTitle"), Bundle.getMessage("SprogCSTitle")}, true));
    }

    @Override
    public String openPort(String portName, String appName) {
        try {
            ImmediatePipedOutputStream tempPipeI = new ImmediatePipedOutputStream();
            log.debug("tempPipeI created");
            this.pout = new DataOutputStream(tempPipeI);
            this.inpipe = new DataInputStream(new PipedInputStream(tempPipeI));
            log.debug("inpipe created {}", (Object)(this.inpipe != null ? 1 : 0));
            ImmediatePipedOutputStream tempPipeO = new ImmediatePipedOutputStream();
            this.outpipe = new DataOutputStream(tempPipeO);
            this.pin = new DataInputStream(new PipedInputStream(tempPipeO));
        }
        catch (IOException e) {
            log.error("init (pipe): Exception: {}", (Object)e.toString());
        }
        this.opened = true;
        return null;
    }

    public synchronized void setOutputBufferEmpty(boolean s) {
        this.outputBufferEmpty = s;
    }

    public boolean okToSend() {
        if (this.checkBuffer) {
            log.debug("Buffer Empty: {}", (Object)this.outputBufferEmpty);
            return this.outputBufferEmpty;
        }
        log.debug("No Flow Control or Buffer Check");
        return true;
    }

    @Override
    public void configure() {
        int numSlots;
        this.getSystemConnectionMemo().getSprogTrafficController().connectPort(this);
        this.operatingMode = this.getOptionState("OperatingMode") != null && this.getOptionState("OperatingMode").equals(Bundle.getMessage("SprogProgrammerTitle")) ? SprogConstants.SprogMode.SERVICE : SprogConstants.SprogMode.OPS;
        String slots = this.getOptionState("NumSlots");
        try {
            numSlots = Integer.parseInt(slots);
        }
        catch (NumberFormatException numberFormatException) {
            numSlots = 16;
        }
        this.getSystemConnectionMemo().setSprogMode(this.operatingMode);
        this.getSystemConnectionMemo().configureCommandStation(numSlots);
        this.getSystemConnectionMemo().configureManagers();
        if (this.getOptionState("TrackPowerState") != null && this.getOptionState("TrackPowerState").equals(Bundle.getMessage("PowerStateOn"))) {
            try {
                this.getSystemConnectionMemo().getPowerManager().setPower(2);
            }
            catch (JmriException e) {
                log.error(e.toString());
            }
        }
        log.debug("SimulatorAdapter configure() with prefix = {}", (Object)this.getSystemConnectionMemo().getSystemPrefix());
        this.sourceThread = new Thread(this);
        this.sourceThread.setName("SPROG Simulator");
        this.sourceThread.setPriority(1);
        this.sourceThread.start();
    }

    @Override
    public void connect() throws IOException {
        log.debug("connect called");
        super.connect();
    }

    @Override
    public DataInputStream getInputStream() {
        if (!this.opened || this.pin == null) {
            log.error("getInputStream called before load(), stream not available");
        }
        log.debug("DataInputStream pin returned");
        return this.pin;
    }

    @Override
    public DataOutputStream getOutputStream() {
        if (!this.opened || this.pout == null) {
            log.error("getOutputStream called before load(), stream not available");
        }
        log.debug("DataOutputStream pout returned");
        return this.pout;
    }

    @Override
    public boolean status() {
        return this.pout != null && this.pin != null;
    }

    @Override
    public String[] validBaudRates() {
        log.debug("validBaudRates should not have been invoked");
        return new String[0];
    }

    @Override
    public int[] validBaudNumbers() {
        return new int[0];
    }

    @Override
    public String getCurrentBaudRate() {
        return "";
    }

    @Override
    public String getCurrentPortName() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.info("SPROG Simulator Started");
        while (true) {
            try {
                SimulatorAdapter simulatorAdapter = this;
                synchronized (simulatorAdapter) {
                    this.wait(50L);
                }
            }
            catch (InterruptedException interruptedException) {
                log.debug("interrupted, ending");
                return;
            }
            SprogMessage m = this.readMessage();
            if (log.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf.append("SPROG Simulator Thread received message: ");
                if (m != null) {
                    buf.append(m);
                } else {
                    buf.append("null message buffer");
                }
            }
            if (m == null) continue;
            SprogReply r = this.generateReply(m);
            this.writeReply(r);
            log.debug("Simulator Thread sent Reply: \"{}\"", (Object)r);
        }
    }

    private SprogMessage readMessage() {
        SprogMessage msg = null;
        try {
            if (this.inpipe != null && this.inpipe.available() > 0) {
                msg = this.loadChars();
            }
        }
        catch (IOException iOException) {}
        this.setOutputBufferEmpty(true);
        return msg;
    }

    private SprogReply generateReply(SprogMessage msg) {
        log.debug("Generate Reply to message type {} (string = {})", (Object)Character.valueOf(msg.toString().charAt(0)), (Object)msg.toString());
        SprogReply reply = new SprogReply();
        int i = 0;
        char command = msg.toString().charAt(0);
        log.debug("Message type = {}", (Object)Character.valueOf(command));
        switch (command) {
            case 'I': {
                log.debug("CurrentQuery detected");
                reply = new SprogReply("= h3E7\n");
                break;
            }
            case 'C': 
            case 'V': {
                log.debug("Read/Write CV detected");
                reply = new SprogReply("= h" + msg.toString().substring(2) + "\n");
                break;
            }
            case 'D': 
            case 'U': {
                log.debug("Read/Write CV with hint detected");
                reply = new SprogReply("= h" + msg.toString().substring(2) + "\n");
                break;
            }
            case 'O': {
                log.debug("Send packet command detected");
                reply = new SprogReply("= " + msg.toString().substring(2) + "\n");
                break;
            }
            case 'A': {
                log.debug("Address (open Throttle) command detected");
                reply = new SprogReply(String.valueOf(msg.toString().substring(2)) + "\n");
                break;
            }
            case '>': {
                log.debug("Set speed (Throttle) command detected");
                reply = new SprogReply(String.valueOf(msg.toString().substring(1)) + "\n");
                break;
            }
            case '+': {
                log.debug("TRACK_POWER_ON detected");
                break;
            }
            case '-': {
                log.debug("TRACK_POWER_OFF detected");
                break;
            }
            case '?': {
                log.debug("Read_Sprog_Version detected");
                String replyString = "\nSPROG II Ver 4.5\n";
                reply = new SprogReply(replyString);
                break;
            }
            case 'M': {
                log.debug("Mode Word detected");
                reply = new SprogReply("P>M=h800\n");
                break;
            }
            case 'S': {
                log.debug("getStatus detected");
                reply = new SprogReply("OK\n");
                break;
            }
            case ' ': {
                log.debug("null command detected");
                reply = new SprogReply("\n");
                break;
            }
            default: {
                log.debug("non-reply message detected: {}", (Object)msg.toString());
                reply = new SprogReply("!E\n");
            }
        }
        i = reply.toString().length();
        reply.setElement(i++, 80);
        reply.setElement(i++, 62);
        reply.setElement(i++, 32);
        log.debug("Reply generated = \"{}\"", (Object)reply.toString());
        return reply;
    }

    private void writeReply(SprogReply r) {
        if (r == null) {
            return;
        }
        int len = r.getNumDataElements();
        int i = 0;
        while (i < len) {
            try {
                this.outpipe.writeByte((byte)r.getElement(i));
                if (this.pin.available() > 0) {
                    this.control.handleOneIncomingReply();
                }
            }
            catch (IOException iOException) {}
            ++i;
        }
        try {
            this.outpipe.flush();
        }
        catch (IOException iOException) {}
    }

    private SprogMessage loadChars() throws IOException {
        byte[] rcvBuffer = new byte[32];
        int nchars = this.inpipe.read(rcvBuffer, 0, 32);
        SprogMessage msg = new SprogMessage(nchars);
        int i = 0;
        while (i < nchars) {
            msg.setElement(i, rcvBuffer[i] & 0xFF);
            ++i;
        }
        return msg;
    }
}

