/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.sprog.serialdriver;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.TooManyListenersException;
import jmri.JmriException;
import jmri.jmrix.sprog.SprogConstants;
import jmri.jmrix.sprog.SprogPortController;
import jmri.jmrix.sprog.SprogSystemConnectionMemo;
import jmri.jmrix.sprog.SprogTrafficController;
import jmri.jmrix.sprog.serialdriver.Bundle;
import jmri.jmrix.sprog.update.SprogType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import purejavacomm.CommPortIdentifier;
import purejavacomm.NoSuchPortException;
import purejavacomm.PortInUseException;
import purejavacomm.PureJavaIllegalStateException;
import purejavacomm.SerialPort;
import purejavacomm.UnsupportedCommOperationException;

public class SerialDriverAdapter
extends SprogPortController {
    SerialPort activeSerialPort = null;
    private int baudRate = -1;
    InputStream serialStream = null;
    protected int numSlots = 1;
    private static final Logger log = LoggerFactory.getLogger(SerialDriverAdapter.class);

    public SerialDriverAdapter() {
        super(new SprogSystemConnectionMemo(SprogConstants.SprogMode.SERVICE));
        this.baudRate = 9600;
        this.getSystemConnectionMemo().setUserName(Bundle.getMessage("SprogProgrammerTitle"));
        this.getSystemConnectionMemo().setSprogTrafficController(new SprogTrafficController(this.getSystemConnectionMemo()));
    }

    public SerialDriverAdapter(SprogConstants.SprogMode sm) {
        super(new SprogSystemConnectionMemo(sm));
        this.baudRate = 9600;
        this.getSystemConnectionMemo().setUserName("SPROG");
        this.getSystemConnectionMemo().setSprogTrafficController(new SprogTrafficController(this.getSystemConnectionMemo()));
    }

    public SerialDriverAdapter(SprogConstants.SprogMode sm, int baud, SprogType type) {
        super(new SprogSystemConnectionMemo(sm, type));
        this.baudRate = baud;
        this.getSystemConnectionMemo().setUserName("SPROG");
        this.getSystemConnectionMemo().setSprogTrafficController(new SprogTrafficController(this.getSystemConnectionMemo()));
    }

    public SerialDriverAdapter(SprogConstants.SprogMode sm, int baud) {
        super(new SprogSystemConnectionMemo(sm));
        this.baudRate = baud;
        this.getSystemConnectionMemo().setUserName("SPROG");
        this.getSystemConnectionMemo().setSprogTrafficController(new SprogTrafficController(this.getSystemConnectionMemo()));
    }

    @Override
    public String openPort(String portName, String appName) {
        try {
            CommPortIdentifier portID = CommPortIdentifier.getPortIdentifier(portName);
            try {
                this.activeSerialPort = (SerialPort)portID.open(appName, 2000);
            }
            catch (PortInUseException p) {
                return this.handlePortBusy(p, portName, log);
            }
            try {
                this.activeSerialPort.setSerialPortParams(this.baudRate, 8, 1, 0);
            }
            catch (UnsupportedCommOperationException e) {
                log.error("Cannot set serial parameters on port {}: {}", (Object)portName, (Object)e.getMessage());
                return "Cannot set serial parameters on port " + portName + ": " + e.getMessage();
            }
            boolean doNotlog = false;
            try {
                this.activeSerialPort.setRTS(true);
                this.activeSerialPort.setDTR(true);
            }
            catch (PureJavaIllegalStateException pureJavaIllegalStateException) {
                log.info("Cannot setRTS/DTR will continue anyway");
                doNotlog = true;
            }
            log.debug("Serial timeout was observed as: {} {}", (Object)this.activeSerialPort.getReceiveTimeout(), (Object)this.activeSerialPort.isReceiveTimeoutEnabled());
            this.serialStream = this.activeSerialPort.getInputStream();
            this.purgeStream(this.serialStream);
            if (log.isInfoEnabled()) {
                if (doNotlog) {
                    log.info("{} port opened at {} baud", (Object)portName, (Object)this.activeSerialPort.getBaudRate());
                } else {
                    log.info("{} port opened at {} baud, sees  DTR: {} RTS: {} DSR: {} CTS: {}  CD: {}", new Object[]{portName, this.activeSerialPort.getBaudRate(), this.activeSerialPort.isDTR(), this.activeSerialPort.isRTS(), this.activeSerialPort.isDSR(), this.activeSerialPort.isCTS(), this.activeSerialPort.isCD()});
                }
            }
            try {
                this.activeSerialPort.addEventListener(this.getSystemConnectionMemo().getSprogTrafficController());
            }
            catch (TooManyListenersException tooManyListenersException) {}
            this.activeSerialPort.notifyOnDataAvailable(true);
            this.opened = true;
        }
        catch (NoSuchPortException p) {
            return this.handlePortNotFound(p, portName, log);
        }
        catch (IOException ex) {
            log.error("Unexpected exception while opening port {}", (Object)portName, (Object)ex);
            return "Unexpected error while opening port " + portName + ": " + ex;
        }
        return null;
    }

    public void setHandshake(int mode) {
        try {
            this.activeSerialPort.setFlowControlMode(mode);
        }
        catch (UnsupportedCommOperationException ex) {
            log.error("Unexpected exception while setting COM port handshake mode,", (Throwable)ex);
        }
    }

    @Override
    public DataInputStream getInputStream() {
        if (!this.opened) {
            log.error("getInputStream called before load(), stream not available");
            return null;
        }
        return new DataInputStream(this.serialStream);
    }

    @Override
    public DataOutputStream getOutputStream() {
        if (!this.opened) {
            log.error("getOutputStream called before load(), stream not available");
        }
        try {
            return new DataOutputStream(this.activeSerialPort.getOutputStream());
        }
        catch (IOException e) {
            log.error("getOutputStream exception: {}", (Throwable)e);
            return null;
        }
    }

    @Override
    public String[] validBaudRates() {
        return new String[]{"9,600 bps"};
    }

    @Override
    public int[] validBaudNumbers() {
        return new int[]{9600};
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }

    @Override
    public void configure() {
        this.getSystemConnectionMemo().getSprogTrafficController().connectPort(this);
        this.getSystemConnectionMemo().configureCommandStation(this.numSlots);
        this.getSystemConnectionMemo().configureManagers();
        if (this.getOptionState("TrackPowerState") != null && this.getOptionState("TrackPowerState").equals(Bundle.getMessage("PowerStateOn"))) {
            try {
                this.getSystemConnectionMemo().getPowerManager().setPower(2);
            }
            catch (JmriException e) {
                log.error(e.toString());
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}

