/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.sprog.console;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.Timer;
import jmri.jmrix.AbstractMonFrame;
import jmri.jmrix.sprog.SprogListener;
import jmri.jmrix.sprog.SprogMessage;
import jmri.jmrix.sprog.SprogReply;
import jmri.jmrix.sprog.SprogSystemConnectionMemo;
import jmri.jmrix.sprog.SprogTrafficController;
import jmri.jmrix.sprog.console.Bundle;
import jmri.jmrix.sprog.update.SprogVersion;
import jmri.jmrix.sprog.update.SprogVersionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SprogConsoleFrame
extends AbstractMonFrame
implements SprogListener,
SprogVersionListener {
    private SprogSystemConnectionMemo _memo = null;
    protected JLabel cmdLabel = new JLabel();
    protected JLabel currentLabel = new JLabel();
    protected JButton sendButton = new JButton();
    protected JButton saveButton = new JButton();
    protected JTextField cmdTextField = new JTextField(12);
    protected JTextField currentTextField = new JTextField(12);
    protected JCheckBox ztcCheckBox = new JCheckBox();
    protected JCheckBox blueCheckBox = new JCheckBox();
    protected JCheckBox unlockCheckBox = new JCheckBox();
    protected ButtonGroup speedGroup = new ButtonGroup();
    protected JLabel speedLabel = new JLabel();
    protected JRadioButton speed14Button = new JRadioButton(Bundle.getMessage("ButtonXStep", 14));
    protected JRadioButton speed28Button = new JRadioButton(Bundle.getMessage("ButtonXStep", 28));
    protected JRadioButton speed128Button = new JRadioButton(Bundle.getMessage("ButtonXStep", 128));
    protected int modeWord;
    protected int currentLimit = 996;
    SprogTrafficController tc = null;
    String replyString;
    String tmpString = null;
    State state = State.IDLE;
    SprogVersion sv;
    protected int TIMEOUT = 1000;
    Timer timer = null;
    private static final Logger log = LoggerFactory.getLogger(SprogConsoleFrame.class);

    public SprogConsoleFrame(SprogSystemConnectionMemo memo) {
        this._memo = memo;
    }

    @Override
    protected String title() {
        return Bundle.getMessage("SprogConsoleTitle");
    }

    @Override
    protected void init() {
        this.tc = this._memo.getSprogTrafficController();
        this.tc.addSprogListener(this);
    }

    @Override
    public void dispose() {
        if (this.tc != null) {
            this.tc.removeSprogListener(this);
        }
        super.dispose();
    }

    @Override
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"})
    public void initComponents() {
        super.initComponents();
        this.jScrollPane1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("CommandHistoryTitle")));
        this.entryField.addActionListener(e -> this.enterButtonActionPerformed(e));
        JPanel cmdPane1 = new JPanel();
        cmdPane1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("SendCommandTitle")));
        cmdPane1.setLayout(new FlowLayout());
        this.cmdLabel.setText(Bundle.getMessage("CommandLabel"));
        this.cmdLabel.setVisible(true);
        this.sendButton.setText(Bundle.getMessage("ButtonSend"));
        this.sendButton.setVisible(true);
        this.sendButton.setToolTipText(Bundle.getMessage("SendPacketTooltip"));
        this.cmdTextField.setText("");
        this.cmdTextField.setToolTipText(Bundle.getMessage("EnterSPROGCommandTooltip", Bundle.getMessage("ButtonSend")));
        this.cmdTextField.setMaximumSize(new Dimension(this.cmdTextField.getMaximumSize().width, this.cmdTextField.getPreferredSize().height));
        this.cmdTextField.addActionListener(e -> this.sendButtonActionPerformed(e));
        this.sendButton.addActionListener(e -> this.sendButtonActionPerformed(e));
        cmdPane1.add(this.cmdLabel);
        cmdPane1.add(this.cmdTextField);
        cmdPane1.add(this.sendButton);
        this.getContentPane().add(cmdPane1);
        JPanel speedPanel = new JPanel();
        speedPanel.setBorder(BorderFactory.createEtchedBorder());
        this.speedLabel.setText(Bundle.getMessage("SpeedStepModeLabel"));
        speedPanel.add(this.speedLabel);
        speedPanel.add(this.speed14Button);
        speedPanel.add(this.speed28Button);
        speedPanel.add(this.speed128Button);
        this.speedGroup.add(this.speed14Button);
        this.speedGroup.add(this.speed28Button);
        this.speedGroup.add(this.speed128Button);
        this.speed14Button.setToolTipText(Bundle.getMessage("ButtonXStepTooltip", 14));
        this.speed28Button.setToolTipText(Bundle.getMessage("ButtonXStepTooltip", 28));
        this.speed128Button.setToolTipText(Bundle.getMessage("ButtonXStepTooltip", 128));
        JPanel configPanel = new JPanel();
        this.currentLabel.setText(Bundle.getMessage("CurrentLimitLabel"));
        this.currentLabel.setVisible(true);
        this.currentTextField.setText("");
        this.currentTextField.setEnabled(false);
        this.currentTextField.setToolTipText(Bundle.getMessage("CurrentLimitFieldTooltip"));
        this.currentTextField.setMaximumSize(new Dimension(this.currentTextField.getMaximumSize().width, this.currentTextField.getPreferredSize().height));
        this.ztcCheckBox.setText(Bundle.getMessage("ButtonSetZTCMode"));
        this.ztcCheckBox.setVisible(true);
        this.ztcCheckBox.setToolTipText(Bundle.getMessage("ButtonSetZTCModeTooltip"));
        this.blueCheckBox.setText(Bundle.getMessage("ButtonSetBluelineMode"));
        this.blueCheckBox.setVisible(true);
        this.blueCheckBox.setEnabled(false);
        this.blueCheckBox.setToolTipText(Bundle.getMessage("ButtonSetBluelineModeTooltip"));
        this.unlockCheckBox.setText(Bundle.getMessage("ButtonUnlockFirmware"));
        this.unlockCheckBox.setVisible(true);
        this.unlockCheckBox.setEnabled(false);
        this.unlockCheckBox.setToolTipText(Bundle.getMessage("ButtonUnlockFirmwareTooltip"));
        configPanel.add(this.currentLabel);
        configPanel.add(this.currentTextField);
        configPanel.add(this.ztcCheckBox);
        configPanel.add(this.blueCheckBox);
        configPanel.add(this.unlockCheckBox);
        JPanel statusPanel = new JPanel();
        statusPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("ConfigurationTitle")));
        statusPanel.setLayout(new BoxLayout(statusPanel, 1));
        this.saveButton.setText(Bundle.getMessage("ButtonApply"));
        this.saveButton.setVisible(true);
        this.saveButton.setToolTipText(Bundle.getMessage("ButtonApplyTooltip"));
        this.saveButton.addActionListener(e -> this.saveButtonActionPerformed(e));
        statusPanel.add(speedPanel);
        statusPanel.add(configPanel);
        statusPanel.add(this.saveButton);
        this.getContentPane().add(statusPanel);
        this.pack();
        cmdPane1.setMaximumSize(statusPanel.getSize());
        statusPanel.setMaximumSize(statusPanel.getSize());
        this.pack();
        this._memo.getSprogVersionQuery().requestVersion(this);
    }

    @Override
    protected void setHelp() {
        this.addHelpMenu("package.jmri.jmrix.sprog.console.SprogConsoleFrame", true);
    }

    public void sendButtonActionPerformed(ActionEvent e) {
        SprogMessage m = new SprogMessage(this.cmdTextField.getText());
        this.nextLine("cmd: \"" + m.toString(this._memo.getSprogTrafficController().isSIIBootMode()) + "\"\n", "");
        this.tc.sendSprogMessage(m, this);
    }

    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"})
    public void validateCurrent() {
        String currentRange = "200 - 996";
        int validLimit = 996;
        if (this._memo.getSprogVersion().sprogType.sprogType > 23) {
            currentRange = "200 - 2499";
            validLimit = 2499;
        }
        try {
            this.currentLimit = Integer.parseInt(this.currentTextField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(null, Bundle.getMessage("CurrentLimitDialogString", currentRange), Bundle.getMessage("SprogConsoleTitle"), 0);
            this.currentLimit = validLimit;
            return;
        }
        if (this.currentLimit > validLimit || this.currentLimit < 200) {
            JOptionPane.showMessageDialog(null, Bundle.getMessage("CurrentLimitDialogString", currentRange), Bundle.getMessage("SprogConsoleTitle"), 0);
            this.currentLimit = validLimit;
        }
    }

    public synchronized void saveButtonActionPerformed(ActionEvent e) {
        SprogMessage saveMsg;
        this.state = State.CURRENTSENT;
        if (this.isCurrentLimitPossible()) {
            this.validateCurrent();
            int currentLimitForHardware = (int)((double)this.currentLimit * (1.0 / this.sv.sprogType.getCurrentMultiplier()));
            if (this.sv.sprogType.sprogType < 23) {
                currentLimitForHardware += 256;
            }
            this.tmpString = String.valueOf(currentLimitForHardware);
            saveMsg = new SprogMessage("I " + this.tmpString);
        } else {
            saveMsg = new SprogMessage(" " + this.tmpString);
        }
        this.nextLine("cmd: \"" + saveMsg.toString(this._memo.getSprogTrafficController().isSIIBootMode()) + "\"\n", "");
        this.tc.sendSprogMessage(saveMsg, this);
    }

    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"})
    public boolean isCurrentLimitPossible() {
        return this.sv.hasCurrentLimit();
    }

    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"})
    public boolean isBlueLineSupportPossible() {
        return this.sv.hasBlueLine();
    }

    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"})
    public boolean isFirmwareUnlockPossible() {
        return this.sv.hasFirmwareLock();
    }

    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"})
    public boolean isZTCModePossible() {
        return this.sv.hasZTCMode();
    }

    @Override
    public synchronized void notifyVersion(SprogVersion v) {
        this.sv = v;
        this._memo.setSprogVersion(v);
        if (log.isDebugEnabled()) {
            log.debug("Found: {}", (Object)this.sv.toString());
        }
        if (!this.sv.sprogType.isSprog()) {
            JOptionPane.showMessageDialog(null, Bundle.getMessage("TypeNoSprogPromptFound"), Bundle.getMessage("SprogConsoleTitle"), 0);
        } else {
            if (this.sv.sprogType.sprogType > 23 && this.sv.sprogType.sprogType < 1000) {
                this.currentTextField.setToolTipText(Bundle.getMessage("CurrentLimitFieldTooltip2500"));
            }
            this.setTitle(String.valueOf(this.title()) + " - Connected to " + this.sv.toString());
            if (this.isBlueLineSupportPossible()) {
                if (log.isDebugEnabled()) {
                    log.debug("Enable blueline check box");
                }
                this.blueCheckBox.setEnabled(true);
                if (log.isDebugEnabled()) {
                    log.debug(Boolean.toString(this.blueCheckBox.isEnabled()));
                }
            }
            if (this.isFirmwareUnlockPossible()) {
                if (log.isDebugEnabled()) {
                    log.debug("Enable firmware check box");
                }
                this.unlockCheckBox.setEnabled(true);
                if (log.isDebugEnabled()) {
                    log.debug(Boolean.toString(this.unlockCheckBox.isEnabled()));
                }
            }
            this.ztcCheckBox.setEnabled(this.isZTCModePossible());
            if (this.isCurrentLimitPossible()) {
                this.state = State.CURRENTQUERYSENT;
                SprogMessage msg = new SprogMessage(1);
                msg.setOpCode(73);
                this.nextLine("cmd: \"" + msg + "\"\n", "");
                this.tc.sendSprogMessage(msg, this);
                this.startTimer();
            } else {
                this.currentLimit = (int)(996.0 * this.sv.sprogType.getCurrentMultiplier());
                this.currentTextField.setText(String.valueOf(996));
                this.state = State.MODEQUERYSENT;
                SprogMessage msg = new SprogMessage(1);
                msg.setOpCode(77);
                this.nextLine("cmd: \"" + msg + "\"\n", "");
                this.tc.sendSprogMessage(msg, this);
                this.startTimer();
            }
        }
    }

    @Override
    public synchronized void notifyMessage(SprogMessage l) {
        this.nextLine("cmd: \"" + l.toString(this._memo.getSprogTrafficController().isSIIBootMode()) + "\"\n", "");
    }

    @Override
    public synchronized void notifyReply(SprogReply l) {
        this.replyString = l.toString();
        this.nextLine("rep: \"" + this.replyString + "\"\n", "");
        switch (this.state) {
            case IDLE: {
                log.debug("reply in IDLE state: {}", (Object)this.replyString);
                break;
            }
            case CURRENTQUERYSENT: {
                int currentLimitFromHardware;
                log.debug("reply in CURRENTQUERYSENT state: {}", (Object)this.replyString);
                if (!this.replyString.contains("I=")) break;
                this.stopTimer();
                int valueLength = 4;
                if (this.sv.sprogType.sprogType >= 23) {
                    valueLength = 6;
                }
                this.tmpString = this.replyString.substring(this.replyString.indexOf("=") + 1, this.replyString.indexOf("=") + valueLength);
                log.debug("Current limit string: {}", (Object)this.tmpString);
                try {
                    currentLimitFromHardware = Integer.parseInt(this.tmpString);
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(null, Bundle.getMessage("ErrorFrameDialogLimit"), Bundle.getMessage("SprogConsoleTitle"), 0);
                    this.state = State.IDLE;
                    return;
                }
                this.currentLimit = (int)((double)currentLimitFromHardware * this.sv.sprogType.getCurrentMultiplier());
                log.debug("Current limit scale factor: {}", (Object)this.sv.sprogType.getCurrentMultiplier());
                log.debug("Current limit from hardware: {} scaled to: {}mA", (Object)currentLimitFromHardware, (Object)this.currentLimit);
                this.currentTextField.setText(String.valueOf(this.currentLimit));
                this.currentTextField.setEnabled(true);
                this.state = State.MODEQUERYSENT;
                SprogMessage msg = new SprogMessage(1);
                msg.setOpCode(77);
                this.nextLine("cmd: \"" + msg + "\"\n", "");
                this.tc.sendSprogMessage(msg, this);
                this.startTimer();
                break;
            }
            case MODEQUERYSENT: {
                log.debug("reply in MODEQUERYSENT state: {}", (Object)this.replyString);
                if (!this.replyString.contains("M=")) break;
                this.stopTimer();
                this.tmpString = this.replyString.substring(this.replyString.indexOf("=") + 2, this.replyString.indexOf("=") + 6);
                try {
                    this.modeWord = Integer.parseInt(this.tmpString, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(null, Bundle.getMessage("ErrorFrameDialogWord"), Bundle.getMessage("SprogConsoleTitle"), 0);
                    this.state = State.IDLE;
                    return;
                }
                this.state = State.IDLE;
                if ((this.modeWord & 0x200) != 0) {
                    this.speed14Button.setSelected(true);
                } else if ((this.modeWord & 0x400) != 0) {
                    this.speed28Button.setSelected(true);
                } else {
                    this.speed128Button.setSelected(true);
                }
                if ((this.modeWord & 0x20) != 0) {
                    this.ztcCheckBox.setSelected(true);
                }
                if ((this.modeWord & 0x40) == 0) break;
                this.blueCheckBox.setSelected(true);
                break;
            }
            case CURRENTSENT: {
                log.debug("reply in CURRENTSENT state: {}", (Object)this.replyString);
                this.modeWord = 2048;
                if (this.speed14Button.isSelected()) {
                    this.modeWord = this.modeWord & 0xFFFFF1FF | 0x200;
                } else if (this.speed28Button.isSelected()) {
                    this.modeWord = this.modeWord & 0xFFFFF1FF | 0x400;
                }
                if (this.ztcCheckBox.isSelected()) {
                    this.modeWord |= 0x20;
                }
                if (this.blueCheckBox.isSelected()) {
                    this.modeWord |= 0x40;
                }
                if (this.unlockCheckBox.isSelected()) {
                    this.modeWord |= 1;
                }
                this.state = State.MODESENT;
                SprogMessage msg = new SprogMessage("M " + this.modeWord);
                this.nextLine("cmd: \"" + msg.toString(this._memo.getSprogTrafficController().isSIIBootMode()) + "\"\n", "");
                this.tc.sendSprogMessage(msg, this);
                break;
            }
            case MODESENT: {
                log.debug("reply in MODESENT state: {}", (Object)this.replyString);
                this.state = State.WRITESENT;
                SprogMessage msg = new SprogMessage("W");
                this.nextLine("cmd: \"" + msg.toString(this._memo.getSprogTrafficController().isSIIBootMode()) + "\"\n", "");
                this.tc.sendSprogMessage(msg, this);
                break;
            }
            case WRITESENT: {
                log.debug("reply in WRITESENT state: {}", (Object)this.replyString);
                this.state = State.IDLE;
                break;
            }
            default: {
                log.warn("Unhandled state: {}", (Object)this.state);
            }
        }
    }

    protected synchronized void timeout() {
        JOptionPane.showMessageDialog(null, Bundle.getMessage("TypeTimeoutTalkingToSPROG"), Bundle.getMessage("Timeout"), 0);
        this.state = State.IDLE;
    }

    protected void startTimer() {
        this.restartTimer(this.TIMEOUT);
    }

    protected void stopTimer() {
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    protected void restartTimer(int delay) {
        if (this.timer == null) {
            this.timer = new Timer(delay, e -> this.timeout());
        }
        this.timer.stop();
        this.timer.setInitialDelay(delay);
        this.timer.setRepeats(false);
        this.timer.start();
    }

    static enum State {
        IDLE,
        CURRENTQUERYSENT,
        MODEQUERYSENT,
        CURRENTSENT,
        MODESENT,
        WRITESENT;

    }
}

