/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.sprog;

import jmri.NmraPacket;
import jmri.implementation.AbstractTurnout;
import jmri.jmrix.sprog.SprogMessage;
import jmri.jmrix.sprog.SprogSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SprogTurnout
extends AbstractTurnout {
    private SprogSystemConnectionMemo _memo = null;
    int _number;
    private static final Logger log = LoggerFactory.getLogger(SprogTurnout.class);

    public SprogTurnout(int number, SprogSystemConnectionMemo memo) {
        super(String.valueOf(memo.getSystemPrefix()) + "T" + number);
        this._number = number;
        this._memo = memo;
    }

    public int getNumber() {
        return this._number;
    }

    @Override
    protected void forwardCommandChangeToLayout(int newState) {
        if ((newState & 2) != 0) {
            if ((newState & 4) != 0) {
                log.error("Cannot command both CLOSED and THROWN {}", (Object)newState);
                return;
            }
            this.sendMessage(true ^ this.getInverted());
        } else {
            this.sendMessage(this.getInverted());
        }
    }

    @Override
    protected void turnoutPushbuttonLockout(boolean _pushButtonLockout) {
        if (log.isDebugEnabled()) {
            log.debug("Send command to {} Pushbutton {}T{}", new Object[]{_pushButtonLockout ? "Lock" : "Unlock", this._memo.getSystemPrefix(), this._number});
        }
    }

    protected void sendMessage(boolean closed) {
        byte[] bl = NmraPacket.accDecoderPkt(this._number, closed);
        if (log.isDebugEnabled()) {
            log.debug("packet: {} {} {}", new Object[]{Integer.toHexString(0xFF & bl[0]), Integer.toHexString(0xFF & bl[1]), Integer.toHexString(0xFF & bl[2])});
        }
        SprogMessage m = new SprogMessage(10);
        int i = 0;
        m.setElement(i++, 79);
        m.setElement(i++, 32);
        String s = Integer.toHexString(bl[0] & 0xFF).toUpperCase();
        if (s.length() == 1) {
            m.setElement(i++, 48);
            m.setElement(i++, s.charAt(0));
        } else {
            m.setElement(i++, s.charAt(0));
            m.setElement(i++, s.charAt(1));
        }
        m.setElement(i++, 32);
        s = Integer.toHexString(bl[1] & 0xFF).toUpperCase();
        if (s.length() == 1) {
            m.setElement(i++, 48);
            m.setElement(i++, s.charAt(0));
        } else {
            m.setElement(i++, s.charAt(0));
            m.setElement(i++, s.charAt(1));
        }
        m.setElement(i++, 32);
        s = Integer.toHexString(bl[2] & 0xFF).toUpperCase();
        if (s.length() == 1) {
            m.setElement(i++, 48);
            m.setElement(i++, s.charAt(0));
        } else {
            m.setElement(i++, s.charAt(0));
            m.setElement(i++, s.charAt(1));
        }
        this._memo.getSprogTrafficController().sendSprogMessage(m, null);
    }

    @Override
    public boolean canInvert() {
        return true;
    }
}

