/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.sprog;

import java.util.EnumSet;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.ThrottleListener;
import jmri.jmrix.AbstractThrottleManager;
import jmri.jmrix.sprog.SprogMessage;
import jmri.jmrix.sprog.SprogSystemConnectionMemo;
import jmri.jmrix.sprog.SprogThrottle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SprogThrottleManager
extends AbstractThrottleManager {
    boolean throttleInUse = false;
    private static final Logger log = LoggerFactory.getLogger(SprogThrottleManager.class);

    public SprogThrottleManager(SprogSystemConnectionMemo memo) {
        super(memo);
    }

    void release() {
        this.throttleInUse = false;
    }

    @Override
    public void requestThrottleSetup(LocoAddress a, boolean control) {
        if (!(a instanceof DccLocoAddress)) {
            log.error("{} is not a DccLocoAddress", (Object)a);
            this.failedThrottleRequest(a, "LocoAddress " + a + " is not a DccLocoAddress");
            return;
        }
        DccLocoAddress address = (DccLocoAddress)a;
        if (!this.throttleInUse) {
            this.throttleInUse = true;
            log.debug("new SprogThrottle for {}", (Object)address);
            String addr = address.getNumber() + (address.isLongAddress() ? " 0" : "");
            SprogMessage m = new SprogMessage(2 + addr.length());
            int i = 0;
            m.setElement(i++, 65);
            m.setElement(i++, 32);
            int j = 0;
            while (j < addr.length()) {
                m.setElement(i++, addr.charAt(j));
                ++j;
            }
            ((SprogSystemConnectionMemo)this.adapterMemo).getSprogTrafficController().sendSprogMessage(m, null);
            this.notifyThrottleKnown(new SprogThrottle((SprogSystemConnectionMemo)this.adapterMemo, address), address);
        } else {
            this.failedThrottleRequest(address, "Only one Throttle can be in use at anyone time with the Sprog.");
            log.warn("Single SPROG Throttle already in use");
        }
    }

    @Override
    public EnumSet<SpeedStepMode> supportedSpeedModes() {
        return EnumSet.of(SpeedStepMode.NMRA_DCC_128, SpeedStepMode.NMRA_DCC_28);
    }

    @Override
    public boolean canBeLongAddress(int address) {
        return address >= 0 && address <= 10239;
    }

    @Override
    public boolean canBeShortAddress(int address) {
        return address >= 1 && address <= 127;
    }

    @Override
    public boolean addressTypeUnique() {
        return false;
    }

    @Override
    public boolean disposeThrottle(DccThrottle t, ThrottleListener l) {
        if (super.disposeThrottle(t, l)) {
            this.throttleInUse = false;
            return true;
        }
        return false;
    }
}

