/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.sprog;

import jmri.DccLocoAddress;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.NmraPacket;
import jmri.PowerManager;
import jmri.SpeedStepMode;
import jmri.jmrix.AbstractThrottle;
import jmri.jmrix.sprog.SprogCommandStation;
import jmri.jmrix.sprog.SprogMessage;
import jmri.jmrix.sprog.SprogSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SprogThrottle
extends AbstractThrottle {
    SprogCommandStation station = null;
    DccLocoAddress address;
    private static final Logger log = LoggerFactory.getLogger(SprogThrottle.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SprogThrottle(SprogSystemConnectionMemo memo, DccLocoAddress address) {
        super(memo);
        this.station = memo.getCommandStation();
        SprogThrottle sprogThrottle = this;
        synchronized (sprogThrottle) {
            this.speedSetting = 0.0f;
        }
        this.address = address;
        this.isForward = true;
        this.speedStepMode = SpeedStepMode.NMRA_DCC_128;
    }

    @Override
    public LocoAddress getLocoAddress() {
        return this.address;
    }

    @Override
    protected void sendFunctionGroup1() {
        byte[] result = NmraPacket.function0Through4Packet(this.address.getNumber(), this.address.isLongAddress(), this.getF0(), this.getF1(), this.getF2(), this.getF3(), this.getF4());
        this.station.sendPacket(result, 1);
    }

    @Override
    protected void sendFunctionGroup2() {
        byte[] result = NmraPacket.function5Through8Packet(this.address.getNumber(), this.address.isLongAddress(), this.getF5(), this.getF6(), this.getF7(), this.getF8());
        this.station.sendPacket(result, 1);
    }

    @Override
    protected void sendFunctionGroup3() {
        byte[] result = NmraPacket.function9Through12Packet(this.address.getNumber(), this.address.isLongAddress(), this.getF9(), this.getF10(), this.getF11(), this.getF12());
        this.station.sendPacket(result, 1);
    }

    @Override
    protected void sendFunctionGroup4() {
        byte[] result = NmraPacket.function13Through20Packet(this.address.getNumber(), this.address.isLongAddress(), this.getF13(), this.getF14(), this.getF15(), this.getF16(), this.getF17(), this.getF18(), this.getF19(), this.getF20());
        this.station.sendPacket(result, 1);
    }

    @Override
    protected void sendFunctionGroup5() {
        byte[] result = NmraPacket.function21Through28Packet(this.address.getNumber(), this.address.isLongAddress(), this.getF21(), this.getF22(), this.getF23(), this.getF24(), this.getF25(), this.getF26(), this.getF27(), this.getF28());
        this.station.sendPacket(result, 1);
    }

    @Override
    public void setSpeedStepMode(SpeedStepMode Mode) {
        int mode = this.address.isLongAddress() ? 4096 : 0;
        try {
            mode |= InstanceManager.getDefault(PowerManager.class).getPower() == 2 ? 16 : 0;
        }
        catch (Exception e) {
            log.error("Exception from InstanceManager.getDefault(jmri.PowerManager.class): {}", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("Speed Step Mode Change to Mode: {} Current mode is: {}", (Object)Mode, (Object)this.speedStepMode);
        }
        if (Mode == SpeedStepMode.NMRA_DCC_14) {
            mode += 512;
        } else {
            if (Mode == SpeedStepMode.NMRA_DCC_27) {
                log.error("Requested Speed Step Mode 27 not supported Current mode is: {}", (Object)this.speedStepMode);
                return;
            }
            mode = Mode == SpeedStepMode.NMRA_DCC_28 ? (mode += 1024) : (mode += 2048);
        }
        SprogMessage m = new SprogMessage("M h" + Integer.toHexString(mode));
        ((SprogSystemConnectionMemo)this.adapterMemo).getSprogTrafficController().sendSprogMessage(m, null);
        if (Mode != SpeedStepMode.NMRA_DCC_27) {
            this.speedStepMode = Mode;
            this.firePropertyChange("SpeedSteps", (Object)this.speedStepMode, (Object)this.speedStepMode);
        }
    }

    @Override
    public synchronized void setSpeedSetting(float speed) {
        SpeedStepMode mode = this.getSpeedStepMode();
        if (mode == SpeedStepMode.NMRA_DCC_28) {
            float oldSpeed = this.speedSetting;
            this.speedSetting = speed;
            int value = Math.round(28.0f * speed);
            log.debug("Speed: {} value: {}", (Object)Float.valueOf(speed), (Object)value);
            if (value > 0) {
                value += 3;
            }
            if (value > 31) {
                value = 31;
            }
            if (value < 0) {
                value = 1;
            }
            String step = "" + value;
            SprogMessage m = new SprogMessage(1 + step.length());
            int i = 0;
            if (this.isForward) {
                m.setElement(i++, 62);
            } else {
                m.setElement(i++, 60);
            }
            int j = 0;
            while (j < step.length()) {
                m.setElement(i++, step.charAt(j));
                ++j;
            }
            ((SprogSystemConnectionMemo)this.adapterMemo).getSprogTrafficController().sendSprogMessage(m, null);
            this.firePropertyChange("SpeedSetting", Float.valueOf(oldSpeed), Float.valueOf(this.speedSetting));
        } else {
            float oldSpeed = this.speedSetting;
            this.speedSetting = speed;
            int value = Math.round(126.0f * speed);
            if (value > 0) {
                ++value;
            }
            if (value > 127) {
                value = 127;
            }
            if (value < 0) {
                value = 1;
            }
            String step = "" + value;
            SprogMessage m = new SprogMessage(1 + step.length());
            int i = 0;
            if (this.isForward) {
                m.setElement(i++, 62);
            } else {
                m.setElement(i++, 60);
            }
            int j = 0;
            while (j < step.length()) {
                m.setElement(i++, step.charAt(j));
                ++j;
            }
            ((SprogSystemConnectionMemo)this.adapterMemo).getSprogTrafficController().sendSprogMessage(m, null);
            this.firePropertyChange("SpeedSetting", Float.valueOf(oldSpeed), Float.valueOf(this.speedSetting));
        }
        this.record(speed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIsForward(boolean forward) {
        boolean old = this.isForward;
        this.isForward = forward;
        SprogThrottle sprogThrottle = this;
        synchronized (sprogThrottle) {
            this.setSpeedSetting(this.speedSetting);
        }
        this.firePropertyChange("IsForward", old, this.isForward);
    }

    @Override
    public void throttleDispose() {
        this.finishRecord();
    }
}

