/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.sprog;

import java.util.Arrays;
import jmri.DccLocoAddress;
import jmri.NmraPacket;
import jmri.SpeedStepMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SprogSlot {
    private boolean speedPacket = false;
    private SpeedStepMode speedMode = SpeedStepMode.NMRA_DCC_128;
    private byte[] payload = new byte[6];
    private int repeat;
    private int addr;
    private boolean isLong;
    private int spd;
    private boolean forward;
    private int status;
    private final int slot;
    private boolean opsPkt;
    private boolean f0to4Packet;
    private boolean f5to8Packet;
    private boolean f9to12Packet;
    private boolean f13to20Packet;
    private boolean f21to28Packet;
    private boolean repeatF0 = false;
    private boolean repeatF1 = false;
    private boolean repeatF2 = false;
    private boolean repeatF3 = false;
    private boolean repeatF4 = false;
    private boolean repeatF5 = false;
    private boolean repeatF6 = false;
    private boolean repeatF7 = false;
    private boolean repeatF8 = false;
    private boolean repeatF9 = false;
    private boolean repeatF10 = false;
    private boolean repeatF11 = false;
    private boolean repeatF12 = false;
    private boolean repeatF13 = false;
    private boolean repeatF14 = false;
    private boolean repeatF15 = false;
    private boolean repeatF16 = false;
    private boolean repeatF17 = false;
    private boolean repeatF18 = false;
    private boolean repeatF19 = false;
    private boolean repeatF20 = false;
    private boolean repeatF21 = false;
    private boolean repeatF22 = false;
    private boolean repeatF23 = false;
    private boolean repeatF24 = false;
    private boolean repeatF25 = false;
    private boolean repeatF26 = false;
    private boolean repeatF27 = false;
    private boolean repeatF28 = false;
    private long lastUpdateTime;
    private static final Logger log = LoggerFactory.getLogger(SprogSlot.class);

    public SprogSlot(int num) {
        this.payload[0] = 0;
        this.payload[1] = 0;
        this.payload[2] = 0;
        this.f0to4Packet = false;
        this.f5to8Packet = false;
        this.f9to12Packet = false;
        this.f13to20Packet = false;
        this.f21to28Packet = false;
        this.repeat = -1;
        this.addr = 0;
        this.isLong = false;
        this.spd = 0;
        this.forward = true;
        this.status = 0;
        this.slot = num;
        this.opsPkt = false;
    }

    public boolean isF0to4Packet() {
        return this.f0to4Packet;
    }

    public boolean isF5to8Packet() {
        return this.f5to8Packet;
    }

    public boolean isF9to12Packet() {
        return this.f9to12Packet;
    }

    public boolean isF13to20Packet() {
        return this.f13to20Packet;
    }

    public boolean isF21to28Packet() {
        return this.f21to28Packet;
    }

    public void set(int address, byte[] payload, int repeat) {
        this.addr = address;
        Arrays.copyOf(payload, payload.length);
        this.setRepeat(repeat);
        this.status = 1;
    }

    public void setAccessoryPacket(int address, boolean closed, int repeats) {
        this.payload = NmraPacket.accDecoderPkt(address, closed);
        this.addr = address + 10000;
        this.repeat = repeats;
        this.status = 1;
    }

    public boolean isSpeedPacket() {
        return this.speedPacket;
    }

    public void setSpeed(SpeedStepMode mode, int address, boolean isLongAddress, int speed, boolean forward) {
        this.addr = address;
        this.isLong = isLongAddress;
        this.spd = speed;
        this.speedPacket = true;
        this.speedMode = mode;
        this.f0to4Packet = false;
        this.f5to8Packet = false;
        this.f9to12Packet = false;
        this.f13to20Packet = false;
        this.f21to28Packet = false;
        this.forward = forward;
        this.payload = mode == SpeedStepMode.NMRA_DCC_28 ? NmraPacket.speedStep28Packet(true, this.addr, this.isLong, this.spd, forward) : NmraPacket.speedStep128Packet(this.addr, this.isLong, this.spd, forward);
        this.status = 1;
    }

    public void setOps(int address, boolean longAddr, int cv, int val) {
        this.payload = NmraPacket.opsCvWriteByte(address, longAddr, cv, val);
        this.repeat = 3;
        this.opsPkt = true;
        this.status = 1;
    }

    public void f5to8packet(int address, boolean isLongAddress, boolean f5, boolean f5Momentary, boolean f6, boolean f6Momentary, boolean f7, boolean f7Momentary, boolean f8, boolean f8Momentary) {
        this.f5to8Packet = true;
        this.addr = address;
        this.isLong = isLongAddress;
        if (this.repeatF5 && !f5 || this.repeatF6 && !f6 || this.repeatF7 && !f7 || this.repeatF8 && !f8) {
            this.repeat = 3;
        }
        this.repeatF5 = !f5Momentary && f5;
        this.repeatF6 = !f6Momentary && f6;
        this.repeatF7 = !f7Momentary && f7;
        this.repeatF8 = !f8Momentary && f8;
        this.payload = NmraPacket.function5Through8Packet(address, isLongAddress, f5, f6, f7, f8);
        this.status = 1;
    }

    public void f9to12packet(int address, boolean isLongAddress, boolean f9, boolean f9Momentary, boolean f10, boolean f10Momentary, boolean f11, boolean f11Momentary, boolean f12, boolean f12Momentary) {
        this.f9to12Packet = true;
        this.addr = address;
        this.isLong = isLongAddress;
        if (this.repeatF9 && !f9 || this.repeatF10 && !f10 || this.repeatF11 && !f11 || this.repeatF12 && !f12) {
            this.repeat = 3;
        }
        this.repeatF9 = !f9Momentary && f9;
        this.repeatF10 = !f10Momentary && f10;
        this.repeatF11 = !f11Momentary && f11;
        this.repeatF12 = !f12Momentary && f12;
        this.payload = NmraPacket.function9Through12Packet(address, isLongAddress, f9, f10, f11, f12);
        this.status = 1;
    }

    public void f13to20packet(int address, boolean isLongAddress, boolean f13, boolean f13Momentary, boolean f14, boolean f14Momentary, boolean f15, boolean f15Momentary, boolean f16, boolean f16Momentary, boolean f17, boolean f17Momentary, boolean f18, boolean f18Momentary, boolean f19, boolean f19Momentary, boolean f20, boolean f20Momentary) {
        this.f13to20Packet = true;
        this.addr = address;
        this.isLong = isLongAddress;
        if (this.repeatF13 && !f13 || this.repeatF14 && !f14 || this.repeatF15 && !f15 || this.repeatF16 && !f16 || this.repeatF17 && !f17 || this.repeatF18 && !f18 || this.repeatF19 && !f19 || this.repeatF20 && !f20) {
            this.repeat = 3;
        }
        this.repeatF13 = !f13Momentary && f13;
        this.repeatF14 = !f14Momentary && f14;
        this.repeatF15 = !f15Momentary && f15;
        this.repeatF16 = !f16Momentary && f16;
        this.repeatF17 = !f17Momentary && f17;
        this.repeatF18 = !f18Momentary && f18;
        this.repeatF19 = !f19Momentary && f19;
        this.repeatF20 = !f20Momentary && f20;
        this.payload = NmraPacket.function13Through20Packet(address, isLongAddress, f13, f14, f15, f16, f17, f18, f19, f20);
        this.status = 1;
    }

    public void f21to28packet(int address, boolean isLongAddress, boolean f21, boolean f21Momentary, boolean f22, boolean f22Momentary, boolean f23, boolean f23Momentary, boolean f24, boolean f24Momentary, boolean f25, boolean f25Momentary, boolean f26, boolean f26Momentary, boolean f27, boolean f27Momentary, boolean f28, boolean f28Momentary) {
        this.f21to28Packet = true;
        this.addr = address;
        this.isLong = isLongAddress;
        if (this.repeatF21 && !f21 || this.repeatF22 && !f22 || this.repeatF23 && !f23 || this.repeatF24 && !f24 || this.repeatF25 && !f25 || this.repeatF26 && !f26 || this.repeatF27 && !f27 || this.repeatF28 && !f28) {
            this.repeat = 3;
        }
        this.repeatF21 = !f21Momentary && f21;
        this.repeatF22 = !f22Momentary && f22;
        this.repeatF23 = !f23Momentary && f23;
        this.repeatF24 = !f24Momentary && f24;
        this.repeatF25 = !f25Momentary && f25;
        this.repeatF26 = !f26Momentary && f26;
        this.repeatF27 = !f27Momentary && f27;
        this.repeatF28 = !f28Momentary && f28;
        this.payload = NmraPacket.function21Through28Packet(address, isLongAddress, f21, f22, f23, f24, f25, f26, f27, f28);
        this.status = 1;
    }

    public void f0to4packet(int address, boolean isLongAddress, boolean f0, boolean f0Momentary, boolean f1, boolean f1Momentary, boolean f2, boolean f2Momentary, boolean f3, boolean f3Momentary, boolean f4, boolean f4Momentary) {
        this.f0to4Packet = true;
        this.addr = address;
        this.isLong = isLongAddress;
        if (this.repeatF0 && !f0 || this.repeatF1 && !f1 || this.repeatF2 && !f2 || this.repeatF3 && !f3 || this.repeatF4 && !f4) {
            this.repeat = 3;
        }
        this.repeatF0 = !f0Momentary && f0;
        this.repeatF1 = !f1Momentary && f1;
        this.repeatF2 = !f2Momentary && f2;
        this.repeatF3 = !f3Momentary && f3;
        this.repeatF4 = !f4Momentary && f4;
        this.payload = NmraPacket.function0Through4Packet(address, isLongAddress, f0, f1, f2, f3, f4);
        this.status = 1;
    }

    public boolean isFinished() {
        if (this.isF0to4Packet() && (this.repeatF0 || this.repeatF1 || this.repeatF2 || this.repeatF3 || this.repeatF4)) {
            return false;
        }
        if (this.isF5to8Packet() && (this.repeatF5 || this.repeatF6 || this.repeatF7 || this.repeatF8)) {
            return false;
        }
        if (this.isF9to12Packet() && (this.repeatF9 || this.repeatF10 || this.repeatF11 || this.repeatF12)) {
            return false;
        }
        if (this.isF13to20Packet() && (this.repeatF13 || this.repeatF14 || this.repeatF15 || this.repeatF16 || this.repeatF17 || this.repeatF18 || this.repeatF19 || this.repeatF20)) {
            return false;
        }
        if (this.isF21to28Packet() && (this.repeatF21 || this.repeatF22 || this.repeatF23 || this.repeatF24 || this.repeatF25 || this.repeatF26 || this.repeatF27 || this.repeatF28)) {
            return false;
        }
        if (this.isSpeedPacket() && this.status == 1) {
            return false;
        }
        if (this.repeat > 0 && this.status == 1) {
            return false;
        }
        this.clear();
        return true;
    }

    public void eStop() {
        this.setSpeed(this.speedMode, this.addr, this.isLong, 1, this.forward);
    }

    public void clear() {
        this.status = 0;
        this.addr = 0;
        this.spd = 0;
        this.speedPacket = false;
        this.f0to4Packet = false;
        this.f5to8Packet = false;
        this.f9to12Packet = false;
        this.f13to20Packet = false;
        this.f21to28Packet = false;
        if (this.payload != null) {
            this.payload[0] = 0;
            this.payload[1] = 0;
            this.payload[2] = 0;
        }
        this.opsPkt = false;
    }

    public boolean isLongAddress() {
        return this.isLong;
    }

    public boolean isFree() {
        return this.status == 0;
    }

    public int slotStatus() {
        return this.status;
    }

    public int getRepeat() {
        return this.repeat;
    }

    public void setRepeat(int r) {
        this.repeat = r;
    }

    private int doRepeat() {
        if (this.repeat > 0) {
            log.debug("Slot {} repeats", (Object)this.slot);
            --this.repeat;
            if (this.repeat == 0) {
                log.debug("Clear slot {} due to repeats exhausted", (Object)this.slot);
                this.clear();
            }
        }
        return this.repeat;
    }

    public int speed() {
        return this.spd;
    }

    public int locoAddr() {
        return this.addr;
    }

    public int getAddr() {
        if (!this.opsPkt) {
            return this.addr;
        }
        return this.addressFromPacket();
    }

    public void setAddr(int a) {
        this.addr = a;
    }

    public boolean getIsLong() {
        if (!this.opsPkt) {
            return this.isLong;
        }
        return (this.payload[0] & 0xC0) >= 192;
    }

    public void setIsLong(boolean a) {
        this.isLong = a;
    }

    public boolean isForward() {
        return this.forward;
    }

    public boolean isOpsPkt() {
        return this.opsPkt;
    }

    public boolean isActiveAddressMatch(DccLocoAddress address) {
        return this.status == 1 && this.getAddr() == address.getNumber() && this.getIsLong() == address.isLongAddress();
    }

    public byte[] getPayload() {
        byte[] p = this.payload != null ? Arrays.copyOf(this.payload, this.getPayloadLength()) : new byte[]{};
        this.doRepeat();
        return p;
    }

    public int getSlotNumber() {
        return this.slot;
    }

    private int getPayloadLength() {
        return this.payload.length;
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    private int addressFromPacket() {
        if (this.isFree()) {
            return -1;
        }
        if ((this.payload[0] & 0xC0) == 192) {
            return (this.payload[0] & 0x3F) << 8 | this.payload[1] & 0xFF;
        }
        return this.payload[0];
    }
}

