/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.sprog;

import jmri.jmrix.AbstractMRReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SprogReply
extends AbstractMRReply {
    public static final int maxSize = 515;
    private boolean _isBoot = false;
    protected int _id = -1;
    private static final Logger log = LoggerFactory.getLogger(SprogReply.class);

    public SprogReply() {
    }

    public void setId(int id) {
        this._id = id;
    }

    public int getId() {
        return this._id;
    }

    @Override
    protected int skipPrefix(int index) {
        return index;
    }

    public SprogReply(SprogReply m) {
        this();
        if (m == null) {
            log.error("copy ctor of null message");
            return;
        }
        this._nDataChars = m._nDataChars;
        this._isBoot = m._isBoot;
        if (m.isUnsolicited()) {
        }
        int i = 0;
        while (i < this._nDataChars) {
            this._dataChars[i] = m._dataChars[i];
            ++i;
        }
        this._id = m._id;
    }

    public SprogReply(String replyString, boolean isBoot) {
        this(replyString);
        this._isBoot = isBoot;
    }

    public SprogReply(String replyString) {
        super(replyString);
    }

    public boolean isOverload() {
        return this.toString().contains("!O");
    }

    public boolean isError() {
        return this.toString().contains("!E");
    }

    public boolean strip() {
        char[] tmp = new char[this._nDataChars];
        int j = 0;
        this._isBoot = true;
        if (this._dataChars[0] != 15) {
            return false;
        }
        if (this._dataChars[1] != 15) {
            return false;
        }
        if (this._dataChars[this._nDataChars - 1] != 4) {
            return false;
        }
        int i = 2;
        while (i < this._nDataChars - 1) {
            if (this._dataChars[i] == 5) {
                ++i;
            }
            tmp[j++] = (char)this._dataChars[i];
            ++i;
        }
        i = 0;
        while (i < j) {
            this._dataChars[i] = tmp[i];
            ++i;
        }
        this._nDataChars = j;
        return true;
    }

    public boolean getChecksum() {
        int checksum = 0;
        int i = 0;
        while (i < this._nDataChars) {
            checksum += this._dataChars[i] & 0xFF;
            ++i;
        }
        --this._nDataChars;
        return (checksum & 0xFF) == 0;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this._isBoot || this._dataChars[0] == 15) {
            int i = 0;
            while (i < this._nDataChars) {
                buf.append("<");
                buf.append(this._dataChars[i]);
                buf.append(">");
                ++i;
            }
        } else {
            int i = 0;
            while (i < this._nDataChars) {
                buf.append((char)this._dataChars[i]);
                ++i;
            }
        }
        return buf.toString();
    }

    @Override
    public int value() {
        int index = 0;
        index = this.skipWhiteSpace(index);
        index = this.skipEqual(index);
        index = this.skipWhiteSpace(index);
        String s1 = "" + (char)this.getElement(index);
        String s2 = "" + (char)this.getElement(index + 1);
        int val = -1;
        try {
            int sum = Integer.valueOf(s2, 16);
            val = sum += 16 * Integer.valueOf(s1, 16);
        }
        catch (NumberFormatException numberFormatException) {
            log.error("Unable to get number from reply: \"{}{}\" index: {} message: \"{}\"", new Object[]{s1, s2, index, this.toString()});
        }
        return val;
    }

    @Override
    public int match(String s) {
        String rep = new String(this._dataChars, 0, this._nDataChars);
        return rep.indexOf(s);
    }

    private int skipEqual(int index) {
        int len = "= h".length();
        if (this.getNumDataElements() >= index + len - 1 && '=' == (char)this.getElement(index) && ' ' == (char)this.getElement(index + 1) && 'h' == (char)this.getElement(index + 2)) {
            index += len;
        }
        return index;
    }

    public boolean endNormalReply() {
        int num = this.getNumDataElements();
        if (num >= 3) {
            int ptr = num - 1;
            if (this.getElement(ptr) != 32) {
                return false;
            }
            if (this.getElement(ptr - 1) != 62) {
                return false;
            }
            if (this.getElement(ptr - 2) != 80 && this.getElement(ptr - 2) != 82) {
                return false;
            }
            if (num >= 5) {
                int i = 0;
                while (i < num - 1) {
                    if (this.getElement(i) == 33) {
                        super.setUnsolicited();
                    }
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    public boolean endBootReply() {
        int num = this.getNumDataElements();
        if (num >= 2) {
            int ptr = num - 1;
            if ((this.getElement(ptr) & 0xFF) != 4) {
                return false;
            }
            return (this.getElement(ptr - 1) & 0xFF) != 5;
        }
        return false;
    }
}

