/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.sprog;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jmri.ProgListener;
import jmri.ProgrammerException;
import jmri.ProgrammingMode;
import jmri.jmrix.AbstractProgrammer;
import jmri.jmrix.sprog.SprogListener;
import jmri.jmrix.sprog.SprogMessage;
import jmri.jmrix.sprog.SprogReply;
import jmri.jmrix.sprog.SprogSystemConnectionMemo;
import jmri.jmrix.sprog.SprogTrafficController;
import jmri.jmrix.sprog.update.SprogVersion;
import jmri.jmrix.sprog.update.SprogVersionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SprogProgrammer
extends AbstractProgrammer
implements SprogListener,
SprogVersionListener {
    private SprogSystemConnectionMemo _memo = null;
    private SprogVersion _sv = null;
    int progState = 0;
    static final int NOTPROGRAMMING = 0;
    static final int COMMANDSENT = 2;
    int _val;
    String _cv;
    int _startVal;
    ProgListener _progListener;
    private ProgListener _usingProgrammer = null;
    SprogTrafficController _controller = null;
    private static final Logger log = LoggerFactory.getLogger(SprogProgrammer.class);

    public SprogProgrammer(SprogSystemConnectionMemo memo) {
        this._memo = memo;
    }

    @Override
    @Nonnull
    public List<ProgrammingMode> getSupportedModes() {
        ArrayList<ProgrammingMode> ret = new ArrayList<ProgrammingMode>();
        ret.add(ProgrammingMode.DIRECTBITMODE);
        ret.add(ProgrammingMode.PAGEMODE);
        return ret;
    }

    @Override
    public boolean getCanRead() {
        if (this.getMode().equals(ProgrammingMode.PAGEMODE)) {
            return true;
        }
        if (this.getMode().equals(ProgrammingMode.DIRECTBITMODE)) {
            return true;
        }
        log.error("Unknown internal mode {} returned true from getCanRead()", (Object)this.getMode());
        return true;
    }

    @Override
    public synchronized void writeCV(String CVname, int val, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        log.debug("writeCV {} mode {} listens {}", new Object[]{CV, this.getMode(), p});
        this.useProgrammer(p);
        this._val = val;
        this.startProgramming(this._val, CV, 0);
    }

    @Override
    public synchronized void confirmCV(String CV, int val, ProgListener p) throws ProgrammerException {
        this.readCV(CV, p);
    }

    @Override
    public synchronized void readCV(String CVname, ProgListener p) throws ProgrammerException {
        this.readCVWithDefault(CVname, p, 0);
    }

    @Override
    public void readCV(String CVname, ProgListener p, int startVal) throws ProgrammerException {
        this._startVal = startVal;
        if (this._sv != null) {
            if (!this._sv.supportsCVHints()) {
                log.debug("Hardware does not support hints");
                this._startVal = 0;
            }
            this.readCVWithDefault(CVname, p, this._startVal);
        } else {
            log.debug("SPROG version is unknown - trying to get it");
            this._cv = CVname;
            this._progListener = p;
            this._memo.getSprogVersionQuery().requestVersion(this);
        }
    }

    public synchronized void readCVWithDefault(String CVname, ProgListener p, int startVal) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        log.debug("readCV {} mode {} hint {} listens {}", new Object[]{CV, this.getMode(), startVal, p});
        this.useProgrammer(p);
        this._val = -1;
        this.startProgramming(this._val, CV, startVal);
    }

    private void startProgramming(int val, int CV, int startVal) {
        this.progState = 2;
        try {
            this.startLongTimer();
            this.controller().sendSprogMessage(this.progTaskStart(this.getMode(), val, CV, startVal), this);
        }
        catch (Exception e) {
            log.error("program operation failed, exception {}", (Throwable)e);
            this.progState = 0;
        }
    }

    protected void useProgrammer(ProgListener p) throws ProgrammerException {
        if (this._usingProgrammer != null && this._usingProgrammer != p) {
            if (log.isInfoEnabled()) {
                log.info("programmer already in use by {}", (Object)this._usingProgrammer);
            }
            throw new ProgrammerException("programmer in use");
        }
        this._usingProgrammer = p;
    }

    protected SprogMessage progTaskStart(ProgrammingMode mode, int val, int cvnum, int startVal) {
        if (val < 0) {
            if (startVal == 0) {
                return SprogMessage.getReadCV(cvnum, mode);
            }
            return SprogMessage.getReadCV(cvnum, mode, startVal);
        }
        return SprogMessage.getWriteCV(cvnum, val, mode);
    }

    @Override
    public void notifyMessage(SprogMessage m) {
    }

    @Override
    public synchronized void notifyReply(SprogReply reply) {
        if (this.progState == 0) {
            log.debug("reply in NOTPROGRAMMING state [{}]", (Object)reply);
            return;
        }
        if (this.progState == 2) {
            log.debug("reply in COMMANDSENT state [{}]", (Object)reply);
            this.progState = 0;
            if (reply.match("No Ack") >= 0) {
                log.debug("handle No Ack reply {}", (Object)reply);
                this.progState = 0;
                this.notifyProgListenerEnd(-1, 2);
            } else if (reply.match("!O") >= 0) {
                log.debug("handle !O reply {}", (Object)reply);
                this.progState = 0;
                this.notifyProgListenerEnd(-1, 256);
            } else {
                if (this._val == -1) {
                    this._val = reply.value();
                }
                this.progState = 0;
                this.stopTimer();
                this.notifyProgListenerEnd(this._val, 0);
            }
            this.controller().getAdapterMemo().getPowerManager().notePowerState(4);
        } else {
            log.debug("reply in un-decoded state");
        }
    }

    @Override
    public synchronized void notifyVersion(SprogVersion v) throws ProgrammerException {
        this._sv = v;
        this._memo.setSprogVersion(v);
        log.debug("Found: {}", (Object)v.toString());
        if (!this._sv.supportsCVHints()) {
            log.debug("Hardware does not support hints");
            this._startVal = 0;
        }
        this.readCVWithDefault(this._cv, this._progListener, this._startVal);
    }

    @Override
    protected synchronized void timeout() {
        if (this.progState != 0) {
            log.debug("Timeout in a programming state");
            this.progState = 0;
            this.notifyProgListenerEnd(this._val, 128);
        } else {
            log.debug("timeout in NOTPROGRAMMING state");
        }
    }

    protected void notifyProgListenerEnd(int value, int status) {
        log.debug("notifyProgListenerEnd value {} status {}", (Object)value, (Object)status);
        ProgListener temp = this._usingProgrammer;
        this._usingProgrammer = null;
        this.notifyProgListenerEnd(temp, value, status);
    }

    protected SprogTrafficController controller() {
        if (this._controller == null) {
            this._controller = this._memo.getSprogTrafficController();
        }
        return this._controller;
    }
}

