/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.sprog;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jmri.ProgrammingMode;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.sprog.SprogConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SprogMessage
extends AbstractMRMessage {
    public static final int STX = 15;
    public static final int DLE = 5;
    public static final int ETX = 4;
    public static final int CR = 13;
    public static final int LF = 10;
    public static final int RD_VER = 0;
    public static final int WT_FLASH = 2;
    public static final int ER_FLASH = 3;
    public static final int WT_EEDATA = 5;
    public static final int MAXSIZE = 515;
    private static int msgId = 0;
    protected int _id = -1;
    private static final Logger log = LoggerFactory.getLogger(SprogMessage.class);

    protected synchronized int newMsgId() {
        msgId = (msgId + 1) % 65536;
        return msgId;
    }

    public int getId() {
        return this._id;
    }

    public SprogMessage(int i) {
        if (i < 1) {
            log.error("invalid length in call to ctor");
        }
        this._nDataChars = i;
        this._dataChars = new int[i];
        this._id = this.newMsgId();
    }

    public SprogMessage(byte[] packet) {
        this(1 + packet.length * 3);
        int i = 0;
        this.setElement(i++, 79);
        int j = 0;
        while (j < packet.length) {
            this.setElement(i++, 32);
            String s = Integer.toHexString(packet[j] & 0xFF).toUpperCase();
            if (s.length() == 1) {
                this.setElement(i++, 48);
                this.setElement(i++, s.charAt(0));
            } else {
                this.setElement(i++, s.charAt(0));
                this.setElement(i++, s.charAt(1));
            }
            ++j;
        }
        this._id = this.newMsgId();
    }

    public SprogMessage(String s) {
        this._nDataChars = s.length();
        this._dataChars = new int[this._nDataChars];
        int i = 0;
        while (i < this._nDataChars) {
            this._dataChars[i] = s.charAt(i);
            ++i;
        }
        this._id = this.newMsgId();
    }

    public SprogMessage(SprogMessage m) {
        if (m == null) {
            log.error("copy ctor of null message");
            return;
        }
        this._nDataChars = m._nDataChars;
        this._dataChars = new int[this._nDataChars];
        int i = 0;
        while (i < this._nDataChars) {
            this._dataChars[i] = m._dataChars[i];
            ++i;
        }
        this._id = this.newMsgId();
    }

    @Override
    public void setElement(int n, int v) {
        this._dataChars[n] = v;
    }

    private void setLength(int i) {
        this._dataChars[1] = i;
    }

    private void setAddress(int i) {
        this._dataChars[2] = i & 0xFF;
        this._dataChars[3] = i >> 8 & 0xFF;
        this._dataChars[4] = i >> 16;
    }

    private void setData(int[] d) {
        int i = 0;
        while (i < d.length) {
            this._dataChars[5 + i] = d[i];
            ++i;
        }
    }

    private void setChecksum() {
        int checksum = 0;
        int i = 0;
        while (i < this._nDataChars - 1) {
            checksum += this._dataChars[i];
            ++i;
        }
        if ((checksum &= 0xFF) > 0) {
            checksum = 256 - checksum;
        }
        this._dataChars[this._nDataChars - 1] = checksum;
    }

    private SprogMessage frame() {
        int j = 2;
        SprogMessage f = new SprogMessage(515);
        f.setElement(0, 15);
        f.setElement(1, 15);
        int i = 0;
        while (i < this._nDataChars) {
            if (this._dataChars[i] == 15 || this._dataChars[i] == 4 || this._dataChars[i] == 5) {
                f.setElement(j++, 5);
            }
            f.setElement(j++, this._dataChars[i]);
            ++i;
        }
        f.setElement(j++, 4);
        f._nDataChars = j;
        return f;
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean isSIIBootMode) {
        StringBuffer buf = new StringBuffer();
        if (!isSIIBootMode) {
            int i = 0;
            while (i < this._nDataChars) {
                buf.append((char)this._dataChars[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this._nDataChars) {
                buf.append("<");
                buf.append(this._dataChars[i]);
                buf.append(">");
                ++i;
            }
        }
        return buf.toString();
    }

    public byte[] getFormattedMessage(SprogConstants.SprogState sprogState) {
        int len = this.getNumDataElements();
        int cr = 0;
        if (sprogState != SprogConstants.SprogState.SIIBOOTMODE) {
            cr = 1;
        }
        byte[] msg = new byte[len + cr];
        int i = 0;
        while (i < len) {
            msg[i] = sprogState != SprogConstants.SprogState.SIIBOOTMODE ? (byte)(this.getElement(i) & 0x7F) : (byte)this.getElement(i);
            ++i;
        }
        if (sprogState != SprogConstants.SprogState.SIIBOOTMODE) {
            msg[len] = 13;
        }
        return msg;
    }

    public boolean isKillMain() {
        return this.getOpCode() == 45;
    }

    public boolean isEnableMain() {
        return this.getOpCode() == 43;
    }

    public static SprogMessage getEnableMain() {
        SprogMessage m = new SprogMessage(1);
        m.setOpCode(43);
        return m;
    }

    public static SprogMessage getKillMain() {
        SprogMessage m = new SprogMessage(1);
        m.setOpCode(45);
        return m;
    }

    public static SprogMessage getStatus() {
        SprogMessage m = new SprogMessage(1);
        m.setOpCode(83);
        return m;
    }

    public static SprogMessage getReadCV(int cv, ProgrammingMode mode) {
        SprogMessage m = new SprogMessage(6);
        if (mode == ProgrammingMode.PAGEMODE) {
            m.setOpCode(86);
        } else {
            m.setOpCode(67);
        }
        SprogMessage.addSpace(m, 1);
        SprogMessage.addIntAsFour(cv, m, 2);
        return m;
    }

    public static SprogMessage getReadCV(int cv, ProgrammingMode mode, int startVal) {
        SprogMessage m = new SprogMessage(10);
        if (mode == ProgrammingMode.PAGEMODE) {
            m.setOpCode(85);
        } else {
            m.setOpCode(68);
        }
        SprogMessage.addSpace(m, 1);
        SprogMessage.addIntAsFour(cv, m, 2);
        SprogMessage.addSpace(m, 6);
        SprogMessage.addIntAsThree(startVal, m, 7);
        return m;
    }

    public static SprogMessage getWriteCV(int cv, int val, ProgrammingMode mode) {
        SprogMessage m = new SprogMessage(10);
        if (mode == ProgrammingMode.PAGEMODE) {
            m.setOpCode(86);
        } else {
            m.setOpCode(67);
        }
        SprogMessage.addSpace(m, 1);
        SprogMessage.addIntAsFour(cv, m, 2);
        SprogMessage.addSpace(m, 6);
        SprogMessage.addIntAsThree(val, m, 7);
        return m;
    }

    public static SprogMessage getReadRegister(int reg) {
        SprogMessage m = new SprogMessage(1);
        m.setOpCode(32);
        return m;
    }

    public static SprogMessage getWriteRegister(int reg, int val) {
        SprogMessage m = new SprogMessage(1);
        m.setOpCode(32);
        return m;
    }

    public static SprogMessage getPacketMessage(byte[] bytes) {
        SprogMessage m = new SprogMessage(1 + 3 * bytes.length);
        int i = 0;
        m.setElement(i++, 79);
        int j = 0;
        while (j < bytes.length) {
            m.setElement(i++, 32);
            m.addIntAsTwoHex(bytes[j] & 0xFF, i);
            i += 2;
            ++j;
        }
        return m;
    }

    public static SprogMessage getReadBootVersion() {
        SprogMessage m = new SprogMessage(3);
        m.setOpCode(0);
        m.setLength(2);
        m.setChecksum();
        return m.frame();
    }

    public static SprogMessage getWriteFlash(int addr, int[] data, int blockLen) {
        int offset;
        int l = data.length;
        if (l % blockLen != 0) {
            l += blockLen - l % blockLen;
        }
        int[] padded = new int[l];
        int i = 0;
        while (i < l) {
            padded[i] = 255;
            ++i;
        }
        if (blockLen == 16) {
            offset = addr & 0xF;
            addr &= 0xFFFFFFF0;
        } else {
            offset = addr & 7;
            addr &= 0xFFFFFFF8;
        }
        i = 0;
        while (i < data.length) {
            padded[i + offset] = data[i];
            ++i;
        }
        SprogMessage m = new SprogMessage(6 + l);
        m.setOpCode(2);
        m.setLength(l / blockLen);
        m.setAddress(addr);
        m.setData(padded);
        m.setChecksum();
        return m.frame();
    }

    public static SprogMessage getEraseFlash(int addr, int rows) {
        SprogMessage m = new SprogMessage(6);
        m.setOpCode(3);
        m.setLength(rows);
        m.setAddress(addr);
        m.setChecksum();
        return m.frame();
    }

    public static SprogMessage getWriteEE(int addr, int[] data) {
        SprogMessage m = new SprogMessage(6 + data.length);
        m.setOpCode(5);
        m.setLength(data.length);
        m.setAddress(addr & 0xFF);
        m.setData(data);
        m.setChecksum();
        return m.frame();
    }

    public static SprogMessage getReset() {
        SprogMessage m = new SprogMessage(3);
        m.setOpCode(0);
        m.setLength(0);
        m.setChecksum();
        return m.frame();
    }

    private static String addSpace(SprogMessage m, int offset) {
        String s = " ";
        m.setElement(offset, 32);
        return s;
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="was previously marked with @SuppressWarnings, reason unknown")
    private static String addIntAsTwo(int val, SprogMessage m, int offset) {
        String s = "" + val;
        if (s.length() != 2) {
            s = "0" + s;
        }
        m.setElement(offset, s.charAt(0));
        m.setElement(offset + 1, s.charAt(1));
        return s;
    }

    private static String addIntAsThree(int val, SprogMessage m, int offset) {
        String s = "" + val;
        if (s.length() != 3) {
            s = "0" + s;
        }
        if (s.length() != 3) {
            s = "0" + s;
        }
        m.setElement(offset, s.charAt(0));
        m.setElement(offset + 1, s.charAt(1));
        m.setElement(offset + 2, s.charAt(2));
        return s;
    }

    private static String addIntAsFour(int val, SprogMessage m, int offset) {
        String s = "" + val;
        if (s.length() != 4) {
            s = "0" + s;
        }
        if (s.length() != 4) {
            s = "0" + s;
        }
        if (s.length() != 4) {
            s = "0" + s;
        }
        m.setElement(offset, s.charAt(0));
        m.setElement(offset + 1, s.charAt(1));
        m.setElement(offset + 2, s.charAt(2));
        m.setElement(offset + 3, s.charAt(3));
        return s;
    }
}

