/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.sprog;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Vector;
import javax.swing.JOptionPane;
import jmri.CommandStation;
import jmri.DccLocoAddress;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NmraPacket;
import jmri.PowerManager;
import jmri.SpeedStepMode;
import jmri.jmrix.sprog.Bundle;
import jmri.jmrix.sprog.SprogConstants;
import jmri.jmrix.sprog.SprogListener;
import jmri.jmrix.sprog.SprogMessage;
import jmri.jmrix.sprog.SprogReply;
import jmri.jmrix.sprog.SprogSlot;
import jmri.jmrix.sprog.SprogSlotListener;
import jmri.jmrix.sprog.SprogSystemConnectionMemo;
import jmri.jmrix.sprog.SprogTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SprogCommandStation
implements CommandStation,
SprogListener,
Runnable,
PropertyChangeListener {
    protected int currentSlot = 0;
    protected int currentSprogAddress = -1;
    protected LinkedList<SprogSlot> slots;
    protected int numSlots = 8;
    protected Queue<SprogSlot> sendNow;
    private SprogTrafficController tc = null;
    final Object lock = new Object();
    private boolean waitingForReply = false;
    private boolean replyAvailable = false;
    private boolean sendSprogAddress = false;
    private long time;
    private long timeNow;
    private long packetDelay;
    private int lastId;
    PowerManager powerMgr = null;
    int powerState = 4;
    boolean powerChanged = false;
    private final Vector<SprogSlotListener> slotListeners = new Vector();
    SprogSystemConnectionMemo adaptermemo;
    private static final Logger log = LoggerFactory.getLogger(SprogCommandStation.class);

    public SprogCommandStation(SprogTrafficController controller) {
        this.sendNow = new LinkedList<SprogSlot>();
        this.slots = new LinkedList();
        this.numSlots = controller.getAdapterMemo().getNumSlots();
        int i = 0;
        while (i < this.numSlots) {
            this.slots.add(new SprogSlot(i));
            ++i;
        }
        this.tc = controller;
        this.tc.addSprogListener(this);
    }

    @Override
    public boolean sendPacket(byte[] packet, int repeats) {
        if (packet.length <= 1) {
            log.error("Invalid DCC packet length: {}", (Object)packet.length);
        }
        if (packet.length >= 7) {
            log.error("Maximum 6-byte packets accepted: {}", (Object)packet.length);
        }
        SprogMessage m = new SprogMessage(packet);
        this.sendMessage(m);
        return true;
    }

    protected void sendMessage(SprogMessage m) {
        log.debug("Sending message [{}] id {}", (Object)m.toString(this.tc.isSIIBootMode()), (Object)m.getId());
        this.lastId = m.getId();
        this.tc.sendSprogMessage(m, this);
    }

    public SprogSlot slot(int i) {
        return this.slots.get(i);
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="was previously marked with @SuppressWarnings, reason unknown")
    private void clearAllSlots() {
        this.slots.stream().forEach(s -> s.clear());
    }

    protected SprogSlot findFree() {
        for (SprogSlot s : this.slots) {
            if (!s.isFree()) continue;
            if (log.isDebugEnabled()) {
                log.debug("Found free slot {}", (Object)s.getSlotNumber());
            }
            return s;
        }
        return null;
    }

    private SprogSlot findAddress(DccLocoAddress address) {
        for (SprogSlot s : this.slots) {
            if (!s.isActiveAddressMatch(address)) continue;
            return s;
        }
        return null;
    }

    private SprogSlot findAddressSpeedPacket(DccLocoAddress address) {
        int lastSprogAddress = this.currentSprogAddress;
        while (this.currentSprogAddress <= 0 || address.getNumber() == this.currentSprogAddress || this.findAddress(new DccLocoAddress(this.currentSprogAddress, true)) != null || this.findAddress(new DccLocoAddress(this.currentSprogAddress, false)) != null) {
            ++this.currentSprogAddress;
            this.currentSprogAddress %= 10240;
        }
        if (this.currentSprogAddress != lastSprogAddress) {
            log.info("Changing currentSprogAddress (for pseudo-idle packets) to {}(L)", (Object)this.currentSprogAddress);
            this.sendSprogAddress = true;
        }
        for (SprogSlot s : this.slots) {
            if (!s.isActiveAddressMatch(address) || !s.isSpeedPacket()) continue;
            return s;
        }
        if (this.getInUseCount() < this.numSlots) {
            return this.findFree();
        }
        return null;
    }

    private SprogSlot findF0to4Packet(DccLocoAddress address) {
        for (SprogSlot s : this.slots) {
            if (!s.isActiveAddressMatch(address) || !s.isF0to4Packet()) continue;
            return s;
        }
        if (this.getInUseCount() < this.numSlots) {
            return this.findFree();
        }
        return null;
    }

    private SprogSlot findF5to8Packet(DccLocoAddress address) {
        for (SprogSlot s : this.slots) {
            if (!s.isActiveAddressMatch(address) || !s.isF5to8Packet()) continue;
            return s;
        }
        if (this.getInUseCount() < this.numSlots) {
            return this.findFree();
        }
        return null;
    }

    private SprogSlot findF9to12Packet(DccLocoAddress address) {
        for (SprogSlot s : this.slots) {
            if (!s.isActiveAddressMatch(address) || !s.isF9to12Packet()) continue;
            return s;
        }
        if (this.getInUseCount() < this.numSlots) {
            return this.findFree();
        }
        return null;
    }

    private SprogSlot findF13to20Packet(DccLocoAddress address) {
        for (SprogSlot s : this.slots) {
            if (!s.isActiveAddressMatch(address) || !s.isF13to20Packet()) continue;
            return s;
        }
        if (this.getInUseCount() < this.numSlots) {
            return this.findFree();
        }
        return null;
    }

    private SprogSlot findF21to28Packet(DccLocoAddress address) {
        for (SprogSlot s : this.slots) {
            if (!s.isActiveAddressMatch(address) || !s.isF21to28Packet()) continue;
            return s;
        }
        if (this.getInUseCount() < this.numSlots) {
            return this.findFree();
        }
        return null;
    }

    public void forwardCommandChangeToLayout(int address, boolean closed) {
        SprogSlot s = this.findFree();
        if (s != null) {
            s.setAccessoryPacket(address, closed, 1);
            this.notifySlotListeners(s);
        }
    }

    public void function0Through4Packet(DccLocoAddress address, boolean f0, boolean f0Momentary, boolean f1, boolean f1Momentary, boolean f2, boolean f2Momentary, boolean f3, boolean f3Momentary, boolean f4, boolean f4Momentary) {
        SprogSlot s = this.findF0to4Packet(address);
        s.f0to4packet(address.getNumber(), address.isLongAddress(), f0, f0Momentary, f1, f1Momentary, f2, f2Momentary, f3, f3Momentary, f4, f4Momentary);
        this.notifySlotListeners(s);
    }

    public void function5Through8Packet(DccLocoAddress address, boolean f5, boolean f5Momentary, boolean f6, boolean f6Momentary, boolean f7, boolean f7Momentary, boolean f8, boolean f8Momentary) {
        SprogSlot s = this.findF5to8Packet(address);
        s.f5to8packet(address.getNumber(), address.isLongAddress(), f5, f5Momentary, f6, f6Momentary, f7, f7Momentary, f8, f8Momentary);
        this.notifySlotListeners(s);
    }

    public void function9Through12Packet(DccLocoAddress address, boolean f9, boolean f9Momentary, boolean f10, boolean f10Momentary, boolean f11, boolean f11Momentary, boolean f12, boolean f12Momentary) {
        SprogSlot s = this.findF9to12Packet(address);
        s.f9to12packet(address.getNumber(), address.isLongAddress(), f9, f9Momentary, f10, f10Momentary, f11, f11Momentary, f12, f12Momentary);
        this.notifySlotListeners(s);
    }

    public void function13Through20Packet(DccLocoAddress address, boolean f13, boolean f13Momentary, boolean f14, boolean f14Momentary, boolean f15, boolean f15Momentary, boolean f16, boolean f16Momentary, boolean f17, boolean f17Momentary, boolean f18, boolean f18Momentary, boolean f19, boolean f19Momentary, boolean f20, boolean f20Momentary) {
        SprogSlot s = this.findF13to20Packet(address);
        s.f13to20packet(address.getNumber(), address.isLongAddress(), f13, f13Momentary, f14, f14Momentary, f15, f15Momentary, f16, f16Momentary, f17, f17Momentary, f18, f18Momentary, f19, f19Momentary, f20, f20Momentary);
        this.notifySlotListeners(s);
    }

    public void function21Through28Packet(DccLocoAddress address, boolean f21, boolean f21Momentary, boolean f22, boolean f22Momentary, boolean f23, boolean f23Momentary, boolean f24, boolean f24Momentary, boolean f25, boolean f25Momentary, boolean f26, boolean f26Momentary, boolean f27, boolean f27Momentary, boolean f28, boolean f28Momentary) {
        SprogSlot s = this.findF21to28Packet(address);
        s.f21to28packet(address.getNumber(), address.isLongAddress(), f21, f21Momentary, f22, f22Momentary, f23, f23Momentary, f24, f24Momentary, f25, f25Momentary, f26, f26Momentary, f27, f27Momentary, f28, f28Momentary);
        this.notifySlotListeners(s);
    }

    public void setSpeed(SpeedStepMode mode, DccLocoAddress address, int spd, boolean isForward) {
        SprogSlot s = this.findAddressSpeedPacket(address);
        if (s != null) {
            s.setSpeed(mode, address.getNumber(), address.isLongAddress(), spd, isForward);
            this.notifySlotListeners(s);
            log.debug("Registering new speed");
            this.sendNow.add(s);
        }
    }

    public SprogSlot opsModepacket(int address, boolean longAddr, int cv, int val) {
        SprogSlot s = this.findFree();
        if (s != null) {
            s.setOps(address, longAddr, cv, val);
            if (log.isDebugEnabled()) {
                log.debug("opsModePacket() Notify ops mode packet for address {}", (Object)address);
            }
            this.notifySlotListeners(s);
            return s;
        }
        return null;
    }

    public void release(DccLocoAddress address) {
        SprogSlot s;
        while ((s = this.findAddress(address)) != null) {
            s.clear();
            this.notifySlotListeners(s);
        }
    }

    public void estopAll() {
        this.slots.stream().filter(s -> s.getRepeat() == -1 && s.slotStatus() != 0 && s.speed() != 1).forEach(s -> this.eStopSlot((SprogSlot)s));
    }

    protected void eStopSlot(SprogSlot s) {
        log.debug("Estop slot: {} for address: {}", (Object)s.getSlotNumber(), (Object)s.getAddr());
        s.eStop();
        this.notifySlotListeners(s);
    }

    public synchronized void addSlotListener(SprogSlotListener l) {
        this.slotListeners.addElement(l);
    }

    public synchronized void removeSlotListener(SprogSlotListener l) {
        this.slotListeners.removeElement(l);
    }

    private synchronized void notifySlotListeners(SprogSlot s) {
        log.debug("notifySlotListeners() notify {} SlotListeners about slot for address {}", (Object)this.slotListeners.size(), (Object)s.getAddr());
        this.slotListeners.stream().forEach(client -> client.notifyChangedSlot(s));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.debug("Command station slot thread starts");
        while (true) {
            try {
                Object object = this.lock;
                synchronized (object) {
                    this.lock.wait(SprogConstants.CS_REPLY_TIMEOUT);
                }
            }
            catch (InterruptedException interruptedException) {
                log.debug("Slot thread interrupted");
                Thread.currentThread().interrupt();
                return;
            }
            log.debug("Slot thread wakes");
            if (this.powerMgr == null) {
                this.powerMgr = InstanceManager.getNullableDefault(PowerManager.class);
                if (this.powerMgr == null) {
                    log.info("No power manager instance found");
                    continue;
                }
                log.info("Registering with power manager");
                this.powerMgr.addPropertyChangeListener(this);
                continue;
            }
            if (this.sendSprogAddress) {
                this.sendMessage(new SprogMessage("A " + this.currentSprogAddress + " 0"));
                this.replyAvailable = false;
                this.sendSprogAddress = false;
                continue;
            }
            if (this.powerChanged && this.powerState == 2 && !this.waitingForReply) {
                this.sendPacket(NmraPacket.idlePacket(), 1);
                this.powerChanged = false;
                this.time = System.currentTimeMillis();
                continue;
            }
            if (this.replyAvailable && this.powerState == 2) {
                byte[] p;
                SprogSlot s = this.sendNow.poll();
                if (s != null) {
                    p = s.getPayload();
                    log.debug("Packet from immediate send queue");
                } else {
                    p = this.getNextPacket();
                    if (p != null) {
                        log.debug("Packet from stack");
                    }
                }
                this.replyAvailable = false;
                if (p != null) {
                    this.sendPacket(p, 1);
                    log.debug("Packet sent");
                } else {
                    this.sendPacket(NmraPacket.idlePacket(), 1);
                }
                this.timeNow = System.currentTimeMillis();
                this.packetDelay = this.timeNow - this.time;
                this.time = this.timeNow;
                if (this.packetDelay <= (long)SprogConstants.PACKET_DELAY_WARN_THRESHOLD) continue;
                log.warn("Packet delay was {} ms", (Object)this.packetDelay);
                continue;
            }
            if (this.powerState != 2) continue;
            log.warn("Slot thread timeout - removing power");
            this.waitingForReply = false;
            try {
                this.powerMgr.setPower(4);
            }
            catch (JmriException ex) {
                log.error("Exception turning power off {}", (Throwable)ex);
            }
            JOptionPane.showMessageDialog(null, Bundle.getMessage("CSErrorFrameDialogString"), Bundle.getMessage("SprogCSTitle"), 0);
        }
    }

    /*
     * Unable to fully structure code
     */
    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="API defined by Sprog docs")
    private byte[] getNextPacket() {
        if (this.isBusy()) ** GOTO lbl5
        return null;
lbl-1000:
        // 1 sources

        {
            ++this.currentSlot;
            this.currentSlot %= this.numSlots;
lbl5:
            // 2 sources

            ** while (this.slots.get((int)this.currentSlot).isFree())
        }
lbl6:
        // 1 sources

        s = this.slots.get(this.currentSlot);
        ret = s.getPayload();
        if (!s.isOpsPkt() || s.getRepeat() == 0) {
            ++this.currentSlot;
            this.currentSlot %= this.numSlots;
        }
        if (s.isFinished()) {
            this.notifySlotListeners(s);
        }
        return ret;
    }

    @Override
    public void notifyMessage(SprogMessage m) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyReply(SprogReply m) {
        if (m.getId() != this.lastId) {
            log.debug("Ignore reply with mismatched id {} looking for {}", (Object)m.getId(), (Object)this.lastId);
            return;
        }
        log.debug("Reply received [{}]", (Object)m.toString());
        Object object = this.lock;
        synchronized (object) {
            this.replyAvailable = true;
            this.lock.notifyAll();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        log.debug("propertyChange {} = {}", (Object)evt.getPropertyName(), evt.getNewValue());
        if (evt.getPropertyName().equals("power")) {
            this.powerState = this.powerMgr.getPower();
            this.powerChanged = true;
        }
    }

    public int getInUseCount() {
        int result = 0;
        for (SprogSlot s : this.slots) {
            if (s.isFree()) continue;
            ++result;
        }
        return result;
    }

    public boolean isBusy() {
        return this.slots.stream().anyMatch(s -> !s.isFree());
    }

    public void setSystemConnectionMemo(SprogSystemConnectionMemo memo) {
        this.adaptermemo = memo;
    }

    @Override
    public String getUserName() {
        if (this.adaptermemo == null) {
            return "Sprog";
        }
        return this.adaptermemo.getUserName();
    }

    @Override
    public String getSystemPrefix() {
        if (this.adaptermemo == null) {
            return "S";
        }
        return this.adaptermemo.getSystemPrefix();
    }
}

