/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.sprog;

import java.util.EnumSet;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.ThrottleListener;
import jmri.jmrix.AbstractThrottleManager;
import jmri.jmrix.sprog.SprogCSThrottle;
import jmri.jmrix.sprog.SprogSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SprogCSThrottleManager
extends AbstractThrottleManager {
    private static final Logger log = LoggerFactory.getLogger(SprogCSThrottleManager.class);

    public SprogCSThrottleManager(SprogSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    public void requestThrottleSetup(LocoAddress a, boolean control) {
        if (a instanceof DccLocoAddress) {
            log.debug("new SprogThrottle for {}", (Object)a);
            this.notifyThrottleKnown(new SprogCSThrottle((SprogSystemConnectionMemo)this.adapterMemo, a), a);
        } else {
            log.error("{} is not a DccLocoAddress", (Object)a);
            this.failedThrottleRequest(a, "LocoAddress " + a + " is not a DccLocoAddress");
        }
    }

    @Override
    public EnumSet<SpeedStepMode> supportedSpeedModes() {
        return EnumSet.of(SpeedStepMode.NMRA_DCC_128, SpeedStepMode.NMRA_DCC_28);
    }

    @Override
    public boolean canBeLongAddress(int address) {
        return address >= 0 && address <= 10239;
    }

    @Override
    public boolean canBeShortAddress(int address) {
        return address >= 1 && address <= 127;
    }

    @Override
    public boolean addressTypeUnique() {
        return false;
    }

    @Override
    public boolean disposeThrottle(DccThrottle t, ThrottleListener l) {
        if (super.disposeThrottle(t, l) && t instanceof SprogCSThrottle) {
            SprogCSThrottle lnt = (SprogCSThrottle)t;
            lnt.throttleDispose();
            return true;
        }
        return false;
    }
}

