/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.sprog;

import jmri.CommandStation;
import jmri.DccLocoAddress;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.jmrix.AbstractThrottle;
import jmri.jmrix.sprog.SprogCommandStation;
import jmri.jmrix.sprog.SprogSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SprogCSThrottle
extends AbstractThrottle {
    private final SprogCommandStation commandStation;
    DccLocoAddress address;
    private static final Logger log = LoggerFactory.getLogger(SprogCSThrottle.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SprogCSThrottle(SprogSystemConnectionMemo memo, LocoAddress address) {
        super(memo);
        if (address instanceof DccLocoAddress) {
            this.address = (DccLocoAddress)address;
        } else {
            log.error("{} is not a DccLocoAddress", (Object)address);
        }
        SprogCSThrottle sprogCSThrottle = this;
        synchronized (sprogCSThrottle) {
            this.speedSetting = 0.0f;
        }
        this.isForward = true;
        this.speedStepMode = SpeedStepMode.NMRA_DCC_128;
        this.commandStation = memo != null && memo.get(CommandStation.class) != null ? (SprogCommandStation)memo.get(CommandStation.class) : (SprogCommandStation)InstanceManager.getNullableDefault(CommandStation.class);
    }

    @Override
    public LocoAddress getLocoAddress() {
        return this.address;
    }

    @Override
    protected void sendFunctionGroup1() {
        this.commandStation.function0Through4Packet(this.address, this.getF0(), this.getF0Momentary(), this.getF1(), this.getF1Momentary(), this.getF2(), this.getF2Momentary(), this.getF3(), this.getF3Momentary(), this.getF4(), this.getF4Momentary());
    }

    @Override
    protected void sendFunctionGroup2() {
        this.commandStation.function5Through8Packet(this.address, this.getF5(), this.getF5Momentary(), this.getF6(), this.getF6Momentary(), this.getF7(), this.getF7Momentary(), this.getF8(), this.getF8Momentary());
    }

    @Override
    protected void sendFunctionGroup3() {
        this.commandStation.function9Through12Packet(this.address, this.getF9(), this.getF9Momentary(), this.getF10(), this.getF10Momentary(), this.getF11(), this.getF11Momentary(), this.getF12(), this.getF12Momentary());
    }

    @Override
    protected void sendFunctionGroup4() {
        this.commandStation.function13Through20Packet(this.address, this.getF13(), this.getF13Momentary(), this.getF14(), this.getF14Momentary(), this.getF15(), this.getF15Momentary(), this.getF16(), this.getF16Momentary(), this.getF17(), this.getF17Momentary(), this.getF18(), this.getF18Momentary(), this.getF19(), this.getF19Momentary(), this.getF20(), this.getF20Momentary());
    }

    @Override
    protected void sendFunctionGroup5() {
        this.commandStation.function21Through28Packet(this.address, this.getF21(), this.getF21Momentary(), this.getF22(), this.getF22Momentary(), this.getF23(), this.getF23Momentary(), this.getF24(), this.getF24Momentary(), this.getF25(), this.getF25Momentary(), this.getF26(), this.getF26Momentary(), this.getF27(), this.getF27Momentary(), this.getF28(), this.getF28Momentary());
    }

    @Override
    public synchronized void setSpeedSetting(float speed) {
        SpeedStepMode mode = this.getSpeedStepMode();
        if (mode == SpeedStepMode.NMRA_DCC_28) {
            float oldSpeed = this.speedSetting;
            this.speedSetting = speed;
            int value = (int)(28.0f * speed);
            if (value > 0) {
                value += 3;
            }
            if (value > 31) {
                value = 31;
            }
            if (value < 0) {
                value = 1;
            }
            this.commandStation.setSpeed(SpeedStepMode.NMRA_DCC_28, this.address, value, this.isForward);
            this.firePropertyChange("SpeedSetting", Float.valueOf(oldSpeed), Float.valueOf(this.speedSetting));
        } else {
            float oldSpeed = this.speedSetting;
            this.speedSetting = speed;
            int value = (int)(126.0f * speed);
            if (value > 0) {
                ++value;
            }
            if (value > 127) {
                value = 127;
            }
            if (value < 0) {
                value = 1;
            }
            this.commandStation.setSpeed(SpeedStepMode.NMRA_DCC_128, this.address, value, this.isForward);
            this.firePropertyChange("SpeedSetting", Float.valueOf(oldSpeed), Float.valueOf(this.speedSetting));
        }
        this.record(speed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIsForward(boolean forward) {
        boolean old = this.isForward;
        this.isForward = forward;
        SprogCSThrottle sprogCSThrottle = this;
        synchronized (sprogCSThrottle) {
            this.setSpeedSetting(this.speedSetting);
        }
        this.firePropertyChange("IsForward", old, this.isForward);
    }

    @Override
    public void throttleDispose() {
        this.active = false;
        this.commandStation.release(this.address);
        this.finishRecord();
    }
}

