/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.serialsensor;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.ResourceBundle;
import java.util.TooManyListenersException;
import javax.swing.SwingUtilities;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.DefaultSystemConnectionMemo;
import jmri.jmrix.serialsensor.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import purejavacomm.CommPortIdentifier;
import purejavacomm.NoSuchPortException;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import purejavacomm.SerialPortEvent;
import purejavacomm.SerialPortEventListener;
import purejavacomm.UnsupportedCommOperationException;

public class SerialSensorAdapter
extends AbstractSerialPortController {
    SerialPort activeSerialPort = null;
    private boolean opened = false;
    InputStream serialStream = null;
    private static final Logger log = LoggerFactory.getLogger(SerialSensorAdapter.class);

    public SerialSensorAdapter() {
        super(new DefaultSystemConnectionMemo("S", Bundle.getMessage("TypeSerial")){

            @Override
            protected ResourceBundle getActionModelResourceBundle() {
                return null;
            }

            @Override
            public <B extends NamedBean> Comparator<B> getNamedBeanComparator(Class<B> type) {
                return (o1, o2) -> o1.getSystemName().compareTo(o2.getSystemName());
            }
        });
    }

    @Override
    public void configure() {
        log.debug("Configure doesn't do anything here");
    }

    @Override
    public String openPort(String portName, String appName) {
        try {
            CommPortIdentifier portID = CommPortIdentifier.getPortIdentifier(portName);
            try {
                this.activeSerialPort = (SerialPort)portID.open(appName, 2000);
            }
            catch (PortInUseException p) {
                return this.handlePortBusy(p, portName, log);
            }
            try {
                this.activeSerialPort.setSerialPortParams(9600, 8, 1, 0);
            }
            catch (UnsupportedCommOperationException e) {
                log.error("Cannot set serial parameters on port {}: {}", (Object)portName, (Object)e.getMessage());
                return "Cannot set serial parameters on port " + portName + ": " + e.getMessage();
            }
            this.configureLeadsAndFlowControl(this.activeSerialPort, 0, true, false);
            log.debug("Serial timeout was observed as: {} {}", (Object)(String.valueOf(this.activeSerialPort.getReceiveTimeout()) + " " + this.activeSerialPort.isReceiveTimeoutEnabled()));
            this.activeSerialPort.addEventListener(new SerialPortEventListener(){

                @Override
                public void serialEvent(SerialPortEvent e) {
                    int type = e.getEventType();
                    switch (type) {
                        case 4: {
                            log.info("SerialEvent: DSR is {}", (Object)e.getNewValue());
                            this.notify("1", e.getNewValue());
                            return;
                        }
                        case 6: {
                            log.info("SerialEvent: CD is {}", (Object)e.getNewValue());
                            this.notify("2", e.getNewValue());
                            return;
                        }
                        case 3: {
                            log.info("SerialEvent: CTS is {}", (Object)e.getNewValue());
                            this.notify("3", e.getNewValue());
                            return;
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("SerialEvent of type: {} value: {}", (Object)type, (Object)e.getNewValue());
                    }
                }

                public void notify(String sensor, boolean value) {
                    SwingUtilities.invokeLater(new SerialNotifier(sensor, value));
                }
            });
            this.activeSerialPort.notifyOnCTS(true);
            this.activeSerialPort.notifyOnDSR(true);
            this.activeSerialPort.notifyOnCarrierDetect(true);
            this.serialStream = this.activeSerialPort.getInputStream();
            this.purgeStream(this.serialStream);
            if (log.isInfoEnabled()) {
                log.info("{} port opened at {} baud, sees  DTR: {} RTS: {} DSR: {} CTS: {}  CD: {}", new Object[]{portName, this.activeSerialPort.getBaudRate(), this.activeSerialPort.isDTR(), this.activeSerialPort.isRTS(), this.activeSerialPort.isDSR(), this.activeSerialPort.isCTS(), this.activeSerialPort.isCD()});
            }
            this.opened = true;
        }
        catch (NoSuchPortException ex1) {
            log.error("No such port {} ", (Object)portName, (Object)ex1);
            return "No such port " + portName + ": " + ex1;
        }
        catch (TooManyListenersException ex3) {
            log.error("Too Many Listeners on port {} ", (Object)portName, (Object)ex3);
            return "Too Many Listeners on port " + portName + ": " + ex3;
        }
        catch (IOException ex4) {
            log.error("I/O error on port {} ", (Object)portName, (Object)ex4);
            return "I/O error on port " + portName + ": " + ex4;
        }
        return null;
    }

    @Override
    public DataInputStream getInputStream() {
        if (!this.opened) {
            log.error("getInputStream called before load(), stream not available");
            return null;
        }
        return new DataInputStream(this.serialStream);
    }

    @Override
    public DataOutputStream getOutputStream() {
        if (!this.opened) {
            log.error("getOutputStream called before load(), stream not available");
        }
        try {
            return new DataOutputStream(this.activeSerialPort.getOutputStream());
        }
        catch (IOException e) {
            log.error("getOutputStream exception: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public String[] validBaudRates() {
        return new String[]{"9,600 bps"};
    }

    @Override
    public int[] validBaudNumbers() {
        return new int[]{9600};
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }

    @Override
    public void configureBaudRate(String rate) {
    }

    public void notify(String sensor, boolean value) {
    }

    static class SerialNotifier
    implements Runnable {
        String mSensor;
        boolean mValue;

        SerialNotifier(String pSensor, boolean pValue) {
            this.mSensor = pSensor;
            this.mValue = pValue;
        }

        @Override
        public void run() {
            log.debug("serial sensor notify starts");
            int value = 4;
            if (this.mValue) {
                value = 2;
            }
            try {
                InstanceManager.sensorManagerInstance().provideSensor(this.mSensor).setKnownState(value);
            }
            catch (IllegalArgumentException | JmriException e) {
                log.error("Exception setting state: ", (Throwable)e);
            }
        }
    }
}

