/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.secsi.simulator;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import jmri.jmrix.secsi.SecsiSystemConnectionMemo;
import jmri.jmrix.secsi.SerialMessage;
import jmri.jmrix.secsi.SerialPortController;
import jmri.jmrix.secsi.SerialReply;
import jmri.jmrix.secsi.simulator.Bundle;
import jmri.util.ImmediatePipedOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimulatorAdapter
extends SerialPortController
implements Runnable {
    private boolean opened = false;
    private Thread sourceThread;
    private boolean outputBufferEmpty = true;
    private boolean checkBuffer = true;
    protected boolean[] nodesSet = new boolean[128];
    private int[] lastChars = new int[9];
    private int nextNodeAddress;
    private boolean lastCharLoaded = false;
    private DataOutputStream pout = null;
    private DataInputStream pin = null;
    private DataOutputStream outpipe = null;
    private DataInputStream inpipe = null;
    private static final Logger log = LoggerFactory.getLogger(SimulatorAdapter.class);

    public SimulatorAdapter() {
        super(new SecsiSystemConnectionMemo("V", Bundle.getMessage("SecsiSimulatorName")));
        this.setManufacturer("TracTronics");
    }

    @Override
    public String openPort(String portName, String appName) {
        try {
            ImmediatePipedOutputStream tempPipeI = new ImmediatePipedOutputStream();
            log.debug("tempPipeI created");
            this.pout = new DataOutputStream(tempPipeI);
            this.inpipe = new DataInputStream(new PipedInputStream(tempPipeI));
            log.debug("inpipe created {}", (Object)(this.inpipe != null ? 1 : 0));
            ImmediatePipedOutputStream tempPipeO = new ImmediatePipedOutputStream();
            this.outpipe = new DataOutputStream(tempPipeO);
            this.pin = new DataInputStream(new PipedInputStream(tempPipeO));
        }
        catch (IOException e) {
            log.error("init (pipe): Exception: {}", (Object)e.toString());
        }
        this.opened = true;
        return null;
    }

    public synchronized void setOutputBufferEmpty(boolean s) {
        this.outputBufferEmpty = s;
    }

    public boolean okToSend() {
        if (this.checkBuffer) {
            log.debug("Buffer Empty: {}", (Object)this.outputBufferEmpty);
            return this.outputBufferEmpty;
        }
        log.debug("No Flow Control or Buffer Check");
        return true;
    }

    @Override
    public void configure() {
        log.debug("set tc for memo {}", (Object)this.getSystemConnectionMemo().getUserName());
        ((SecsiSystemConnectionMemo)this.getSystemConnectionMemo()).getTrafficController().connectPort(this);
        ((SecsiSystemConnectionMemo)this.getSystemConnectionMemo()).configureManagers();
        this.sourceThread = new Thread(this);
        this.sourceThread.setName("Secsi Simulator");
        this.sourceThread.setPriority(1);
        this.sourceThread.start();
    }

    @Override
    public void connect() throws IOException {
        log.debug("connect called");
        super.connect();
    }

    @Override
    public DataInputStream getInputStream() {
        if (!this.opened || this.pin == null) {
            log.error("getInputStream called before load(), stream not available");
        }
        log.debug("DataInputStream pin returned");
        return this.pin;
    }

    @Override
    public DataOutputStream getOutputStream() {
        if (!this.opened || this.pout == null) {
            log.error("getOutputStream called before load(), stream not available");
        }
        log.debug("DataOutputStream pout returned");
        return this.pout;
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public String[] validBaudRates() {
        log.debug("validBaudRates should not have been invoked");
        return new String[0];
    }

    @Override
    public int[] validBaudNumbers() {
        return new int[0];
    }

    @Override
    public String getCurrentBaudRate() {
        return "";
    }

    @Override
    public String getCurrentPortName() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.info("Secsi Simulator Started");
        while (true) {
            SerialReply r;
            int i;
            StringBuffer buf;
            try {
                SimulatorAdapter simulatorAdapter = this;
                synchronized (simulatorAdapter) {
                    this.wait(50L);
                }
            }
            catch (InterruptedException interruptedException) {
                log.debug("interrupted, ending");
                return;
            }
            SerialMessage m = this.readMessage();
            if (log.isDebugEnabled()) {
                buf = new StringBuffer();
                buf.append("Secsi Simulator Thread received message: ");
                if (m != null) {
                    i = 0;
                    while (i < m.getNumDataElements()) {
                        buf.append(String.valueOf(Integer.toHexString(0xFF & m.getElement(i))) + " ");
                        ++i;
                    }
                } else {
                    buf.append("null message buffer");
                }
                log.trace(buf.toString());
            }
            if (m == null || (r = this.generateReply(m)) == null) continue;
            this.writeReply(r);
            if (!log.isDebugEnabled()) continue;
            buf = new StringBuffer();
            buf.append("Secsi Simulator Thread sent reply: ");
            i = 0;
            while (i < r.getNumDataElements()) {
                buf.append(String.valueOf(Integer.toHexString(0xFF & r.getElement(i))) + " ");
                ++i;
            }
            log.debug(buf.toString());
        }
    }

    private SerialMessage readMessage() {
        SerialMessage msg = null;
        try {
            if (this.inpipe != null && this.inpipe.available() > 0) {
                msg = this.loadChars();
            }
        }
        catch (IOException iOException) {}
        this.setOutputBufferEmpty(true);
        return msg;
    }

    private SerialReply generateReply(SerialMessage msg) {
        int nodeaddr = msg.getAddr();
        log.debug("Generate Reply to message for node {} (string = {})", (Object)nodeaddr, (Object)msg.toString());
        SerialReply reply = new SerialReply();
        switch (msg.getNumDataElements()) {
            case 1: {
                log.debug("Poll message detected by simulator");
                reply.setElement(0, nodeaddr);
                reply.setElement(1, 48);
                this.nodesSet[nodeaddr] = true;
                log.debug("Poll reply generated {}", (Object)reply.toString());
                return reply;
            }
            case 5: {
                if (((SecsiSystemConnectionMemo)this.getSystemConnectionMemo()).getTrafficController().getNode(nodeaddr).getSensorsActive()) {
                    int payload = 5;
                    int j = 0;
                    while (j < 3) {
                        reply.setElement(j + 1, payload |= j << 4);
                        ++j;
                    }
                    log.debug("Status Reply generated {}", (Object)reply.toString());
                }
                return reply;
            }
            case 9: {
                log.debug("Outpacket received");
                return null;
            }
        }
        log.debug("Message (other) ignored");
        return null;
    }

    private void writeReply(SerialReply r) {
        if (r == null) {
            return;
        }
        int i = 0;
        while (i < r.getNumDataElements()) {
            try {
                this.outpipe.writeByte((byte)r.getElement(i));
            }
            catch (IOException iOException) {}
            ++i;
        }
        try {
            this.outpipe.flush();
        }
        catch (IOException iOException) {}
    }

    private SerialMessage loadChars() throws IOException {
        int char0;
        int i = 1;
        if (this.lastCharLoaded && this.nextNodeAddress < 47) {
            char0 = this.nextNodeAddress;
            this.lastCharLoaded = false;
        } else {
            try {
                byte byte0 = this.readByteProtected(this.inpipe);
                char0 = byte0 & 0xFF;
                log.debug("loadChars read {}", (Object)char0);
            }
            catch (IOException iOException) {
                this.lastCharLoaded = false;
                log.debug("loadChars aborted while reading char 0");
                return null;
            }
        }
        if (char0 > 47) {
            log.debug("bit not valid as node address");
        }
        i = 1;
        while (i < 9) {
            byte nextByte;
            log.debug("reading rest of message in simulator, element {}", (Object)i);
            try {
                nextByte = this.readByteProtected(this.inpipe);
            }
            catch (IOException iOException) {
                log.debug("loadChars aborted after {} chars", (Object)i);
                this.lastCharLoaded = false;
                log.debug("overshot reading Secsi message at element {}. Ready", (Object)i);
                break;
            }
            log.debug("loadChars read {} (item {})", (Object)Integer.toHexString(nextByte & 0xFF), (Object)i);
            if ((nextByte & 0xFF) >> 4 != i - 1) {
                if ((nextByte & 0xFF) < 47) {
                    this.nextNodeAddress = nextByte & 0xFF;
                    this.lastCharLoaded = true;
                    i = Math.max(1, i - 1);
                    log.debug("overshot reading Secsi message at element {}. Next node = {}", (Object)i, (Object)this.nextNodeAddress);
                    break;
                }
                if (this.lastChars[i - 1] >= 0 && this.lastChars[i - 1] < 47) {
                    this.nextNodeAddress = this.lastChars[i - 1];
                    this.lastCharLoaded = true;
                    i = Math.max(1, i - 1);
                    log.debug("overshot Secsi message at element {}. Next node = {}", (Object)i, (Object)this.nextNodeAddress);
                    break;
                }
                this.lastCharLoaded = false;
                i = Math.max(1, i - 1);
                log.debug("unhandled Secsi message from element {}", (Object)i);
                break;
            }
            this.lastChars[i] = nextByte & 0xFF;
            log.debug("matched item {} in series: {}", (Object)i, (Object)((nextByte & 0xFF) >> 4));
            ++i;
        }
        SerialMessage msg = new SerialMessage(i);
        msg.setElement(0, char0);
        int k = 1;
        while (k < i) {
            msg.setElement(k, this.lastChars[k]);
            ++k;
        }
        log.debug("Secsi message received by simulator, length = {}", (Object)i);
        if (msg.getNumDataElements() == 1) {
            this.nodesSet[char0] = false;
        }
        return msg;
    }

    private byte readByteProtected(DataInputStream istream) throws IOException {
        int nchars;
        byte[] rcvBuffer = new byte[1];
        while ((nchars = istream.read(rcvBuffer, 0, 1)) <= 0) {
        }
        return rcvBuffer[0];
    }
}

