/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.secsi.packetgen;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jmri.jmrix.secsi.SecsiSystemConnectionMemo;
import jmri.jmrix.secsi.SerialListener;
import jmri.jmrix.secsi.SerialMessage;
import jmri.jmrix.secsi.SerialReply;
import jmri.jmrix.secsi.packetgen.Bundle;
import jmri.util.JmriJFrame;
import jmri.util.StringUtil;

public class SerialPacketGenFrame
extends JmriJFrame
implements SerialListener {
    private SecsiSystemConnectionMemo memo;
    JLabel jLabel1 = new JLabel();
    JButton sendButton = new JButton();
    JTextField packetTextField = new JTextField(12);
    JButton pollButton = new JButton(Bundle.getMessage("LabelPoll"));
    JTextField uaAddrField = new JTextField(5);

    public SerialPacketGenFrame(SecsiSystemConnectionMemo _memo) {
        this.memo = _memo;
    }

    @Override
    public void initComponents() {
        this.jLabel1.setText(Bundle.getMessage("CommandLabel"));
        this.jLabel1.setVisible(true);
        this.sendButton.setText(Bundle.getMessage("ButtonSend"));
        this.sendButton.setVisible(true);
        this.sendButton.setToolTipText(Bundle.getMessage("TooltipSendPacket"));
        this.packetTextField.setText("");
        this.packetTextField.setToolTipText(Bundle.getMessage("EnterHexToolTip"));
        this.packetTextField.setMaximumSize(new Dimension(this.packetTextField.getMaximumSize().width, this.packetTextField.getPreferredSize().height));
        this.setTitle(Bundle.getMessage("SendXCommandTitle", "SECSI"));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(this.jLabel1);
        this.getContentPane().add(this.packetTextField);
        this.getContentPane().add(this.sendButton);
        this.sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SerialPacketGenFrame.this.sendButtonActionPerformed(e);
            }
        });
        this.getContentPane().add(new JSeparator(0));
        JPanel pane3 = new JPanel();
        pane3.setLayout(new FlowLayout());
        pane3.add(new JLabel(Bundle.getMessage("LabelNodeAddress")));
        pane3.add(this.uaAddrField);
        pane3.add(this.pollButton);
        this.pollButton.setToolTipText(Bundle.getMessage("PollToolTip"));
        this.uaAddrField.setText("0");
        this.uaAddrField.setToolTipText(Bundle.getMessage("TooltipNodeAddress"));
        this.getContentPane().add(pane3);
        this.pollButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SerialPacketGenFrame.this.pollButtonActionPerformed(e);
            }
        });
        this.pack();
    }

    public void pollButtonActionPerformed(ActionEvent e) {
        SerialMessage msg = SerialMessage.getPoll(Integer.parseInt(this.uaAddrField.getText()));
        this.memo.getTrafficController().sendSerialMessage(msg, this);
    }

    public void sendButtonActionPerformed(ActionEvent e) {
        String input = this.packetTextField.getText();
        this.memo.getTrafficController().sendSerialMessage(this.createPacket(input), this);
    }

    SerialMessage createPacket(String s) {
        byte[] b = StringUtil.bytesFromHexString(s);
        if (b.length < 4 || b.length > 5) {
            return null;
        }
        SerialMessage m = new SerialMessage(5);
        int i = 0;
        while (i < b.length) {
            m.setElement(i, b[i]);
            ++i;
        }
        return m;
    }

    @Override
    public void message(SerialMessage m) {
    }

    @Override
    public void reply(SerialReply r) {
    }
}

