/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.secsi;

import java.io.DataInputStream;
import java.io.IOException;
import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractMRNodeTrafficController;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.secsi.SecsiSystemConnectionMemo;
import jmri.jmrix.secsi.SerialInterface;
import jmri.jmrix.secsi.SerialListener;
import jmri.jmrix.secsi.SerialMessage;
import jmri.jmrix.secsi.SerialNode;
import jmri.jmrix.secsi.SerialReply;
import jmri.jmrix.secsi.SerialSensorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialTrafficController
extends AbstractMRNodeTrafficController
implements SerialInterface {
    SerialSensorManager mSensorManager = null;
    SecsiSystemConnectionMemo memo = null;
    protected int currentAddr = -1;
    protected int incomingLength = 0;
    private static final Logger log = LoggerFactory.getLogger(SerialTrafficController.class);

    public SerialTrafficController(SecsiSystemConnectionMemo adaptermemo) {
        this.memo = adaptermemo;
        log.debug("creating a new SECSI SerialTrafficController object on {}", (Object)adaptermemo.getSystemPrefix());
        this.init(0, 255);
        this.mWaitBeforePoll = 25;
    }

    @Override
    public synchronized void addSerialListener(SerialListener l) {
        this.addListener(l);
    }

    @Override
    public synchronized void removeSerialListener(SerialListener l) {
        this.removeListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeSerialNode(SerialNode node) {
        SerialTrafficController serialTrafficController = this;
        synchronized (serialTrafficController) {
            int i = 0;
            while (i < this.getNumNodes()) {
                if (this.getNode(i) == node) {
                    this.setMustInit(i, true);
                    return;
                }
                ++i;
            }
        }
    }

    @Override
    protected AbstractMRMessage enterProgMode() {
        log.warn("enterProgMode doesn't make sense for SECSI serial");
        return null;
    }

    @Override
    protected AbstractMRMessage enterNormalMode() {
        return null;
    }

    @Override
    protected void forwardMessage(AbstractMRListener client, AbstractMRMessage m) {
        ((SerialListener)client).message((SerialMessage)m);
    }

    @Override
    protected void forwardReply(AbstractMRListener client, AbstractMRReply m) {
        ((SerialListener)client).reply((SerialReply)m);
    }

    public void setSensorManager(SerialSensorManager m) {
        this.mSensorManager = m;
    }

    @Override
    protected synchronized AbstractMRMessage pollMessage() {
        AbstractMRMessage m;
        if (this.getNumNodes() <= 0) {
            return null;
        }
        ++this.curSerialNodeIndex;
        if (this.curSerialNodeIndex >= this.getNumNodes()) {
            this.curSerialNodeIndex = 0;
        }
        if (this.getMustInit(this.curSerialNodeIndex)) {
            this.setMustInit(this.curSerialNodeIndex, false);
            m = this.getNode(this.curSerialNodeIndex).createInitPacket();
            if (m != null) {
                log.debug("send init message: {} to node {}", (Object)m.toString(), (Object)this.curSerialNodeIndex);
                m.setTimeout(2000);
                return m;
            }
        }
        if (this.getNode(this.curSerialNodeIndex).mustSend()) {
            log.debug("request write command to send");
            m = this.getNode(this.curSerialNodeIndex).createOutPacket();
            this.getNode(this.curSerialNodeIndex).resetMustSend();
            m.setTimeout(500);
            return m;
        }
        if (this.getNode(this.curSerialNodeIndex).getSensorsActive()) {
            log.debug("poll command start for {} nodes", (Object)this.getNumNodes());
            m = SerialMessage.getPoll(this.getNode(this.curSerialNodeIndex).getNodeAddress());
            if (this.curSerialNodeIndex >= this.getNumNodes()) {
                this.curSerialNodeIndex = 0;
            }
            log.debug("poll command created");
            return m;
        }
        return null;
    }

    @Override
    protected synchronized void handleTimeout(AbstractMRMessage m, AbstractMRListener l) {
        if (this.getNode(this.curSerialNodeIndex) != null) {
            if (this.getNode(this.curSerialNodeIndex).handleTimeout(m, l)) {
                this.setMustInit(this.curSerialNodeIndex, true);
            } else {
                log.warn("Timeout can't be handled due to missing node (index {})", (Object)this.curSerialNodeIndex);
            }
        }
    }

    @Override
    protected synchronized void resetTimeout(AbstractMRMessage m) {
        this.getNode(this.curSerialNodeIndex).resetTimeout(m);
    }

    @Override
    protected AbstractMRListener pollReplyHandler() {
        return this.mSensorManager;
    }

    @Override
    public void sendSerialMessage(SerialMessage m, SerialListener reply) {
        this.sendMessage(m, reply);
    }

    public SecsiSystemConnectionMemo getSystemConnectionMemo() {
        return this.memo;
    }

    public void setSystemConnectionMemo(SecsiSystemConnectionMemo m) {
        log.debug("Secsi SerialTrafficController set memo to {}", (Object)m.getUserName());
        this.memo = m;
    }

    @Override
    protected AbstractMRReply newReply() {
        return new SerialReply();
    }

    @Override
    protected boolean endOfMessage(AbstractMRReply msg) {
        log.error("Not using endOfMessage, should not be called");
        return false;
    }

    @Override
    protected void loadChars(AbstractMRReply msg, DataInputStream istream) throws IOException {
        byte char1 = this.readByteProtected(istream);
        msg.setElement(0, char1 & 0xFF);
        if ((char1 & 0xFF) != this.currentAddr) {
            return;
        }
        if (this.incomingLength <= 1) {
            return;
        }
        int i = 1;
        while (i < this.incomingLength) {
            char1 = this.readByteProtected(istream);
            msg.setElement(i, char1 & 0xFF);
            ++i;
        }
    }

    @Override
    protected void waitForStartOfReply(DataInputStream istream) throws IOException {
    }

    @Override
    protected int addHeaderToOutput(byte[] msg, AbstractMRMessage m) {
        return 0;
    }

    @Override
    protected void addTrailerToOutput(byte[] msg, int offset, AbstractMRMessage m) {
        this.incomingLength = ((SerialMessage)m).getResponseLength();
        this.currentAddr = ((SerialMessage)m).getAddr();
    }

    @Override
    protected int lengthOfByteStream(AbstractMRMessage m) {
        return m.getNumDataElements();
    }
}

