/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.secsi;

import jmri.JmriException;
import jmri.Sensor;
import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractNode;
import jmri.jmrix.secsi.Bundle;
import jmri.jmrix.secsi.SerialMessage;
import jmri.jmrix.secsi.SerialReply;
import jmri.jmrix.secsi.SerialTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialNode
extends AbstractNode {
    private SerialTrafficController tc = null;
    static final int MAXSENSORS = 16;
    static final int MAXTURNOUTS = 32;
    public static final int DAUGHTER = 0;
    public static final int CABDRIVER = 1;
    private static final String[] boardNames = new String[]{Bundle.getMessage("BoardName1"), Bundle.getMessage("BoardName2")};
    static final int[] outputBits = new int[]{32, 32};
    static final int[] inputBits = new int[]{16, 16};
    protected int nodeType = 0;
    protected boolean[] outputArray = new boolean[33];
    protected boolean[] outputBitChanged = new boolean[33];
    protected boolean hasActiveSensors = false;
    protected int lastUsedSensor = 0;
    protected Sensor[] sensorArray = new Sensor[17];
    protected int[] sensorLastSetting = new int[17];
    protected int[] sensorTempSetting = new int[17];
    boolean warned = false;
    int timeout = 0;
    private static final Logger log = LoggerFactory.getLogger(SerialNode.class);

    public static String[] getBoardNames() {
        return (String[])boardNames.clone();
    }

    public SerialNode(SerialTrafficController _tc) {
        this(0, 0, _tc);
    }

    public SerialNode(int address, int type, SerialTrafficController _tc) {
        this.tc = _tc;
        this.setNodeAddress(address);
        this.setNodeType(type);
        int i = 0;
        while (i < 17) {
            this.sensorArray[i] = null;
            this.sensorLastSetting[i] = 1;
            this.sensorTempSetting[i] = 1;
            ++i;
        }
        i = 0;
        while (i < 33) {
            this.outputArray[i] = false;
            this.outputBitChanged[i] = false;
            ++i;
        }
        this.setMustSend();
        this.hasActiveSensors = false;
        this.tc.registerNode(this);
        log.debug("new serial node {}", (Object)this);
    }

    public void setOutputBit(int bitNumber, boolean state) {
        if (bitNumber > outputBits[this.nodeType]) {
            this.warn("Output bit out-of-range for defined node: " + bitNumber);
            return;
        }
        boolean oldBit = this.outputArray[bitNumber];
        this.outputArray[bitNumber] = state;
        if (oldBit != this.outputArray[bitNumber]) {
            this.setMustSend();
            this.outputBitChanged[bitNumber] = true;
        }
    }

    @Override
    public boolean getSensorsActive() {
        return this.hasActiveSensors;
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(int type) {
        this.nodeType = type;
        switch (this.nodeType) {
            default: {
                log.error("Unexpected nodeType in setNodeType: {}", (Object)this.nodeType);
                break;
            }
            case 0: {
            }
            case 1: 
        }
    }

    @Override
    protected boolean checkNodeAddress(int address) {
        return address >= 0 && address < 128;
    }

    @Override
    public AbstractMRMessage createInitPacket() {
        return null;
    }

    @Override
    public AbstractMRMessage createOutPacket() {
        log.debug("createOutPacket for nodeType {} with {} {};{} {};{} {};{} {}.", new Object[]{this.nodeType, this.outputBitChanged[0], this.outputArray[0], this.outputBitChanged[1], this.outputArray[1], this.outputBitChanged[2], this.outputArray[2], this.outputBitChanged[3], this.outputArray[3]});
        SerialMessage m = new SerialMessage(1 + outputBits[this.getNodeType()] / 4);
        log.debug("message m byte length = {}/4 = {}", (Object)(1 + outputBits[this.getNodeType()]), (Object)m.getNumDataElements());
        m.setElement(0, this.getNodeAddress());
        int j = 0;
        int i = 1;
        while (i < outputBits[this.nodeType]) {
            int payload = 0;
            if (this.outputArray[i + 0]) {
                payload |= 1;
            }
            if (this.outputArray[i + 1]) {
                payload |= 2;
            }
            if (this.outputArray[i + 2]) {
                payload |= 4;
            }
            if (this.outputArray[i + 3]) {
                payload |= 8;
            }
            m.setElement(j + 1, payload |= j << 4);
            ++j;
            i += 4;
        }
        return m;
    }

    void warn(String s) {
        if (this.warned) {
            return;
        }
        this.warned = true;
        log.warn(s);
    }

    public void markChanges(SerialReply l) {
        try {
            int inputBits = (l.getElement(0) & 0xFF) + ((l.getElement(1) & 0xF) << 8);
            int i = 0;
            while (i <= this.lastUsedSensor) {
                if (this.sensorArray[i] != null) {
                    boolean value = (inputBits & 1) != 0;
                    inputBits >>= 1;
                    if (value) {
                        if ((this.sensorTempSetting[i] == 2 || this.sensorTempSetting[i] == 1) && this.sensorLastSetting[i] != 2) {
                            this.sensorLastSetting[i] = 2;
                            this.sensorArray[i].setKnownState(2);
                        }
                        this.sensorTempSetting[i] = 2;
                    } else {
                        if ((this.sensorTempSetting[i] == 4 || this.sensorTempSetting[i] == 1) && this.sensorLastSetting[i] != 4) {
                            this.sensorLastSetting[i] = 4;
                            this.sensorArray[i].setKnownState(4);
                        }
                        this.sensorTempSetting[i] = 4;
                    }
                }
                ++i;
            }
        }
        catch (JmriException e) {
            log.error("exception in markChanges: ", (Throwable)e);
        }
    }

    public void registerSensor(Sensor s, int i) {
        if (i < 0 || i > inputBits[this.nodeType] - 1 || i > 16) {
            log.error("Unexpected sensor ordinal in registerSensor: {}", (Object)Integer.toString(i + 1));
            return;
        }
        this.hasActiveSensors = true;
        if (this.sensorArray[i] == null) {
            this.sensorArray[i] = s;
            if (this.lastUsedSensor < i) {
                this.lastUsedSensor = i;
            }
        } else {
            log.warn("multiple registration of same sensor: {}S{}", (Object)this.tc.getSystemConnectionMemo().getSystemPrefix(), (Object)Integer.toString(this.getNodeAddress() * 1000 + i + 1));
        }
    }

    @Override
    public boolean handleTimeout(AbstractMRMessage m, AbstractMRListener l) {
        ++this.timeout;
        try {
            if (m.getElement(1) != 80) {
                return false;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            log.debug("message does not contain element 1", (Throwable)e);
        }
        log.warn("Timeout to poll for addr {}: consecutive timeouts: {}", (Object)this.getNodeAddress(), (Object)this.timeout);
        if (this.timeout > 5) {
            this.timeout = 0;
            this.setMustSend();
            return true;
        }
        return false;
    }

    @Override
    public void resetTimeout(AbstractMRMessage m) {
        if (this.timeout > 0) {
            log.debug("Reset {} timeout count", (Object)this.timeout);
        }
        this.timeout = 0;
    }
}

