/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.secsi;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.Manager;
import jmri.NamedBean;
import jmri.jmrix.secsi.Bundle;
import jmri.jmrix.secsi.SerialNode;
import jmri.jmrix.secsi.SerialTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialAddress {
    private static final Logger log = LoggerFactory.getLogger(SerialAddress.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SerialNode getNodeFromSystemName(String systemName, SerialTrafficController tc) {
        int ua;
        String prefix = tc.getSystemConnectionMemo().getSystemPrefix();
        if (!systemName.startsWith(prefix) || systemName.charAt(prefix.length()) != 'L' && systemName.charAt(prefix.length()) != 'S' && systemName.charAt(prefix.length()) != 'T') {
            log.error("illegal character in header field of system name: {}", (Object)systemName);
            return null;
        }
        String s = "";
        boolean noB = true;
        int i = prefix.length() + 1;
        while (i < systemName.length() && noB) {
            if (systemName.charAt(i) == 'B') {
                s = systemName.substring(prefix.length() + 1, i);
                noB = false;
            }
            ++i;
        }
        if (noB) {
            int num = Integer.parseInt(systemName.substring(prefix.length() + 1));
            if (num > 0) {
                ua = num / 1000;
                return (SerialNode)tc.getNodeFromAddress(ua);
            }
            log.error("invalid system name: {}", (Object)systemName);
            return null;
        }
        if (s.length() == 0) {
            log.error("no node address before 'B' in system name: {}", (Object)systemName);
            return null;
        }
        try {
            ua = Integer.parseInt(s);
            return (SerialNode)tc.getNodeFromAddress(ua);
        }
        catch (Exception exception) {
            log.error("illegal character in system name: {}", (Object)systemName);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getBitFromSystemName(String systemName, String prefix) {
        if (!systemName.startsWith(prefix) || systemName.charAt(prefix.length()) != 'L' && systemName.charAt(prefix.length()) != 'S' && systemName.charAt(prefix.length()) != 'T') {
            log.error("invalid character in header field of system name: {}", (Object)systemName);
            return 0;
        }
        int k = 0;
        int i = prefix.length() + 1;
        while (i < systemName.length() && k == 0) {
            if (systemName.charAt(i) == 'B') {
                k = i + 1;
            }
            ++i;
        }
        int n = 0;
        if (k == 0) {
            int num;
            try {
                num = Integer.parseInt(systemName.substring(prefix.length() + 1));
            }
            catch (Exception exception) {
                log.error("invalid character in number field of system name: {}", (Object)systemName);
                return 0;
            }
            if (num > 0) {
                return num - num / 1000 * 1000;
            }
            log.error("invalid system name: {}", (Object)systemName);
            return 0;
        }
        try {
            return Integer.parseInt(systemName.substring(k, systemName.length()));
        }
        catch (Exception exception) {
            log.error("illegal character in bit number field system name: {}", (Object)systemName);
            return 0;
        }
    }

    public static String validateSystemNameFormat(String systemName, String prefix, Locale locale) throws IllegalArgumentException {
        if (!systemName.startsWith(prefix)) {
            throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameInvalidPrefix", systemName), Bundle.getMessage(locale, "InvalidSystemNameInvalidPrefix", systemName));
        }
        String address = systemName.substring(prefix.length());
        int node = 0;
        int bit = 0;
        if (!address.contains("B")) {
            try {
                int num = Integer.parseInt(address);
                node = num / 1000;
                bit = num - num / 1000 * 1000;
            }
            catch (NumberFormatException numberFormatException) {
                throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameNotInteger", systemName, prefix), Bundle.getMessage(locale, "InvalidSystemNameNotInteger", systemName, prefix));
            }
        }
        String[] parts = address.split("B");
        if (parts.length != 2) {
            if (address.indexOf("B") == 0) {
                throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameNodeInvalid", systemName, ""), Bundle.getMessage(locale, "InvalidSystemNameNodeInvalid", systemName, ""));
            }
            throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameBitInvalid", systemName, ""), Bundle.getMessage(locale, "InvalidSystemNameBitInvalid", systemName, ""));
        }
        try {
            node = Integer.parseInt(parts[0]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameNodeInvalid", systemName, parts[0]), Bundle.getMessage(locale, "InvalidSystemNameNodeInvalid", systemName, parts[0]));
        }
        try {
            bit = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameBitInvalid", systemName, parts[1]), Bundle.getMessage(locale, "InvalidSystemNameBitInvalid", systemName, parts[1]));
        }
        if (node < 0 || node >= 128) {
            throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameNodeInvalid", systemName, node), Bundle.getMessage(locale, "InvalidSystemNameNodeInvalid", systemName, node));
        }
        if (bit < 1 || bit > 32) {
            throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameBitInvalid", systemName, bit), Bundle.getMessage(locale, "InvalidSystemNameBitInvalid", systemName, bit));
        }
        return systemName;
    }

    public static Manager.NameValidity validSystemNameFormat(@Nonnull String systemName, char type, String prefix) {
        int num;
        if (!systemName.startsWith(prefix) || systemName.charAt(prefix.length()) != type) {
            log.error("illegal character in header field system name: {}", (Object)systemName);
            return Manager.NameValidity.INVALID;
        }
        String s = "";
        int k = 0;
        boolean noB = true;
        int i = prefix.length() + 1;
        while (i < systemName.length() && noB) {
            if (systemName.charAt(i) == 'B') {
                s = systemName.substring(prefix.length() + 1, i);
                k = i + 1;
                noB = false;
            }
            ++i;
        }
        if (noB) {
            try {
                num = Integer.parseInt(systemName.substring(prefix.length() + 1));
            }
            catch (Exception exception) {
                log.debug("invalid character in number field system name: {}", (Object)systemName);
                return Manager.NameValidity.INVALID;
            }
            if (num < 1 || num >= 128000) {
                log.debug("number field out of range in system name: {}", (Object)systemName);
                return Manager.NameValidity.INVALID;
            }
            if (num - num / 1000 * 1000 == 0) {
                log.debug("bit number not in range 1 - 999 in system name: {}", (Object)systemName);
                return Manager.NameValidity.INVALID;
            }
        } else {
            if (s.length() == 0) {
                log.debug("no node address before 'B' in system name: {}", (Object)systemName);
                return Manager.NameValidity.INVALID;
            }
            try {
                num = Integer.parseInt(s);
            }
            catch (Exception exception) {
                log.debug("invalid character in node address field of system name: {}", (Object)systemName);
                return Manager.NameValidity.INVALID;
            }
            if (num < 0 || num >= 128) {
                log.debug("node address field out of range in system name: {}", (Object)systemName);
                return Manager.NameValidity.INVALID;
            }
            try {
                num = Integer.parseInt(systemName.substring(k, systemName.length()));
            }
            catch (Exception exception) {
                log.debug("invalid character in bit number field of system name: {}", (Object)systemName);
                return Manager.NameValidity.INVALID;
            }
            if (num < 1 || num > 32) {
                log.debug("bit number field out of range in system name: {}", (Object)systemName);
                return Manager.NameValidity.INVALID;
            }
        }
        return Manager.NameValidity.VALID;
    }

    public static boolean validSystemNameConfig(String systemName, char type, SerialTrafficController tc) {
        String prefix = tc.getSystemConnectionMemo().getSystemPrefix();
        if (SerialAddress.validSystemNameFormat(systemName, type, prefix) != Manager.NameValidity.VALID) {
            log.warn("{} invalid; bad format", (Object)systemName);
            return false;
        }
        SerialNode node = SerialAddress.getNodeFromSystemName(systemName, tc);
        if (node == null) {
            log.warn("{} invalid; no such node", (Object)systemName);
            return false;
        }
        int bit = SerialAddress.getBitFromSystemName(systemName, prefix);
        if (type == 'T' || type == 'L') {
            if (bit <= 0 || bit > SerialNode.outputBits[node.nodeType]) {
                log.warn("{} invalid; bad bit number", (Object)systemName);
                return false;
            }
        } else if (type == 'S') {
            if (bit <= 0 || bit > SerialNode.inputBits[node.nodeType]) {
                log.warn("{} invalid; bad bit number", (Object)systemName);
                return false;
            }
        } else {
            log.error("Invalid type specification in validSystemNameConfig call");
            return false;
        }
        return true;
    }

    public static String convertSystemNameToAlternate(String systemName, String prefix) {
        if (SerialAddress.validSystemNameFormat(systemName, systemName.charAt(prefix.length()), prefix) != Manager.NameValidity.VALID) {
            return "";
        }
        String altName = "";
        String s = "";
        int k = 0;
        boolean noB = true;
        int i = prefix.length() + 1;
        while (i < systemName.length() && noB) {
            if (systemName.charAt(i) == 'B') {
                s = systemName.substring(prefix.length() + 1, i);
                k = i + 1;
                noB = false;
            }
            ++i;
        }
        if (noB) {
            int num = Integer.parseInt(systemName.substring(prefix.length() + 1));
            int nAddress = num / 1000;
            int bitNum = num - nAddress * 1000;
            altName = String.valueOf(prefix) + systemName.charAt(prefix.length()) + Integer.toString(nAddress) + "B" + Integer.toString(bitNum);
        } else {
            int nAddress = Integer.parseInt(s);
            int bitNum = Integer.parseInt(systemName.substring(k, systemName.length()));
            if (bitNum > 999) {
                return "";
            }
            altName = String.valueOf(prefix) + systemName.charAt(prefix.length()) + Integer.toString(nAddress * 1000 + bitNum);
        }
        return altName;
    }

    public static String normalizeSystemName(String systemName, String prefix) {
        if (prefix.length() < 1) {
            log.error("invalid system name prefix: {}", (Object)prefix);
            return "";
        }
        if (SerialAddress.validSystemNameFormat(systemName, systemName.charAt(prefix.length()), prefix) != Manager.NameValidity.VALID) {
            return "";
        }
        String nName = "";
        String s = "";
        int k = 0;
        boolean noB = true;
        int i = prefix.length() + 1;
        while (i < systemName.length() && noB) {
            if (systemName.charAt(i) == 'B') {
                s = systemName.substring(prefix.length() + 1, i);
                k = i + 1;
                noB = false;
            }
            ++i;
        }
        char type = systemName.charAt(prefix.length());
        if (noB) {
            int num = Integer.parseInt(systemName.substring(prefix.length() + 1));
            int nAddress = num / 1000;
            int bitNum = num - nAddress * 1000;
            nName = String.valueOf(prefix) + type + Integer.toString(nAddress * 1000 + bitNum);
        } else {
            int nAddress = Integer.parseInt(s);
            int bitNum = Integer.parseInt(systemName.substring(k, systemName.length()));
            nName = String.valueOf(prefix) + type + Integer.toString(nAddress) + "B" + Integer.toString(bitNum);
        }
        return nName;
    }
}

