/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rps.trackingpanel;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import javax.vecmath.Point3d;
import jmri.jmrix.rps.Distributor;
import jmri.jmrix.rps.Engine;
import jmri.jmrix.rps.Measurement;
import jmri.jmrix.rps.MeasurementListener;
import jmri.jmrix.rps.Model;
import jmri.jmrix.rps.Receiver;
import jmri.jmrix.rps.Region;
import jmri.jmrix.rps.RpsSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpsTrackingPanel
extends JPanel
implements MeasurementListener {
    RpsSystemConnectionMemo memo = null;
    boolean showErrors = false;
    boolean showReceivers = false;
    boolean showRegions = false;
    double xorigin;
    double yorigin;
    double xmax;
    double ymax;
    static final double MEASUREMENT_ACCURACY = 0.2;
    static final double RECEIVER_SIZE = 0.75;
    static final Color regionFillColor = Color.GRAY.brighter();
    static final Color regionOutlineColor = Color.GRAY.darker();
    int measurementColor = 0;
    AffineTransform currentAT;
    ArrayList<MeasurementRep> measurementRepList = new ArrayList();
    HashMap<String, TransmitterStatus> transmitters = new HashMap();
    static final int MAXREPLISTSIZE = 1000;
    private static final Logger log = LoggerFactory.getLogger(RpsTrackingPanel.class);

    public RpsTrackingPanel(RpsSystemConnectionMemo _memo) {
        this.memo = _memo;
        Distributor.instance().addMeasurementListener(this);
        this.setToolTipText("<no item>");
    }

    public void dispose() {
        Distributor.instance().removeMeasurementListener(this);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        try {
            Point mouse = e.getPoint();
            Point2D userPt = this.currentAT.inverseTransform(new Point2D.Double(mouse.x, mouse.y), null);
            int i = this.measurementRepList.size() - 1;
            while (i >= 0) {
                MeasurementRep r = this.measurementRepList.get(i);
                if (r.contains(userPt)) {
                    Measurement m = r.measurement;
                    return "ID " + m.getId() + " at " + m.getX() + "," + m.getY();
                }
                --i;
            }
            List<Region> l = Model.instance().getRegions();
            int i2 = l.size() - 1;
            while (i2 >= 0) {
                Shape s = l.get(i2).getPath();
                if (s.contains(userPt)) {
                    return "Region: " + l.get(i2).toString() + ", at " + userPt.getX() + "," + userPt.getY();
                }
                --i2;
            }
            return userPt.getX() + "," + userPt.getY();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setOrigin(double x, double y) {
        this.xorigin = x;
        this.yorigin = y;
    }

    void setShowErrors(boolean show) {
        this.showErrors = show;
    }

    void setShowReceivers(boolean show) {
        this.showReceivers = show;
    }

    void setShowRegions(boolean show) {
        this.showRegions = show;
    }

    public void setCoordMax(double x, double y) {
        this.xmax = x;
        this.ymax = y;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        log.debug("paint invoked");
        Graphics2D g2 = (Graphics2D)g;
        double xscale = (double)this.getWidth() / (this.xmax - this.xorigin);
        double yscale = (double)this.getHeight() / (this.ymax - this.yorigin);
        BasicStroke stroke = new BasicStroke((float)(2.0 / xscale), 1, 1);
        g2.setStroke(stroke);
        AffineTransform saveAT = g2.getTransform();
        this.currentAT = new AffineTransform();
        this.currentAT.translate(0.0, this.getHeight());
        this.currentAT.scale(xscale, -yscale);
        this.currentAT.translate(-this.xorigin, -this.yorigin);
        g2.setTransform(this.currentAT);
        if (this.showRegions) {
            List<Region> l = Model.instance().getRegions();
            int i = 0;
            while (i < l.size()) {
                g2.setPaint(regionOutlineColor);
                g2.draw(l.get(i).getPath());
                g2.setPaint(regionFillColor);
                g2.fill(l.get(i).getPath());
                ++i;
            }
        }
        int i = 0;
        while (i < this.measurementRepList.size()) {
            this.measurementRepList.get(i).draw(g2);
            ++i;
        }
        if (this.showReceivers) {
            i = 1;
            while (i < Engine.instance().getMaxReceiverNumber() + 1) {
                Receiver r = Engine.instance().getReceiver(i);
                Point3d p = Engine.instance().getReceiverPosition(i);
                if (p != null && r != null) {
                    if (r.isActive()) {
                        g2.setPaint(Color.BLACK);
                    } else {
                        g2.setPaint(Color.GRAY);
                    }
                    Ellipse2D.Double s = new Ellipse2D.Double(p.x - 0.375, p.y - 0.375, 0.75, 0.75);
                    g2.draw(s);
                    g2.fill(s);
                }
                ++i;
            }
        }
        g2.setTransform(saveAT);
    }

    Color nextColor() {
        int red = Math.min(255, (this.measurementColor >> 2 & 1) * 255 / 1);
        int green = Math.min(255, (this.measurementColor >> 1 & 1) * 255 / 1);
        int blue = Math.min(255, (this.measurementColor >> 0 & 1) * 255 / 1);
        ++this.measurementColor;
        return new Color(red, green, blue);
    }

    @Override
    public void notify(Measurement m) {
        String id = m.getId();
        TransmitterStatus transmitter = this.transmitters.get(id);
        double xend = m.getX();
        double yend = m.getY();
        log.debug("notify {},{}", (Object)xend, (Object)yend);
        if (transmitter == null) {
            log.debug("create new TransmitterStatus for {}", (Object)m.getId());
            transmitter = new TransmitterStatus();
            transmitter.measurement = m;
            transmitter.color = this.nextColor();
            this.transmitters.put(id, transmitter);
            MeasurementRep r = new MeasurementRep();
            r.color = transmitter.color;
            r.rep1 = new Ellipse2D.Double(xend - 0.1, yend - 0.1, 0.2, 0.2);
            r.measurement = m;
            this.measurementRepList.add(r);
            this.pruneMeasurementRepList();
            return;
        }
        Measurement lastMessage = transmitter.measurement;
        MeasurementRep r = new MeasurementRep();
        r.color = transmitter.color;
        r.rep2 = new Ellipse2D.Double(xend - 0.1, yend - 0.1, 0.2, 0.2);
        if (this.showErrors || lastMessage.isOkPoint() && m.isOkPoint()) {
            double xinit = lastMessage.getX();
            double yinit = lastMessage.getY();
            r.rep1 = new Line2D.Double(xinit, yinit, xend, yend);
            r.measurement = m;
            this.measurementRepList.add(r);
            this.pruneMeasurementRepList();
            this.repaint(this.getBounds());
        }
        transmitter.measurement = m;
    }

    void pruneMeasurementRepList() {
        while (this.measurementRepList.size() > 1000) {
            this.measurementRepList.remove(0);
        }
    }

    void clear() {
        this.measurementRepList = new ArrayList();
        this.repaint(this.getBounds());
    }

    static class MeasurementRep {
        Color color;
        Shape rep1;
        Shape rep2;
        Measurement measurement;

        MeasurementRep() {
        }

        void draw(Graphics2D g2) {
            g2.setPaint(this.color);
            g2.draw(this.rep1);
            if (this.rep2 != null) {
                g2.draw(this.rep2);
            }
        }

        boolean contains(Point2D pt) {
            if (this.rep1.contains(pt)) {
                return true;
            }
            return this.rep2 != null && this.rep2.contains(pt);
        }
    }

    static class TransmitterStatus {
        Color color;
        Measurement measurement;

        TransmitterStatus() {
        }
    }
}

