/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rps.swing.polling;

import javax.swing.JComboBox;
import javax.swing.table.AbstractTableModel;
import jmri.ModifiedFlag;
import jmri.jmrix.rps.Distributor;
import jmri.jmrix.rps.Engine;
import jmri.jmrix.rps.Measurement;
import jmri.jmrix.rps.MeasurementListener;
import jmri.jmrix.rps.swing.polling.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollDataModel
extends AbstractTableModel
implements MeasurementListener {
    static final int NAMECOL = 0;
    static final int IDCOL = 1;
    static final int ADDRCOL = 2;
    static final int LONGCOL = 3;
    static final int POLLCOL = 4;
    static final int LASTXCOL = 5;
    static final int LASTYCOL = 6;
    static final int LASTZCOL = 7;
    static final int LASTTIME = 8;
    static final int LAST = 8;
    ModifiedFlag modifiedFlag;
    static final int TYPECOL = -1;
    private static final Logger log = LoggerFactory.getLogger(PollDataModel.class);

    public PollDataModel(ModifiedFlag flag) {
        this.modifiedFlag = flag;
        Distributor.instance().addMeasurementListener(this);
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 9;
    }

    @Override
    public int getRowCount() {
        return Engine.instance().getNumTransmitters();
    }

    @Override
    public String getColumnName(int c) {
        switch (c) {
            case 0: {
                return Bundle.getMessage("TitleName");
            }
            case 1: {
                return Bundle.getMessage("TitleIdCol");
            }
            case 2: {
                return Bundle.getMessage("TitleAddrCol");
            }
            case 3: {
                return Bundle.getMessage("TitleLongCol");
            }
            case 4: {
                return Bundle.getMessage("TitlePollCol");
            }
            case -1: {
                return Bundle.getMessage("TitleTypeCol");
            }
            case 5: {
                return Bundle.getMessage("TitleXCol");
            }
            case 6: {
                return Bundle.getMessage("TitleYCol");
            }
            case 7: {
                return Bundle.getMessage("TitleZCol");
            }
            case 8: {
                return Bundle.getMessage("TitleTime");
            }
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int c) {
        if (c == 3 || c == 4) {
            return Boolean.class;
        }
        if (c == 2 || c == 8) {
            return Integer.class;
        }
        if (c == -1) {
            return JComboBox.class;
        }
        if (c == 5 || c == 6 || c == 7) {
            return Double.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        return c == 1 || c == 4 || c == -1;
    }

    @Override
    public Object getValueAt(int r, int c) {
        if (Engine.instance() == null) {
            log.warn("returning null because of missing Engine.instance()");
        }
        if (Engine.instance().getTransmitter(r) == null) {
            log.warn("returning null because of missing Engine.instance().getTransmitter({})", (Object)r);
        }
        switch (c) {
            case 0: {
                return Engine.instance().getTransmitter(r).getRosterName();
            }
            case 1: {
                return Engine.instance().getTransmitter(r).getId();
            }
            case 2: {
                return Engine.instance().getTransmitter(r).getAddress();
            }
            case 3: {
                return Engine.instance().getTransmitter(r).isLongAddress();
            }
            case 4: {
                return Engine.instance().getTransmitter(r).isPolled();
            }
            case -1: {
                JComboBox<String> b = new JComboBox<String>(new String[]{"F2", "F3", "BSCI"});
                return b;
            }
            case 5: {
                Measurement m = Engine.instance().getTransmitter(r).getLastMeasurement();
                if (m == null) {
                    return null;
                }
                double val = m.getX();
                return val;
            }
            case 6: {
                Measurement m = Engine.instance().getTransmitter(r).getLastMeasurement();
                if (m == null) {
                    return null;
                }
                double val = m.getY();
                return val;
            }
            case 7: {
                Measurement m = Engine.instance().getTransmitter(r).getLastMeasurement();
                if (m == null) {
                    return null;
                }
                double val = m.getZ();
                return val;
            }
            case 8: {
                Measurement m = Engine.instance().getTransmitter(r).getLastMeasurement();
                if (m == null) {
                    return null;
                }
                int time = m.getReading().getTime();
                return time;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int r, int c) {
        switch (c) {
            case 1: {
                String s = (String)value;
                Engine.instance().getTransmitter(r).setId(s);
                this.modifiedFlag.setModifiedFlag(true);
                return;
            }
            case 4: {
                boolean p = (Boolean)value;
                Engine.instance().getTransmitter(r).setPolled(p);
                this.modifiedFlag.setModifiedFlag(true);
                return;
            }
            case -1: {
                log.error("Got {} but did not act", ((JComboBox)value).getSelectedItem());
                break;
            }
            default: {
                log.warn("Unhandled col {}", (Object)c);
            }
        }
    }

    @Override
    public void notify(Measurement m) {
        this.fireTableDataChanged();
    }

    public void dispose() {
        Distributor.instance().removeMeasurementListener(this);
    }
}

