/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rps.serial;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import javax.swing.SwingUtilities;
import jmri.InvokeOnGuiThread;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.rps.Distributor;
import jmri.jmrix.rps.Engine;
import jmri.jmrix.rps.Reading;
import jmri.jmrix.rps.RpsSystemConnectionMemo;
import jmri.jmrix.rps.serial.Bundle;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import purejavacomm.CommPortIdentifier;
import purejavacomm.NoSuchPortException;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import purejavacomm.UnsupportedCommOperationException;

public class SerialAdapter
extends AbstractSerialPortController {
    transient SerialPort activeSerialPort = null;
    protected String[] validSpeeds = new String[]{Bundle.getMessage("Baud115200")};
    protected int[] validSpeedValues = new int[]{115200};
    String[] validOptions1 = new String[]{Bundle.getMessage("Version1Choice"), Bundle.getMessage("Version2Choice")};
    private boolean opened = false;
    transient DataInputStream serialStream = null;
    volatile OutputStream ostream = null;
    int[] offsetArray = null;
    static volatile SerialAdapter mInstance = null;
    Thread readerThread;
    int version = 1;
    private static final int SKIPCOLS = 0;
    private boolean first = true;
    private static final Logger log = LoggerFactory.getLogger(SerialAdapter.class);

    public SerialAdapter() {
        super(new RpsSystemConnectionMemo());
        this.option1Name = "Protocol";
        this.options.put(this.option1Name, new AbstractPortController.Option(Bundle.getMessage("ProtocolVersionLabel"), this.validOptions1));
        this.manufacturerName = "NAC Services";
    }

    @Override
    public RpsSystemConnectionMemo getSystemConnectionMemo() {
        return (RpsSystemConnectionMemo)super.getSystemConnectionMemo();
    }

    @Override
    public void configure() {
        log.debug("configure() connecting RPS objects");
        Engine e = Engine.instance();
        Distributor.instance().addReadingListener(e);
        this.readerThread = new Thread(new Reader());
        this.readerThread.start();
        this.getSystemConnectionMemo().configureManagers();
    }

    @Override
    public synchronized String openPort(String portName, String appName) {
        try {
            CommPortIdentifier portID = CommPortIdentifier.getPortIdentifier(portName);
            try {
                this.activeSerialPort = (SerialPort)portID.open(appName, 2000);
            }
            catch (PortInUseException p) {
                return this.handlePortBusy(p, portName, log);
            }
            try {
                int baud = this.currentBaudNumber(this.mBaudRate);
                this.activeSerialPort.setSerialPortParams(baud, 8, 1, 0);
            }
            catch (UnsupportedCommOperationException e) {
                log.error("Cannot set serial parameters on port {}: {}", (Object)portName, (Object)e.getMessage());
                return "Cannot set serial parameters on port " + portName + ": " + e.getMessage();
            }
            this.configureLeadsAndFlowControl(this.activeSerialPort, 0);
            log.debug("Serial timeout was observed as: {} {}", (Object)this.activeSerialPort.getReceiveTimeout(), (Object)this.activeSerialPort.isReceiveTimeoutEnabled());
            this.serialStream = new DataInputStream(this.activeSerialPort.getInputStream());
            this.ostream = this.activeSerialPort.getOutputStream();
            this.sendBytes(new byte[]{65, 13});
            this.purgeStream(this.serialStream);
            if (log.isInfoEnabled()) {
                log.info("{} port opened at {} baud, sees  DTR: {} RTS: {} DSR: {} CTS: {}  CD: {}", new Object[]{portName, this.activeSerialPort.getBaudRate(), this.activeSerialPort.isDTR(), this.activeSerialPort.isRTS(), this.activeSerialPort.isDSR(), this.activeSerialPort.isCTS(), this.activeSerialPort.isCD()});
            }
            this.opened = true;
        }
        catch (NoSuchPortException p) {
            return this.handlePortNotFound(p, portName, log);
        }
        catch (IOException ex) {
            log.error("Unexpected exception while opening port {}", (Object)portName, (Object)ex);
            return "Unexpected error while opening port " + portName + ": " + ex;
        }
        return null;
    }

    synchronized void sendBytes(byte[] bytes) {
        try {
            int i = 0;
            while (i < bytes.length - 1) {
                this.ostream.write(bytes[i]);
                this.wait(3L);
                ++i;
            }
            byte endbyte = bytes[bytes.length - 1];
            this.ostream.write(endbyte);
        }
        catch (IOException e) {
            log.error("Exception on output: ", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("Interrupted output: ", (Throwable)e);
        }
    }

    @Override
    public synchronized DataInputStream getInputStream() {
        if (!this.opened) {
            log.error("getInputStream called before load(), stream not available");
            return null;
        }
        return new DataInputStream(this.serialStream);
    }

    @Override
    public synchronized DataOutputStream getOutputStream() {
        if (!this.opened) {
            log.error("getOutputStream called before load(), stream not available");
        }
        try {
            return new DataOutputStream(this.activeSerialPort.getOutputStream());
        }
        catch (IOException e) {
            log.error("getOutputStream exception: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public String[] validBaudRates() {
        return Arrays.copyOf(this.validSpeeds, this.validSpeeds.length);
    }

    @Override
    public int[] validBaudNumbers() {
        return Arrays.copyOf(this.validSpeedValues, this.validSpeedValues.length);
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }

    @Override
    public void configureOption1(String value) {
        this.setOptionState(this.option1Name, value);
        if (value.equals(this.validOptions1[0])) {
            this.version = 1;
        } else if (value.equals(this.validOptions1[1])) {
            this.version = 2;
        }
    }

    @Deprecated
    public static SerialAdapter instance() {
        if (mInstance == null) {
            mInstance = new SerialAdapter();
        }
        return mInstance;
    }

    @InvokeOnGuiThread
    protected void nextLine(String s) {
        Reading r;
        if (s.length() < 5) {
            return;
        }
        if (s.startsWith("DATA,,")) {
            this.setReceivers(s);
            return;
        }
        try {
            r = this.makeReading(s);
        }
        catch (IOException e) {
            log.error("Exception formatting input line \"{}\": ", (Object)s, (Object)e);
            return;
        }
        if (r == null) {
            return;
        }
        try {
            Distributor.instance().submitReading(r);
        }
        catch (Exception e) {
            log.error("Exception forwarding reading: ", (Throwable)e);
        }
    }

    void setReceivers(String s) {
        try {
            CSVParser c = CSVParser.parse((String)s, (CSVFormat)CSVFormat.DEFAULT);
            CSVRecord r = (CSVRecord)c.getRecords().get(0);
            c.close();
            int n = r.size() - 2;
            log.debug("Found {} receivers", (Object)n);
            int max = Integer.parseInt(r.get(r.size() - 1));
            log.debug("Highest receiver address is {}", (Object)max);
            this.offsetArray = new int[n];
            int i = 0;
            while (i < n) {
                this.offsetArray[i] = Integer.parseInt(r.get(i + 2));
                ++i;
            }
        }
        catch (IOException e) {
            log.debug("Did not handle init message <{}> due to {}", (Object)s, (Object)e);
        }
    }

    Reading makeReading(String s) throws IOException {
        if (this.first) {
            log.info("RPS starts, using protocol version {}", (Object)this.version);
            this.first = false;
        }
        if (this.version == 1) {
            CSVParser c = CSVParser.parse((String)s, (CSVFormat)CSVFormat.DEFAULT);
            CSVRecord record = (CSVRecord)c.getRecords().get(0);
            c.close();
            int count = record.size() - 0;
            double[] vals = new double[count + 1];
            int i = 1;
            while (i < count + 1) {
                vals[i] = Double.valueOf(record.get(i + 0 - 1));
                ++i;
            }
            return new Reading(Engine.instance().getPolledID(), vals, s);
        }
        if (this.version == 2) {
            CSVParser c = CSVParser.parse((String)s, (CSVFormat)CSVFormat.DEFAULT);
            CSVRecord record = (CSVRecord)c.getRecords().get(0);
            c.close();
            int count = (record.size() - 2) / 2;
            double[] vals = new double[Engine.instance().getMaxReceiverNumber() + 1];
            int i = 0;
            while (i < vals.length) {
                vals[i] = 0.0;
                ++i;
            }
            try {
                i = 0;
                while (i < count) {
                    int index = Integer.parseInt(record.get(2 + i * 2));
                    if (index >= 0) {
                        if (index >= vals.length) {
                            log.warn("Data from unexpected receiver {}, creating receiver", (Object)index);
                            Engine.instance().setMaxReceiverNumber(index + 1);
                        }
                        if (index < vals.length) {
                            vals[index] = Double.valueOf(record.get(2 + i * 2 + 1));
                        }
                    }
                    ++i;
                }
            }
            catch (NumberFormatException e) {
                log.warn("Exception handling input.", (Throwable)e);
                return null;
            }
            return new Reading(Engine.instance().getPolledID(), vals, s);
        }
        log.error("can't handle version {}", (Object)this.version);
        return null;
    }

    class Reader
    implements Runnable {
        static final int maxMsg = 200;
        StringBuffer msg;
        String msgString;

        Reader() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.handleIncomingData();
                    }
                }
                catch (IOException e) {
                    log.warn("run: Exception: ", (Throwable)e);
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleIncomingData() throws IOException {
            this.msg = new StringBuffer(200);
            int i = 0;
            while (i < 200) {
                char char1;
                SerialAdapter serialAdapter = SerialAdapter.this;
                synchronized (serialAdapter) {
                    char1 = (char)SerialAdapter.this.serialStream.readByte();
                }
                if (char1 == '\r') break;
                if (char1 != '\n') {
                    this.msg.append(char1);
                }
                ++i;
            }
            this.msgString = this.msg.toString();
            log.debug("Msg <{}>", (Object)this.msgString);
            Runnable r = new Runnable(){
                String msgForLater;
                {
                    this.msgForLater = Reader.this.msgString;
                }

                @Override
                public void run() {
                    SerialAdapter.this.nextLine(this.msgForLater);
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }
}

