/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rps;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3d;
import jmri.implementation.AbstractSensor;
import jmri.jmrix.rps.Measurement;
import jmri.jmrix.rps.MeasurementListener;
import jmri.jmrix.rps.Model;
import jmri.jmrix.rps.Region;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpsSensor
extends AbstractSensor
implements MeasurementListener {
    transient Region region;
    ArrayList<Integer> contents = new ArrayList();
    private static final Logger log = LoggerFactory.getLogger(RpsSensor.class);

    public RpsSensor(String systemName, String prefix) {
        super(systemName);
        this.region = new Region(systemName.substring(prefix.length() + 1));
        Model.instance().addRegion(this.region);
    }

    public RpsSensor(String systemName, String userName, String prefix) {
        super(systemName, userName);
        this.region = new Region(systemName.substring(prefix.length() + 1));
        Model.instance().addRegion(this.region);
    }

    @Override
    public void notify(Measurement r) {
        Point3d p = new Point3d(r.getX(), r.getY(), r.getZ());
        Integer id = Integer.valueOf(r.getReading().getId());
        if (!r.isOkPoint()) {
            return;
        }
        if (r.getZ() > 20.0 || r.getZ() < -20.0) {
            return;
        }
        log.debug("starting {}", (Object)this.getSystemName());
        if (this.region.isInside(p)) {
            this.notifyInRegion(id);
        } else {
            this.notifyOutOfRegion(id);
        }
        if (this.contents.size() > 0) {
            this.setOwnState(2);
        } else {
            this.setOwnState(4);
        }
    }

    @Override
    public void setOwnState(int state) {
        if (state == 4 && this.contents.size() > 0) {
            this.contents = new ArrayList();
        }
        super.setOwnState(state);
    }

    Region getRegion() {
        return this.region;
    }

    List<Integer> getContents() {
        return this.contents;
    }

    void notifyInRegion(Integer id) {
        if (!this.contents.contains(id)) {
            this.contents.add(id);
            this.notifyArriving(id);
        }
    }

    void notifyOutOfRegion(Integer id) {
        if (this.contents.contains(id)) {
            this.contents.remove(id);
            this.notifyLeaving(id);
        }
    }

    void notifyLeaving(Integer id) {
        this.firePropertyChange("Leaving", null, id);
    }

    void notifyArriving(Integer id) {
        this.firePropertyChange("Arriving", null, id);
    }

    @Override
    public void dispose() {
        Model.instance().removeRegion(this.region);
        super.dispose();
    }

    @Override
    public void requestUpdateFromLayout() {
    }
}

