/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rps;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.Manager;
import jmri.Reporter;
import jmri.jmrix.rps.Bundle;
import jmri.jmrix.rps.Distributor;
import jmri.jmrix.rps.RpsReporter;
import jmri.jmrix.rps.RpsSystemConnectionMemo;
import jmri.managers.AbstractReporterManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpsReporterManager
extends AbstractReporterManager {
    private static final Logger log = LoggerFactory.getLogger(RpsReporterManager.class);

    public RpsReporterManager(RpsSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    public RpsSystemConnectionMemo getMemo() {
        return (RpsSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Reporter createNewReporter(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        log.debug("creating {}", (Object)userName);
        RpsReporter r = new RpsReporter(systemName, userName, this.getSystemPrefix());
        Distributor.instance().addMeasurementListener(r);
        return r;
    }

    @Override
    public String createSystemName(String curAddress, String prefix) throws JmriException {
        if (!prefix.equals(this.getSystemPrefix())) {
            log.warn("prefix does not match memo.prefix");
            throw new JmriException("Unable to convert " + curAddress + ", Prefix does not match");
        }
        String sys = String.valueOf(this.getSystemPrefix()) + this.typeLetter() + curAddress;
        try {
            this.validSystemNameFormat(sys);
        }
        catch (IllegalArgumentException e) {
            throw new JmriException(e.getMessage());
        }
        return sys;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) {
        return this.getMemo().validateSystemNameFormat(name, this, locale);
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        return this.getMemo().validSystemNameFormat(systemName, this.typeLetter());
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddReporterEntryToolTip");
    }
}

