/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rps;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.vecmath.Point3d;
import jmri.jmrit.XmlFile;
import jmri.jmrix.rps.Reading;
import jmri.jmrix.rps.Receiver;
import jmri.util.FileUtil;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.ProcessingInstruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PositionFile
extends XmlFile {
    Document doc;
    Element root;
    private static final Logger log = LoggerFactory.getLogger(PositionFile.class);

    public void prepare() {
        this.root = new Element("rpsfile");
        this.doc = PositionFile.newDocument(this.root, String.valueOf(this.dtdLocation) + "rpsfile.dtd");
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("type", "text/xsl");
        m.put("href", "/xml/XSLT/rpsfile.xsl");
        ProcessingInstruction p = new ProcessingInstruction("xml-stylesheet", m);
        this.doc.addContent(0, (Content)p);
    }

    public void setConstants(double vSound, int offset, String algorithm) {
        Element v = new Element("vsound");
        v.addContent("" + vSound);
        this.root.addContent((Content)v);
        Element o = new Element("offset");
        o.addContent("" + offset);
        this.root.addContent((Content)o);
        Element a = new Element("algorithm");
        a.addContent(algorithm);
        this.root.addContent((Content)a);
    }

    public void setReceiver(int n, Receiver r) {
        Element e = new Element("receiver");
        e.setAttribute("number", "" + n);
        e.setAttribute("active", r.isActive() ? "true" : "false");
        e.setAttribute("mintime", "" + r.getMinTime());
        e.setAttribute("maxtime", "" + r.getMaxTime());
        e.addContent((Content)this.positionElement(r.getPosition()));
        this.root.addContent((Content)e);
    }

    public void setReceiver(int n, Point3d p, boolean active) {
        Element e = new Element("receiver");
        e.setAttribute("number", "" + n);
        e.setAttribute("active", active ? "true" : "false");
        e.addContent((Content)this.positionElement(p));
        this.root.addContent((Content)e);
    }

    public void setCalibrationPoint(Point3d p, Reading r) {
        Element e = new Element("calibrationpoint");
        e.addContent((Content)this.positionElement(p));
        e.addContent((Content)this.readingElement(r));
        this.root.addContent((Content)e);
    }

    Element positionElement(Point3d p) {
        Element e = new Element("position");
        Element x = new Element("x");
        x.addContent("" + p.x);
        e.addContent((Content)x);
        Element y = new Element("y");
        y.addContent("" + p.y);
        e.addContent((Content)y);
        Element z = new Element("z");
        z.addContent("" + p.z);
        e.addContent((Content)z);
        return e;
    }

    public Point3d positionFromElement(Element position) {
        Element e = position.getChild("x");
        float x = Float.parseFloat(e.getText());
        e = position.getChild("y");
        float y = Float.parseFloat(e.getText());
        e = position.getChild("z");
        float z = Float.parseFloat(e.getText());
        return new Point3d((double)x, (double)y, (double)z);
    }

    Element readingElement(Reading r) {
        Element e = new Element("reading");
        Element c = new Element("id");
        c.addContent(r.getId());
        e.addContent((Content)c);
        int i = 1;
        while (i <= r.getNValues()) {
            e.addContent((Content)this.timeElement(r.getValue(i)));
            ++i;
        }
        return e;
    }

    public Reading readingFromElement(Element reading) {
        String id = reading.getChild("id").getText();
        List kids = reading.getChildren("time");
        int count = kids.size();
        double[] vals = new double[count + 1];
        int i = 0;
        while (i < count) {
            double val;
            Element e = (Element)kids.get(i);
            vals[i + 1] = val = Double.parseDouble(e.getText());
            ++i;
        }
        return new Reading(id, vals);
    }

    Element timeElement(double time) {
        Element e = new Element("time");
        e.addContent("" + time);
        return e;
    }

    public void store(File file) throws IOException {
        this.writeXML(file, this.doc);
    }

    public void loadFile(File f) throws JDOMException, IOException {
        this.root = this.rootFromFile(f);
    }

    public double getVSound() {
        Element e = this.root.getChild("vsound");
        return Double.parseDouble(e.getText());
    }

    public int getOffset() {
        Element e = this.root.getChild("offset");
        return Integer.parseInt(e.getText());
    }

    public String getAlgorithm() {
        Element e = this.root.getChild("algorithm");
        return e.getText();
    }

    public int maxReceiver() {
        List kids = this.root.getChildren("receiver");
        int max = -1;
        int i = 0;
        while (i < kids.size()) {
            Attribute a = ((Element)kids.get(i)).getAttribute("number");
            if (a != null) {
                int n = -1;
                try {
                    n = a.getIntValue();
                }
                catch (DataConversionException e) {
                    log.error("in maxReceiver", (Throwable)e);
                }
                max = Math.max(max, n);
            }
            ++i;
        }
        return max;
    }

    public Point3d getReceiverPosition(int n) {
        List kids = this.root.getChildren("receiver");
        int i = 0;
        while (i < kids.size()) {
            Element e = (Element)kids.get(i);
            Attribute a = e.getAttribute("number");
            if (a != null) {
                int num = -1;
                try {
                    num = a.getIntValue();
                }
                catch (DataConversionException ex) {
                    log.error("in getReceiverPosition", (Throwable)ex);
                }
                if (num == n) {
                    return this.positionFromElement(e.getChild("position"));
                }
            }
            ++i;
        }
        return null;
    }

    public boolean getReceiverActive(int n) {
        List kids = this.root.getChildren("receiver");
        int i = 0;
        while (i < kids.size()) {
            Element e = (Element)kids.get(i);
            Attribute a = e.getAttribute("number");
            if (a != null) {
                int num = -1;
                try {
                    num = a.getIntValue();
                }
                catch (DataConversionException ex) {
                    log.error("in getReceiverActive", (Throwable)ex);
                }
                if (num == n) {
                    a = e.getAttribute("active");
                    if (a == null) {
                        return true;
                    }
                    return !a.getValue().equals("false");
                }
            }
            ++i;
        }
        return true;
    }

    public int getReceiverMin(int n) {
        List kids = this.root.getChildren("receiver");
        int i = 0;
        while (i < kids.size()) {
            Element e = (Element)kids.get(i);
            Attribute a = e.getAttribute("number");
            if (a != null) {
                int num = -1;
                try {
                    num = a.getIntValue();
                }
                catch (DataConversionException ex1) {
                    log.error("in getReceiverMin", (Throwable)ex1);
                }
                if (num == n) {
                    a = e.getAttribute("mintime");
                    if (a == null) {
                        return 0;
                    }
                    try {
                        return a.getIntValue();
                    }
                    catch (DataConversionException dataConversionException) {
                        return 0;
                    }
                }
            }
            ++i;
        }
        return 0;
    }

    public int getReceiverMax(int n) {
        List kids = this.root.getChildren("receiver");
        int i = 0;
        while (i < kids.size()) {
            Element e = (Element)kids.get(i);
            Attribute a = e.getAttribute("number");
            if (a != null) {
                int num = -1;
                try {
                    num = a.getIntValue();
                }
                catch (DataConversionException ex1) {
                    log.error("in getReceiverMax", (Throwable)ex1);
                }
                if (num == n) {
                    a = e.getAttribute("maxtime");
                    if (a == null) {
                        return 99999;
                    }
                    try {
                        return a.getIntValue();
                    }
                    catch (DataConversionException dataConversionException) {
                        return 99999;
                    }
                }
            }
            ++i;
        }
        return 99999;
    }

    public Point3d getCalibrationPosition(int n) {
        List kids = this.root.getChildren("calibrationpoint");
        if (n >= kids.size()) {
            return null;
        }
        Element e = (Element)kids.get(n);
        return this.positionFromElement(e.getChild("position"));
    }

    public Reading getCalibrationReading(int n) {
        List kids = this.root.getChildren("calibrationpoint");
        if (n >= kids.size()) {
            return null;
        }
        Element e = (Element)kids.get(n);
        return this.readingFromElement(e.getChild("reading"));
    }

    public static String defaultLocation() {
        String location = String.valueOf(FileUtil.getUserFilesPath()) + "rps" + File.separator;
        FileUtil.createDirectory(location);
        return location;
    }

    public static String defaultFilename() {
        return String.valueOf(PositionFile.defaultLocation()) + "positions.xml";
    }
}

