/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rps;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import jmri.jmrit.XmlFile;
import jmri.jmrix.rps.Engine;
import jmri.util.FileUtil;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.ProcessingInstruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingFile
extends XmlFile {
    Document doc;
    Element root;
    private static final Logger log = LoggerFactory.getLogger(PollingFile.class);

    public void prepare() {
        this.root = new Element("rpsfile");
        this.doc = PollingFile.newDocument(this.root, String.valueOf(this.dtdLocation) + "rpsroster-2-3-8.dtd");
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("type", "text/xsl");
        m.put("href", "/xml/XSLT/rpsroster.xsl");
        ProcessingInstruction p = new ProcessingInstruction("xml-stylesheet", m);
        this.doc.addContent(0, (Content)p);
    }

    public void setPoll() {
        Element v = new Element("poll");
        v.setAttribute("active", Engine.instance().getPolling() ? "true" : "false");
        v.setAttribute("interval", "" + Engine.instance().getPollingInterval());
        v.setAttribute("bscpoll", Engine.instance().getBscPollMode() ? "true" : "false");
        v.setAttribute("throttlepoll", Engine.instance().getThrottlePollMode() ? "true" : "false");
        this.root.addContent((Content)v);
    }

    public void setTransmitter(int r) {
        Element e = new Element("transmitter");
        if (Engine.instance().getTransmitter(r).getRosterName() != null) {
            e.setAttribute("rostername", Engine.instance().getTransmitter(r).getRosterName());
        } else {
            e.setAttribute("id", Engine.instance().getTransmitter(r).getId());
        }
        e.setAttribute("id", Engine.instance().getTransmitter(r).getId());
        e.setAttribute("address", "" + Engine.instance().getTransmitter(r).getAddress());
        e.setAttribute("long", Engine.instance().getTransmitter(r).isLongAddress() ? "true" : "false");
        e.setAttribute("poll", Engine.instance().getTransmitter(r).isPolled() ? "true" : "false");
        this.root.addContent((Content)e);
    }

    public void store(File file) throws IOException {
        this.writeXML(file, this.doc);
    }

    public void loadFile(File f) throws JDOMException, IOException {
        this.root = this.rootFromFile(f);
    }

    public void getPollValues() {
        Element e = this.root.getChild("poll");
        Attribute a = e.getAttribute("active");
        boolean poll = false;
        if (a != null && a.getValue().equals("true")) {
            poll = true;
        }
        Engine.instance().setPolling(poll);
        a = e.getAttribute("interval");
        int value = 0;
        try {
            if (a != null) {
                value = a.getIntValue();
            }
        }
        catch (DataConversionException ex) {
            log.error("in getPollValues ", (Throwable)ex);
        }
        Engine.instance().setPollingInterval(value);
        Engine.instance().setDirectPollMode();
        a = e.getAttribute("bscpoll");
        boolean bscpoll = false;
        if (a != null && a.getValue().equals("true")) {
            bscpoll = true;
        }
        if (bscpoll) {
            Engine.instance().setBscPollMode();
        }
        a = e.getAttribute("throttlepoll");
        boolean throttlepoll = false;
        if (a != null && a.getValue().equals("true")) {
            throttlepoll = true;
        }
        if (throttlepoll) {
            Engine.instance().setThrottlePollMode();
        }
    }

    public void getTransmitters(Engine engine) {
        List l = this.root.getChildren("transmitter");
        int i = 0;
        while (i < l.size()) {
            Element e = (Element)l.get(i);
            String id = e.getAttribute("id").getValue();
            if (e.getAttribute("rostername") != null) {
                id = e.getAttribute("rostername").getValue();
            } else {
                log.warn("Using ID as roster name for {}, please save your polling information to remove this warning", (Object)id);
            }
            int j = 0;
            while (j < engine.getNumTransmitters()) {
                if (engine.getTransmitter(j).getRosterName().equals(id)) {
                    Attribute a = e.getAttribute("poll");
                    boolean poll = false;
                    if (a != null && a.getValue().equals("true")) {
                        poll = true;
                    }
                    engine.getTransmitter(j).setPolled(poll);
                    engine.getTransmitter(j).setId(e.getAttribute("id").getValue());
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    public static String defaultLocation() {
        String location = String.valueOf(FileUtil.getUserFilesPath()) + "rps" + File.separator;
        FileUtil.createDirectory(location);
        return location;
    }

    public static String defaultFilename() {
        return String.valueOf(PollingFile.defaultLocation()) + "roster.xml";
    }
}

